/* ------- */
/* ceill.c */
/*
 * ceill(Arg) returns the smallest integer not less than Arg.
 * It truncates toward plus infinity.
 *
 */

/*
 * Written for DJGPP/GCC by KB Williams,
 * kbwms@aol.com, March 2001
*/
#include <fenv.h>
#include <fdlibml.h>

# if defined __STDC__
long double ceill(long double Arg)
# else
long double ceill(Arg)
long double Arg;
# endif
{
    long double Retval;
    int		CrntRndDir;

    CrntRndDir = fegetround();
    fesetround(FE_UPWARD);

    ROUND_TO_INT(Arg, Retval);

    fesetround(CrntRndDir);

    return Retval;
}
# if defined TEST_CEIL
#include <fdlibml.h>
LDBL	ceill(LDBL);

#include <stdio.h>
#include <stdlib.h>
int
main(void)
{
    long double Arg, Retval;

    Arg = 0.0L;
    Retval = ceill(Arg);
    printf("ceill(%+Lg) = %+Lg\n", Arg, Retval);

    Arg = -0.0L;
    Retval = ceill(Arg);
    printf("ceill(%+Lg) = %+Lg\n", Arg, Retval);

    Arg = INFINITYL;
    Retval = ceill(Arg);
    printf("ceill(%+Lg) = %+Lg\n", Arg, Retval);

    Arg = -INFINITYL;
    Retval = ceill(Arg);
    printf("ceill(%+Lg) = %+Lg\n", Arg, Retval);

    Arg = NAN;
    Retval = ceill(Arg);
    printf("ceill(%+Lg) = %+Lg\n", Arg, Retval);

    Arg = 0.1L;
    Retval = ceill(Arg);
    printf("ceill(%+Lg) = %+Lg\n", Arg, Retval);

    Arg = -0.1L;
    Retval = ceill(Arg);
    printf("ceill(%+Lg) = %+Lg\n", Arg, Retval);

    Arg = 10.1L;
    Retval = ceill(Arg);
    printf("ceill(%+Lg) = %+Lg\n", Arg, Retval);

    Arg = -10.1L;
    Retval = ceill(Arg);
    printf("ceill(%+Lg) = %+Lg\n", Arg, Retval);

    Arg = 10.0L;
    Retval = ceill(Arg);
    printf("ceill(%+Lg) = %+Lg\n", Arg, Retval);

    Arg = -10.0L;
    Retval = ceill(Arg);
    printf("ceill(%+Lg) = %+Lg\n", Arg, Retval);
    exit(0);
}
# endif
