/* acoshl.c -- long double version of acosh.c.
 * Converted to long double by KB Williams,
 * kbwms@aol.com, December 2001 & October 2003
 */

/*
 * ====================================================
 * Copyright (C) 1993 by Sun Microsystems, Inc. All rights reserved.
 *
 * Developed at SunPro, a Sun Microsystems, Inc. business.
 * Permission to use, copy, modify, and distribute this
 * software is freely granted, provided that this notice
 * is preserved.
 * ====================================================
 */

/* acoshl(x)
 * Method :
 *	Based on
 *		acoshl(x) = logl [ x + sqrtl(x*x-1) ]
 *	we have
 *		acoshl(x) := logl(x)+ln2,	if x is large; else
 *		acoshl(x) := logl(2x-1/(sqrtl(x*x-1)+x)) if x>2; else
 *		acoshl(x) := log1pl(t+sqrtl(2.0*t+t*t)); where t=x-1.
 *
 * Special cases:
 *	acoshl(x) is NaN with signal if x<1.
 *	acoshl(NaN) is NaN without signal.
 */

#include <errno.h>
#include <fdlibml.h>
#include <fenv.h>

#ifdef __STDC__
long double acoshl(long double Arg)
#else
long double acoshl(Arg)
long double Arg;
#endif
{
    long double Retval;

    if(Arg < 1.0L)
    {					
	Retval = NAN;			// Set Retval to NaN 
	__math_set_errno(EDOM);			// Set errno
	__fp_raise_except(FE_INVALID);	// Raise invalid exception
    }
    else if(!isfinitel(Arg))
    {
	Retval = Arg;
    }
    else if (Arg <= 2.0L)
    {
	long double NewArg = Arg-1;

	Retval = log1pl(NewArg + sqrtl(NewArg + NewArg + NewArg*NewArg));
    }
    else if (Arg < TWO_32)
    {
	Retval = logl(Arg+Arg -1.0L/(Arg + sqrtl((Arg+1) * (Arg-1))));
    }
    else
    {
	Retval = logl(Arg) + LOGE2L;
    }
    return Retval;
}
