#define INT3() __asm __volatile ("int $3")


/* crt1 *********************************************************************/


void _init (void);
void _fini (void);
void __exit(int status);
int main (int argc, char **argv, char **environ);


void
__crt1_startup (void)
{
    int rv;
    int argc = 1;
    char *argv[1] = { 0 };
    char *environ[1] = { 0 };
    _init();
    rv = main(argc, argv, environ);
    _fini();
    __exit(rv);
}


/* libc *********************************************************************/


#define va_arg                  __builtin_va_arg
#define va_end                  __builtin_va_end
#define va_start(ap, last_arg)  __builtin_stdarg_start((ap), (last_arg))
typedef __builtin_va_list va_list;


static void
xputc (int ch)
{
    if (ch == '\n') {
	__asm("movb $0x02, %%ah; int $0x21"::"d"('\r'):"%eax");
    }
    __asm("movb $0x02, %%ah; int $0x21"::"d"(ch):"%eax");
}


static void
xputs (const char *s)
{
    while (*s) {
        int ch = *s++;
	xputc(ch);
    }
}


static void
xputv (int x)
{
    char hexbuf[9];
    int c, i = 9;
    hexbuf[--i] = 0;
    while (i) {
        c = x & 0xf;
        if (c > 9) {
            c += 7;
        }
        c += 0x30;
        hexbuf[--i] = c;
        x >>= 4;
    }
    xputs(hexbuf);
}


void
xprintf (const char *fmt, ...)
{
    va_list ap;
    va_start(ap, fmt);
    for (;;) {
        int ch = *fmt++;
        if (ch == '%') {
            ch = *fmt++;
            if (ch == 'x') {
                int v = va_arg(ap, int);
                xputv(v);
                continue;
            } else if (ch == 's') {
                char *s = va_arg(ap, char *);
                xputs(s);
                continue;
            } else if (ch != '%') {
                xputc('%');
            }
        }
        if (!ch) {
            break;
        }
        xputc(ch);
    }
    va_end(ap);
}


/* main *********************************************************************/


typedef void (*FUNC) (void);


extern int some_var;
void __attribute__((weak)) do_something (void);


void __attribute__((constructor))
constructor (void)
{
    xprintf("%s\n", __FUNCTION__);
}


void __attribute__((destructor))
destructor (void)
{
    xprintf("%s\n", __FUNCTION__);
}


static void
execute_code (FUNC f)
{
    f();
}


void
exec_something (void)
{
    xprintf("exec_something\n");
}


int
main (int argc, char **argv, char **environ)
{
    xprintf("Hi %x\n", some_var);
    execute_code(exec_something);
    if (do_something) {
	do_something();
    }
    return 0;
}
