/*
 * dllink - dynamic linking system
 * Version:  0.1
 *
 * Copyright (C) 2005  Daniel Borca   All Rights Reserved.
 *
 * dllink is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * dllink is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNU Make; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */


		.text


	/* void elf_load_error (const char *objname) */
		.globl	elf_load_error
		.type	elf_load_error, @function
		.p2align 4
elf_load_error:
		movl	4(%esp), %ecx	/* object name */
		call	elf_put
		call	elf_msg
		.asciz	": cannot load shared object\r\n"
		ret
		.size	elf_load_error, .-elf_load_error


	/* void elf_link_error (const char *objname, const char *symname) */
		.globl	elf_link_error
		.type	elf_link_error, @function
		.p2align 4
elf_link_error:
		movl	4(%esp), %ecx	/* object name */
		call	elf_put
		call	elf_msg
		.asciz	": undefined symbol `"
		movl	8(%esp), %ecx	/* undefined symbol */
		call	elf_put
		call	elf_msg
		.asciz	"'\r\n"
		ret
		.size	elf_link_error, .-elf_link_error


		.p2align 4
		.type	elf_put, @function
elf_put:
	/* DS:ECX -> string */
		movb	$0x02, %ah
	0:
		movb	(%ecx), %dl
		incl	%ecx
		testb	%dl, %dl
		jz	1f
		int	$0x21
		jmp	0b
	1:
		ret
		.size	elf_put, .-elf_put


		.p2align 4
		.type	elf_msg, @function
elf_msg:
	/* string is on stack, return right after the string, pop stack */
		popl	%ecx
		call	elf_put
		jmp	*%ecx
		.size	elf_msg, .-elf_msg
