/*
 * dllink - dynamic linking system
 * Version:  0.1
 *
 * Copyright (C) 2005  Daniel Borca   All Rights Reserved.
 *
 * dllink is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * dllink is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNU Make; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/*
 * This code is based on crt0.S by DJ Delorie.
 */


#include "stubinfo.h"


/*****************************************************************************\
 * Interface to 32-bit executable (from stub.asm)
 *
 *   eip	according to ELF header
 *   cs		32-bit flat code segment
 *   ds		32-bit flat data segment
 *   fs		selector for transferbuffer (fs:0 is stubinfo)
 *   ss:sp	temporary stack in transferbuffer
 *   <others>	All unspecified registers have unspecified values in them.
 *
 * stubinfo_magic		"dELFstub, v M.mm"
 * stubinfo_size		bytes in stubinfo structure
 * stubinfo_minstack		minimum amount of DPMI stack space
 * stubinfo_memory_handle	DPMI memory handle
 * stubinfo_initial_size	size of initial segment
 * stubinfo_minkeep		amount of automatic real-mode buffer
 * stubinfo_ds_selector		our DS selector (used for transfer buffer)
 * stubinfo_ds_segment		our DS segment (used for simulated calls)
 * stubinfo_psp_selector	PSP selector
 * stubinfo_cs_selector		to be freed
 * stubinfo_env_size		number of bytes of environment
 * stubinfo_basename		base name of executable to load (asciiz if < 8)
 * stubinfo_argv0		used ONLY by the application (asciiz if < 16)
 * stubinfo_dpmi_server		used by stub to load DPMI server
 * stubinfo_block		program addr
 * stubinfo_file		source file
 * stubinfo_offs		inExe
\*****************************************************************************/


		.text

		.type	_end, @object


		.globl	_start
		.type	_start, @function
		.p2align 4
_start:
	/* set up PIC frame */
		call	L39
    L39:
		popl	%ebx
		addl	$_GLOBAL_OFFSET_TABLE_+[.-L39], %ebx
	/* set up (s)brk */
		leal	_end@GOTOFF(%ebx), %eax
		leal	__what_size_app_thinks_it_is@GOTOFF(%ebx), %edi
		movl	%eax, (%edi)
		movl	%fs:(STUBINFO_BLOCK), %eax
		leal	__djgpp_base_address@GOTOFF(%ebx), %edi
		movl	%eax, (%edi)
		addl	%fs:(STUBINFO_INITIAL_SIZE), %eax
		leal	__what_size_dpmi_thinks_we_are@GOTOFF(%ebx), %edi
		movl	%eax, (%edi)
		leal	8+__djgpp_memory_handle_list@GOTOFF(%ebx), %eax
		leal	__djgpp_memory_handle_pointer@GOTOFF(%ebx), %edi
		movl	%eax, (%edi)
	/* copy stubinfo */
		cld
		pushl	%ds
		popl	%es
		leal	_stubinfo_data@GOTOFF(%ebx), %edi
		pushl	%edi
		xorl	%esi, %esi
		movl	$(STUBINFO_END>>2), %ecx
		.byte	100
		rep;	movsl
		popl	%edi
		leal	_stubinfo@GOTOFF(%ebx), %esi
		movl	%edi, (%esi)
	/* create an alias for DS */
		leal	__djgpp_ds_alias@GOTOFF(%ebx), %eax
		movl	%ds, (%eax)
		pushl	%ebx
		movw	%ds, %bx
		movw	$0x000a, %ax
		int	$0x31
		popl	%ebx
		jc	exit_error_alias
	/* XXX do we have to set it further? access/limit? */
		movw	%ax, %ds
	/* set up stack: MAX(minstack, _stklen) */
		leal	_stklen@GOTOFF(%ebx), %esi
		movl	(%esi), %edx
		movl	STUBINFO_MINSTACK(%edi), %eax
		cmpl	%eax, %edx
		jnb	0f
		movl	%eax, %edx
	0:
		andb	$0xf0, %dl
		movl	%edx, (%esi)
		pushl	%edx
		call	__sbrk
		popl	%edx
		cmpl	$-1, %eax
		je	exit_error_stack
		leal	__djgpp_stack_limit@GOTOFF(%ebx), %esi
		movl	%eax, (%esi)
		addl	%eax, %edx
		leal	__djgpp_stack_top@GOTOFF(%ebx), %esi
		movl	%edx, (%esi)
		movw	%ds, %cx
		movw	%cx, %ss
		movl	%edx, %esp
	/* load all required objects */
		leal	objects@GOTOFF(%ebx), %eax
		pushl	%eax
		leal	the_core_src@GOTOFF(%ebx), %eax
		pushl	%eax
		movl	%fs:(STUBINFO_BLOCK), %eax
		pushl	%eax
		xorl	%eax, %eax
		movw	%fs:(STUBINFO_OFFS), %ax
		pushl	%eax
		movw	%fs:(STUBINFO_FILE), %ax
		pushl	%eax
		call	__elf_load
		addl	$16, %esp
		popl	%edx
		testl	%eax, %eax
		jz	exit_error_load
	/* relocate/link objects */
		leal	__djgpp_ds_alias@GOTOFF(%ebx), %ecx
		movl	(%ecx), %ecx
		pushl	%ecx
		leal	exit32_first_byte@GOTOFF(%ebx), %ecx
		pushl	%ecx
		leal	__djgpp_memory_handle_pointer@GOTOFF(%ebx), %ecx
		movl	(%ecx), %ecx
		pushl	%ecx
		leal	__djgpp_memory_handle_list@GOTOFF(%ebx), %ecx
		pushl	%ecx
		pushl	%eax
		pushl	%edx
		call	__elf_link
		popl	%edx
		popl	%ebp
		popl	%ecx
		popl	%edx
		popl	%esi
		popl	%ebx
		testl	%eax, %eax
		jnz	exit_error_link
		movl	$_init, 8(%ebp)
		movl	$_fini, 12(%ebp)
		movl	%ebp, the_core
	/* go to startup code */
		xorl	%ebp, %ebp
		call	__crt1_startup
		jmp	exit_normal
		.size	_start, .-_start


		.globl	__exit
		.type	__exit, @function
		.p2align 4
__exit:
		movb	4(%esp), %al
exit_normal:
		pushl	%ds
		popl	%fs
		movl	__djgpp_ds_alias, %ebx
		movl	$_stubinfo_data, %edi
		movw	STUBINFO_DS_SELECTOR(%edi), %ss
		movzwl	STUBINFO_MINKEEP(%edi), %esp
		movl	$__djgpp_memory_handle_list, %ecx
		movl	__djgpp_memory_handle_pointer, %edx
		movl	$exit32_first_byte, %esi
exit_common:
	/* DS:ESI -> exit32_helper
	 * FS:EDI -> stubinfo
	 * DS:ECX -> __djgpp_memory_handle_list
	 * EDX    =  __djgpp_memory_handle_pointer
	 * EBX    =  DS alias
	 * AL     =  error code
	 * stack  -> transferbuffer
	 */
		pushl	%eax
		call	free_blocks
		popl	%edx
		cld
		movl	$(exit32_last_byte - exit32_first_byte), %ecx
		xorl	%eax, %eax
		movw	%fs:STUBINFO_DS_SEGMENT(%edi), %ax
		shl	$4, %eax
		pushl	%ds
		popl	%es
		pushl	%edi
		movl	%eax, %edi
		rep;	movsb
		popl	%edi
		pushl	%eax
		movw	%fs:2+STUBINFO_MEMORY_HANDLE(%edi), %si
		movl	%fs:STUBINFO_MEMORY_HANDLE(%edi), %edi
		pushl	%ds
		movl	%ebx, %ds
		popl	%ebx
		movw	$0x0001, %ax
		int	$0x31
		ret

exit_error_load:
	/* FS:0   -> transferbuffer
	 * EBX    =  PIC frame
	 */
		movw	%fs:(STUBINFO_DS_SELECTOR), %ss
		movzwl	%fs:(STUBINFO_MINKEEP), %esp
exit_error_stack:
exit_error_alias:
	/* FS:0   -> transferbuffer
	 * EBX    =  PIC frame
	 * stack  -> transferbuffer
	 */
		leal	__djgpp_memory_handle_pointer@GOTOFF(%ebx), %edx
		movl	(%edx), %edx
		leal	__djgpp_memory_handle_list@GOTOFF(%ebx), %ecx
		leal	exit32_first_byte@GOTOFF(%ebx), %esi
		leal	__djgpp_ds_alias@GOTOFF(%ebx), %ebx
		movl	(%ebx), %ebx
		xorl	%edi, %edi
		movb	$-1, %al
		jmp	exit_common
exit_error_link:
	/* FS:0   -> transferbuffer
	 * DS:ESI -> exit32_helper
	 * DS:ECX -> __djgpp_memory_handle_list
	 * EDX    =  __djgpp_memory_handle_pointer
	 * EBX    =  DS alias
	 */
		movw	%fs:(STUBINFO_DS_SELECTOR), %ss
		movzwl	%fs:(STUBINFO_MINKEEP), %esp
		xorl	%edi, %edi
		movb	$-1, %al
		jmp	exit_common

free_blocks:
	/* DS:ECX -> __djgpp_memory_handle_list
	 * EDX    =  __djgpp_memory_handle_pointer
	 */
		pushl	%esi
		pushl	%edi
	0:
		addl	$8, %ecx
		cmpl	%ecx, %edx
		je	1f
		movl	(%ecx), %edi
		movw	2(%ecx), %si
		movw	$0x0502, %ax
		int	$0x31
		jmp	0b
	1:
		popl	%edi
		popl	%esi
		ret

exit32_first_byte:
	/* SI:DI = memory handle to free
	 * DL    = error code
	 */
		movw	$0x0502, %ax
		int	$0x31
		movb	%dl, %al
		movb	$0x4c, %ah
		int	$0x21
exit32_last_byte:
		.size	__exit, .-__exit


		.globl	__sbrk
		.type	__sbrk, @function
		.p2align 4
__sbrk:
		call	L40
    L40:
		popl	%eax
		addl	$_GLOBAL_OFFSET_TABLE_+[.-L40], %eax

		leal	__what_size_app_thinks_it_is@GOTOFF(%eax), %eax
		movl	(%eax), %eax

		movl	4(%esp), %ecx			/* Increment size */
		addl	%ecx, %eax
		jnc	brk_common
	/* Carry is only set if a negative increment or wrap happens.  Negative
	   increment is semi-OK, wrap (only for multiple zone sbrk) isn't. */
		test	$0x80000000, %ecx		/* Clears carry */
		jnz	brk_common

		movl	$-1, %eax
		ret


		.globl	__brk
		.type	__brk, @function
		.p2align 4
__brk:
		movl	4(%esp), %eax

brk_common:
		pushl	%ebp
		call	L41
    L41:
		popl	%ebp
		addl	$_GLOBAL_OFFSET_TABLE_+[.-L41], %ebp

#define GET(a, b)	leal	a##@GOTOFF(%ebp), b; movl	(b), b
#define SET(a, b)	leal	b##@GOTOFF(%ebp), %ebx; movl	a, (%ebx)
#define SET2(a, b, c)	leal	b##@GOTOFF(%ebp), c; movl	a, (c)

		pushl	%ebx
		pushl	%esi
		pushl	%edi

		GET	(__what_size_app_thinks_it_is, %edx)	/* save info */
		SET	(%edx, __what_we_return_to_app_as_old_size)
		SET	(%eax, __what_size_app_thinks_it_is)

		pushl	%eax
	/* check all blocks */
		GET	(__djgpp_memory_handle_pointer, %edx)
		leal	__djgpp_memory_handle_list@GOTOFF(%ebp), %esi
		movl	%edx, %ecx
		subl	%esi, %ecx
		shrl	$1, %ecx
		leal	__djgpp_memory_handle_size@GOTOFF(%ebp), %edi
		addl	%edi, %ecx
	0:
		subl	$8, %edx
		subl	$4, %ecx
		cmpl	%edx, %esi
		je	1f
		movl	4(%edx), %ebx
		cmpl	%eax, %ebx
		ja	0b
		addl	(%ecx), %ebx
		cmpl	%eax, %ebx
		jbe	0b
	/* free all blocks allocated after this one */
		SET2	(%ebx, __what_size_dpmi_thinks_we_are, %edi)
		GET	(__djgpp_memory_handle_pointer, %ecx)
		addl	$8, %edx
		SET	(%edx, __djgpp_memory_handle_pointer)
	2:
		cmpl	%ecx, %edx
		jae	1f
		movl	(%edx), %edi
		movw	2(%edx), %si
		movw	$0x0502, %ax
		int	$0x31
		movl	$0, (%edx)
		addl	$8, %edx
		jmp	2b
	1:
		popl	%eax

		leal	__what_size_dpmi_thinks_we_are@GOTOFF(%ebp), %ebx
		cmpl	(%ebx), %eax				/* don't bother shrinking */
		jbe	brk_nochange

	/* Current allocation not large enough, get another block */
		GET	(__what_we_return_to_app_as_old_size, %ecx)
		subl	%ecx, %eax
	14:
		pushl	%eax					/* Save orig */

/* Prevent handle exhaustion:  Block size of later allocated handles is larger.
   Block Size = 2^(16+handle#/32) which allows 512Mb on default 256 handles. */

		GET	(__djgpp_memory_handle_pointer, %ecx)
		leal	__djgpp_memory_handle_list@GOTOFF(%ebp), %edx
		subl	%edx, %ecx				/* 8*hand# */
		shrl	$8, %ecx	/* hand#/32, tuneable, big shifts = old way */
		movl	$1, %edx				/* EDX = 1 */
		addb	$16, %cl				/* 2^16=64K */
		shll	%cl, %edx
		decl	%edx
		movl	%edx, %ecx
		notl	%edx
		addl	%ecx, %eax			/* Round up to block */
		andl	%edx, %eax

		movl	%eax, %edx				/* Save size */
		movl	%eax, %ecx
		movl	%eax, %ebx
		shrl	$16, %ebx				/* BX:CX size */
		movw	$0x501,%ax
		int	$0x31
		popl	%eax					/* Orig size */
		jc	brk_error

		pushw	%bx
		pushw	%cx
		popl	%ecx					/* Linear address */
	15:
		pushl	%edx					/* Size */
		call	lock_memory

		leal	__what_size_dpmi_thinks_we_are@GOTOFF(%ebp), %ebx
		cmpl	%ecx, (%ebx)				/* Back to back ? */
		je	4f
		SET	(%ecx, __what_size_dpmi_thinks_we_are)
		SET	(%ecx, __what_we_return_to_app_as_old_size)
	4:
		GET	(__what_we_return_to_app_as_old_size, %ebx)	/* Base for new block */
		addl	%ebx, %eax					/* Final address */
		SET	(%eax, __what_size_app_thinks_it_is)
	/* Note - save adjusted memory base and memory handle SI:DI here */
		GET	(__djgpp_memory_handle_pointer, %ebx)
		movl	%edi, (%ebx)
		movw	%si, 2(%ebx)
		movl	%ecx, 4(%ebx)
		leal	8(%ebx), %edi
	/* Handle Offset / 2 = Offset into Size Array */
		leal	__djgpp_memory_handle_list@GOTOFF(%ebp), %eax
		subl	%eax, %ebx
		shrl	$1, %ebx
		leal	__djgpp_memory_handle_size@GOTOFF(%ebp), %eax
		addl	%eax, %ebx
		movl	%edx, (%ebx)
		leal	__djgpp_memory_handle_list@GOTOFF(%ebp), %ebx
		addl	$2040, %ebx
		cmpl	%ebx, %edi				/* At end? */
		je	11f
		SET	(%edi, __djgpp_memory_handle_pointer)	/* Only if not at end */
	11:
		addl	%ecx, %edx				/* Final address */
		decl	%edx					/* Limit to end */
	/* If we get a block at a lower address we must skip the limit change */
		GET	(__djgpp_selector_limit, %ebx)
		cmpl	%ebx, %edx
		jbe	12f
	/* XXX change limit here */
	12:
		incl	%edx					/* Size not limit */
		leal	_crt0_startup_flags@GOTOFF(%ebp), %ebx
		testb	$0x60, (%ebx)				/* include/crt0.h */
		jz	no_fill_sbrk_memory
		pushl	%ds
		popl	%es

		GET	(__what_size_dpmi_thinks_we_are, %edi)	/* set all newly resized bytes zero */
		movl	%edx, %ecx					/* Limit */
		subl	%edi, %ecx			/* Adjust count for base */
		xorl	%eax, %eax
		testb	$0x40, (%ebx)
		jz	no_deadbeef
		movl	$0xdeadbeef, %eax		/* something really easy to spot */
no_deadbeef:
		shrl	$2, %ecx			/* div 4 Longwords not bytes */
		cld
		rep
		stosl
no_fill_sbrk_memory:
		SET	(%edx, __what_size_dpmi_thinks_we_are)

brk_nochange:					/* successful return */
		GET	(__what_we_return_to_app_as_old_size, %eax)
		jmp	brk_return

brk_error:					/* error return */
		GET	(__what_we_return_to_app_as_old_size, %eax)
		SET	(%eax, __what_size_app_thinks_it_is)
		movl	$-1, %eax

brk_return:
		popl	%edi
		popl	%esi
		popl	%ebx

		popl	%ebp
		ret
		.size	__brk, .-__brk
		.size	__sbrk, .-__sbrk


		.type	lock_memory, @function
lock_memory:
	/* BX:CX should be linear address; size is pushed on stack */
		pushl	%esi
		pushl	%edi
		pushl	%eax
		GET	(_crt0_startup_flags, %eax)
		testb	$0x10, 1(%eax)				/* include/crt0.h */
		jz	13f
		movl	16(%esp),%edi
		movw	18(%esp),%si
		movw	$0x600,%ax
		int	$0x31
	13:
		popl	%eax
		popl	%edi
		popl	%esi
		ret	$4			/* Pop the argument */
		.size	lock_memory, .-lock_memory


		.data

the_core_src:	.asciz	"/*core*/"

		.p2align 4

		.lcomm	_stubinfo_data, STUBINFO_END

		.comm	_stubinfo, 4
		.comm	_stklen, 4
		.comm	_crt0_startup_flags, 4

		.comm	the_core, 4
		.comm	objects, 8

		.type	__what_size_app_thinks_it_is, @object
		.size	__what_size_app_thinks_it_is, 4
__what_size_app_thinks_it_is:
		.long	0
		.type	__what_size_dpmi_thinks_we_are, @object
		.size	__what_size_dpmi_thinks_we_are, 4
__what_size_dpmi_thinks_we_are:
		.long	0
		.type	__what_we_return_to_app_as_old_size, @object
		.size	__what_we_return_to_app_as_old_size, 4
__what_we_return_to_app_as_old_size:
		.long	0

		.type	__djgpp_memory_handle_pointer, @object
		.size	__djgpp_memory_handle_pointer, 4
__djgpp_memory_handle_pointer:
		.long	0

		.comm	__djgpp_stack_top, 4
		.comm	__djgpp_stack_limit, 4
		.comm	__djgpp_ds_alias, 4
		.comm	__djgpp_selector_limit, 4
		.comm	__djgpp_base_address, 4

		.comm	__djgpp_memory_handle_list, 2048	/* Enough for 256 handles */
		.comm	__djgpp_memory_handle_size, 1024	/* Enough for 256 handles */


		.text

		.globl	_crt0_init_mcount
		.type	_crt0_init_mcount, @function
		.p2align 4
_crt0_init_mcount:
#ifdef IN_GCRT0
		jmp	_mcount_init
#else
		ret
#endif
		.size	_crt0_init_mcount, .-_crt0_init_mcount
