#include <dlfcn.h>
#include <stdio.h>
#include <math.h>


void do_something (void);


void __attribute__((constructor))
constructor (void)
{
    printf("%s\n", __FUNCTION__);
}


void __attribute__((destructor))
destructor (void)
{
    printf("%s\n", __FUNCTION__);
}


int
main (int argc, char **argv)
{
    void *h = dlopen("libez.so", RTLD_LAZY);
    if (h == NULL) {
	printf("%s\n", dlerror());
	return -1;
    } else {
	void (*func) (void) = dlsym(h, "do_something");
	if (func == NULL) {
	    printf("%s\n", dlerror());
	    return -2;
	}
	func();
	dlclose(h);
    }
    return 0;
}
