/* Copyright (C) 1997 DJ Delorie, see COPYING.DJ for details */
/* Copyright (C) 1995 DJ Delorie, see COPYING.DJ for details */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

static FILE *
sfopen(const char *c, const char *m)
{
  FILE *rv = fopen(c, m);
  if (rv == 0)
  {
    fprintf(stderr, "Error: cannot open file %s in mode %s\n", c, m);
    exit(1);
  }
  return rv;
}

int
gen (const char *argv1, const char *argv2, FILE *outf, const char *stub_name)
{
  char buf[1000];
  char name[1000], type[1000];
  int addr, tag=0;
  FILE *inf = sfopen(argv1, "r");
  FILE *sf = sfopen(argv2, "r");
  while (1)
  {
    if (fgets(buf, 1000, inf) == 0)
      break;
    if (strstr(buf, "by Value"))
      tag = 1;
    if (strstr(buf, "by Name"))
      tag = 0;
    name[0] = 0;
    sscanf(buf, "0000:%x %s", &addr, name);
    if (strncmp(name, "stubinfo", 8) == 0 && tag)
    {
      char *n;
      for (n=name; *n; n++)
	*n = toupper(*n);
      fprintf(outf, "#define %s %#x\n", name, addr);
    }
  }
  fprintf(outf, "#ifndef __ASSEMBLER__\n");
  fprintf(outf, "typedef struct {\n");
  while (1)
  {
    if (fgets(buf, 1000, sf) == 0)
      break;
    if (strncmp(buf, "stubinfo_end", 12) == 0)
      break;
    if (strncmp(buf, "stubinfo_", 9) != 0)
      continue;
    name[0] = 0;
    sscanf(buf, "%[^:]: ; %[^\n]", name, type);
    if (strncmp(type, "char", 4) == 0)
      fprintf(outf, "  char %s%s;\n", name+9, type+5);
    else
      fprintf(outf, "  %s %s;\n", type, name+9);
  }
  fprintf(outf, "} %s;\n", stub_name);
  fprintf(outf, "extern %s *_stubinfo;\n", stub_name);
  fprintf(outf, "#endif\n");
  fclose(inf);
  fclose(sf);
  return 0;
}

int
main(int argc, char **argv)
{
  FILE *outf = sfopen(argv[5], "w");
  fprintf(outf, "/* Generated by stub2inf - DO NOT EDIT */\n");
  fprintf(outf, "#ifndef __dj_include_stub_h__\n#define __dj_include_stub_h__\n\n");
  fprintf(outf, "#ifndef __ELF__\n\n");
  gen(argv[1], argv[2], outf, "_GO32_StubInfo");
  fprintf(outf, "\n#else  /* __ELF__ */\n\n");
  gen(argv[3], argv[4], outf, "_dELF_StubInfo");
  fprintf(outf, "\n#endif /* __ELF__ */\n");
  fprintf(outf, "\n#endif /* __dj_include_stub_h__ */\n");
  fclose(outf);
  return 0;
}
