/*
 * dllink - dynamic linking system
 * Version:  0.1
 *
 * Copyright (C) 2005  Daniel Borca   All Rights Reserved.
 *
 * dllink is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * dllink is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNU Make; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#include "stubinfo.h"


/* The functions below assume that FS:0 -> transferbuffer, whose layout is:
 * 0000 - 0080		stubinfo
 * 0080 - 0100		DPMI register structure
 * 0100 - ????		data
 *
 * The wrappers around `dputs', `dprintf', `dputc' assume that relocated
 * addresses have the most significant nibble set.  They may not work in
 * all environments, but they're debug functions, anyway...
 */


		.text


	/* void dputs (const char *s); */
		.type	dputs, @function
		.balign	4
		.globl	dputs
dputs:
		popl	%edx
		popl	%ecx
		movl	%ecx, %eax
		andl	$0x08000000, %eax
		cmpl	$0x08000000, %eax
		jnz	0f
		addl	%fs:(STUBINFO_VADDR), %ecx
	0:
		pushl	%ecx
		pushl	%edx
		jmp	_dputs
		.size	dputs, .-dputs


	/* void dprintf (const char *fmt, ...); */
		.type	dprintf, @function
		.balign	4
		.globl	dprintf
dprintf:
		popl	%edx
		popl	%ecx
		movl	%ecx, %eax
		andl	$0x08000000, %eax
		cmpl	$0x08000000, %eax
		jnz	0f
		addl	%fs:(STUBINFO_VADDR), %ecx
	0:
		pushl	%ecx
		pushl	%edx
		jmp	_dprintf
		.size	dprintf, .-dprintf


	/* void dputc (int ch); */
		.type	dputc, @function
		.balign	4
		.globl	dputc
dputc:
		movl	4(%esp), %eax
		movb	$0x02, %ah
		cmpb	$'\n', %al
		jne	1f
		movb	$'\r', %dl
		int	$0x21
		movb	$'\n', %al
	1:
		movb	%al, %dl
		int	$0x21
		ret
		.size	dputc, .-dputc
