/*man-start**************************************************************

		Introduction to XSI Curses Interface

The X/Open Group has identified a strong need for a generic terminal
interface for applications that wish to be independent of terminal
hardware and connection method.

This interface should allow the attachment of character and
block-oriented terminals.  Furthermore, it should not put any
constraints on how the terminals are attached (e.g., Local Area
Networks, PADs on X.25, etc.). 

The curses library interfaces provides the user with a method of
updating screens with reasonable optimisation. 

The X/Open group has found it impossible to define a totally portable
set of curses interface routines that cover asynchronous, networked,
and synchronous terminals.  The functions are oriented towards locally
connected asynchronous terminals.  For such terminals, applications
conforming to this interface are portable.  The interface routines
curses may, however, also be used with synchronous and networked
terminals, provided the restrictions below are considered. 

These functions have been included been included in the X/Open 
definition in the "optional" category.  This means that although they 
are likely to appear on many X/Open compliant systems, they are not 
guaranteed to be on all systems.  Where they are supported, they will 
conform to the given definition.


-------------------------------------------------------------------------

	    Synchronous and Networked Asynchronous Terminals

These notes indicate to the application writer some considerations to be 
borne in mind when driving synchronous, networked asynchronous (NWA) or 
non-standard directly connected asynchronous terminals.

Such terminals are often used in a mainframe environment and 
communicatie to the host in block mode.  That is, the user types 
characters at the terminal then presses a special key to initiate 
transmission of the characters to the host.

Frequently, although it may be possible to send arbitrary sized blocks 
to the host, it may not be possible or desireable to cause a character 
to be transmitted with only a single keystroke.

This can cause severe problems to an application wishing to make use of 
single character input.



OUTPUT

The curses package can be used in the normal way for all operations 
pertaining to output to the terminal, with the possible exception that 
on some terminals the refresh() routine may have to redraw the entire 
screen contents in order to perform any update.

If it is additionally necessary to clear the screen before each such 
operation, the result could be unacceptable.


INPUT

Because of the nature of operation of synchronous (block-mode) and NWA 
terminals, it may not be possible to support all or any of the curses 
input functions.  In particular, the following points should be noted:

* Single-character input may not be possible.  It may be necessary to
  press a special key to cause all characters typed at the terminal to
  be transmitted to the host. 

* It may not be possible to disable echo.  Character echo may be 
  performed directly by the terminal.  On terminals that behave this 
  way, any curses application that performs input should be aware that 
  any characters type will appear on the screen wherever the cursor is 
  positioned. This may not necessarily correspond to the position of the 
  cursor in the window.


-------------------------------------------------------------------------

		Data Types and the <curses.h> Header

The data types supported by curses are described in this section.

As the library supports a procedural interface to the data types, actual 
structure contents are not described.  All curses data are manipulated 
using the routines provided.


THE <curses.h> HEADER

The <curses.h> header defines various constants and declares the data 
types that are available to the application.


DATA TYPES

The following data types are declared:

	WINDOW *	pointer to screen representation
	SCREEN *	pointer to terminal descriptor
	bool		boolean data type
	chtype		representation of a character in a window

The actual WINDOW and SCREEN objects used to store information are 
created by the corresponding routines and a pointer to them is provided.  
All manipulation is through that pointer.


CONSTANTS

The following constants are defined. 


GENERAL

	COLS		number of columns on terminal screen
	ERR		value returned on error condition
	FALSE		boolean false value
	LINES		number of lines on terminal screen
	OK		value returned on successful completion
	NULL		zero pointer value
	TRUE		boolean true value

VIDEO ATTRIBUTES

	A_BLINK		blinking
	A_BOLD		extra bright or bold
	A_DIM		half bright
	A_REVERSE	reverse video
	A_STANDOUT	terminal's best highlighting mode
	A_UNDERLINE	underlining
	A_ATTRIBUTES	bit-mask to extract attributes
	A_CHARTEXT	bit-mask to extract a character

Normally, attributres are a property of the character. 


INPUT VALUES

The following constants might be returned by getch() if keypad() has
been enabled.  Note that not all of these may be supported on a
particular terminal if the terminal does not transmit a unique code when
the key is pressed or the definition for the key is not present in the
underlying table of terminal capabilities.

	KEY_BREAK	break key
	KEY_DOWN	the four arrow keys
	KEY_UP
	KEY_LEFT
	KEY_RIGHT
	KEY_HOME	home key (upward+left arrow)
	KEY_BACKSPACE	backspace
	KEY_F0		function keys; space for 64 keys is reserved
	KEY_F(n)	(KEY_F0+(n))
	KEY_DL		delete line
	KEY_IL		insert line
	KEY_DC		delete character
	KEY_IC		insert character
	KEY_EIC		exit insert character mode
	KEY_CLEAR	clear screen
	KEY_EOS		clear to end of screen
	KEY_EOL		clear to end of line
	KEY_SF		scroll 1 line forwards
	KEY_SR		scroll 1 line backwards (reverse)
	KEY_NPAGE	next page
	KEY_PPAGE	previous page
	KEY_STAB	set tab
	KEY_CTAB	clear tab
	KEY_CATAB	clear all tabs
	KEY_ENTER	enter or send
	KEY_SRESET	soft (partial) reset
	KEY_RESET	reset or hard reset
	KEY_PRINT	print or copy
	KEY_LL		home down or bottom (lower left)
	KEY_A1		upper left of virtual keypad
	KEY_A3		upper right of virtual keypad
	KEY_B2		centre of virtual keypad
	KEY_C1		lower left of virtual keypad
	KEY_C3		lower right of virtual keypad

The virtual keypad is arranged like this:

	A1	up	A3
	left	B2	right
	C1	down	C3

FUNCTIONS

	The following table lists each curses routine and the name of the
	manual page on which it is described.

	Functions from the X/Open curses standard -- complete, except
	for getch() and ungetch(), which are implemented as macros for
	DOS compatibility:

	   Curses Function        Manual Page Name

		addch			addch
		addchnstr		addchstr
		addchstr		addchstr
		addnstr			addstr
		addstr			addstr
		attroff			attr
		attron			attr
		attrset			attr
		attr_get		attr
		attr_off		attr
		attr_on			attr
		attr_set		attr
		baudrate		termattr
		beep			beep
		bkgd			bkgd
		bkgdset			bkgd
		border			border
		box			border
		can_change_color	color
		cbreak			inopts
		chgat			attr
		clearok			outopts
		clear			clear
		clrtobot		clear
		clrtoeol		clear
		color_content		color
		color_set		attr
		copywin			overlay
		curs_set		kernel
		def_prog_mode		kernel
		def_shell_mode		kernel
		del_curterm		terminfo
		delay_output		util
		delch			delch
		deleteln		deleteln
		delscreen		initscr
		delwin			window
		derwin			window
		doupdate		refresh
		dupwin			window
		echochar		addch
		echo			inopts
		endwin			initscr
		erasechar		termattr
		erase			clear
		filter			util
		flash			beep
		flushinp		getch
		getbkgd			bkgd
		getnstr			getstr
		getstr			getstr
		getwin			scr_dump
		halfdelay		inopts
		has_colors		color
		has_ic			termattr
		has_il			termattr
		hline			border
		idcok			outopts
		idlok			outopts
		immedok			outopts
		inchnstr		inchstr
		inchstr			inchstr
		inch			inch
		init_color		color
		init_pair		color
		initscr			initscr
		innstr			instr
		insch			insch
		insdelln		deleteln
		insertln		deleteln
		insnstr			innstr
		insstr			innstr
		instr			instr
		intrflush		inopts
		isendwin		initscr
		is_linetouched		touch
		is_wintouched		touch
		keyname			keyname
		keypad			inopts
		killchar		termattr
		leaveok			outopts
		longname		termattr
		meta			inopts
		move			move
		mvaddch			addch
		mvaddchnstr		addchstr
		mvaddchstr		addchstr
		mvaddnstr		addstr
		mvaddstr		addstr
		mvchgat			attr
		mvcur			terminfo
		mvdelch			delch
		mvderwin		window
		mvgetch			getch
		mvgetnstr		getstr
		mvgetstr		getstr
		mvhline			border
		mvinch			inch
		mvinchnstr		inchstr
		mvinchstr		inchstr
		mvinnstr		instr
		mvinsch			insch
		mvinsnstr		insstr
		mvinsstr		insstr
		mvinstr			instr
		mvprintw		printw
		mvscanw			scanw
		mvvline			border
		mvwaddchnstr		addchstr
		mvwaddchstr		addchstr
		mvwaddch		addch
		mvwaddnstr		addstr
		mvwaddstr		addstr
		mvwchgat		attr
		mvwdelch		delch
		mvwgetch		getch
		mvwgetnstr		getstr
		mvwgetstr		getstr
		mvwhline		border
		mvwinchnstr		inchstr
		mvwinchstr		inchstr
		mvwinch			inch
		mvwinnstr		instr
		mvwinsch		insch
		mvwinsnstr		insstr
		mvwinsstr		insstr
		mvwinstr		instr
		mvwin			window
		mvwprintw		printw
		mvwscanw		scanw
		mvwvline		border
		napms			kernel
		newpad			pad
		newterm			initscr
		newwin			window
		nl			inopts
		nocbreak		inopts
		nodelay			inopts
		noecho			inopts
		nonl			inopts
		noqiflush		inopts
		noraw			inopts
		notimeout		inopts
		overlay			overlay
		overwrite		overlay
		pair_content		color
		pechochar		pad
		pnoutrefresh		pad
		prefresh		pad
		printw			printw
		putp			terminfo
		putwin			scr_dump
		qiflush			inopts
		raw			inopts
		redrawwin		refresh
		refresh			refresh
		reset_prog_mode		kernel
		reset_shell_mode	kernel
		resetty			kernel
		restartterm		terminfo
		ripoffline		kernel
		savetty			kernel
		scanw			scanw
		scr_dump		scr_dump
		scr_init		scr_dump
		scr_restore		scr_dump
		scr_set			scr_dump
		scrl			scroll
		scroll			scroll
		scrollok		outopts
		set_term		initscr
		setscrreg		outopts
		setterm			terminfo
		setupterm		terminfo
		slk_attroff		slk
		slk_attr_off		slk
		slk_attron		slk
		slk_attr_on		slk
		slk_attrset		slk
		slk_attr_set		slk
		slk_clear		slk
		slk_color		slk
		slk_init		slk
		slk_label		slk
		slk_noutrefresh		slk
		slk_refresh		slk
		slk_restore		slk
		slk_set			slk
		slk_touch		slk
		standend		attr
		standout		attr
		start_color		color
		subpad			pad
		subwin			window
		syncok			window
		termattrs		termattrs
		term_attrs		termattrs
		termname		termattrs
		tgetent			termcap
		tgetflag		termcap
		tgetnum			termcap
		tgetstr			termcap
		tgoto			termcap
		tigetflag		terminfo
		tigetnum		terminfo
		tigetstr		terminfo
		timeout			inopts
		touchline		touch
		touchwin		touch
		tparm			terminfo
		tputs			terminfo
		typeahead		inopts
		untouchwin		touch
		use_env			util
		vidattr			terminfo
		vid_attr		terminfo
		vidputs			terminfo
		vid_puts		terminfo
		vline			border
		vw_printw		printw
		vwprintw		printw
		vw_scanw		scanw
		vwscanw			scanw
		waddchnstr		addchstr
		waddchstr		addchstr
		waddch			addch
		waddnstr		addstr
		waddstr			addstr
		wattroff		attr
		wattron			attr
		wattrset		attr
		wattr_get		attr
		wattr_off		attr
		wattr_on		attr
		wattr_set		attr
		wbkgdset		bkgd
		wbkgd			bkgd
		wborder			border
		wchgat			attr
		wclear			clear
		wclrtobot		clear
		wclrtoeol		clear
		wcolor_set		attr
		wcursyncup		window
		wdelch			delch
		wdeleteln		deleteln
		wechochar		addch
		werase			clear
		wgetch			getch
		wgetnstr		getstr
		wgetstr			getstr
		whline			border
		winchnstr		inchstr
		winchstr		inchstr
		winch			inch
		winnstr			instr
		winsch			insch
		winsdelln		deleteln
		winsertln		deleteln
		winsnstr		insstr
		winsstr			insstr
		winstr			instr
		wmove			move
		wnoutrefresh		refresh
		wprintw			printw
		wredrawln		refresh
		wrefresh		refresh
		wscanw			scanw
		wscrl			scroll
		wsetscrreg		outopts
		wstandend		attr
		wstandout		attr
		wsyncdown		window
		wsyncup			window
		wtimeout		inopts
		wtouchln		touch
		wvline			border

	Wide-character functions from the X/Open standard -- these are
	only available when PDCurses is built with PDC_WIDE defined, and
	the prototypes are only available from curses.h when PDC_WIDE is
	defined before its inclusion in your app:

		addnwstr		addstr
		addwstr			addstr
		add_wch			addch
		add_wchnstr		addchstr
		add_wchstr		addchstr
		border_set		border
		box_set			border
		echo_wchar		addch
		erasewchar		termattr
		getbkgrnd		bkgd
		getcchar		util
		getn_wstr		getstr
		get_wch			getch
		get_wstr		getstr
		hline_set		border
		innwstr			instr
		ins_nwstr		insstr
		ins_wch			insch
		ins_wstr		insstr
		inwstr			instr
		in_wch			inch
		in_wchnstr		inchstr
		in_wchstr		inchstr
		key_name		keyname
		killwchar		termattr
		mvaddnwstr		addstr
		mvaddwstr		addstr
		mvadd_wch		addch
		mvadd_wchnstr		addchstr
		mvadd_wchstr		addchstr
		mvgetn_wstr		getstr
		mvget_wch		getch
		mvget_wstr		getstr
		mvhline_set		border
		mvinnwstr		instr
		mvins_nwstr		insstr
		mvins_wch		insch
		mvins_wstr		insstr
		mvinwstr		instr
		mvwaddnwstr		addstr
		mvwaddwstr		addstr
		mvwadd_wch		addch
		mvwadd_wchnstr		addchstr
		mvwadd_wchstr		addchstr
		mvwgetn_wstr		getstr
		mvwget_wch		getch
		mvwget_wstr		getstr
		mvwhline_set		border
		mvwinnwstr		instr
		mvwins_nwstr		insstr
		mvwins_wch		insch
		mvwins_wstr		insstr
		mvwin_wch		inch
		mvwin_wchnstr		inchstr
		mvwin_wchstr		inchstr
		mvwinwstr		instr
		mvwvline_set		border
		pecho_wchar		pad
		setcchar		util
		slk_wset		slk
		unget_wch		getch
		vline_set		border
		waddnwstr		addstr
		waddwstr		addstr
		wadd_wch		addch
		wadd_wchnstr		addchstr
		wadd_wchstr		addchstr
		wbkgrnd			bkgd
		wbkgrndset		bkgd
		wborder_set		border
		wecho_wchar		addch
		wgetbkgrnd		bkgd
		wgetn_wstr		getstr
		wget_wch		getch
		wget_wstr		getstr
		whline_set		border
		winnwstr		instr
		wins_nwstr		insstr
		wins_wch		insch
		wins_wstr		insstr
		winwstr			instr
		win_wch			inch
		win_wchnstr		inchstr
		win_wchstr		inchstr
		wunctrl			util
		wvline_set		border

	Quasi-standard functions, from Sys V or BSD curses:

		getattrs		attr
		getbegx			getyx
		getbegy			getyx
		getmaxx			getyx
		getmaxy			getyx
		getparx			getyx
		getparx			getyx
		traceoff		debug
		traceon			debug
		unctrl			util

	Classic PDCurses mouse functions, based on Sys V:

		mouse_set		mouse
		mouse_on		mouse
		mouse_off		mouse
		request_mouse_pos	mouse
		map_button		mouse
		wmouse_position		mouse
		getmouse		mouse
		getbmap			mouse

	Functions from ncurses:

		assume_default_colors	color
		curses_version		initscr
		has_key			util
		use_default_colors	color
		wresize			window

		mouseinterval		mouse
		mousemask		mouse
		mouse_trafo		mouse
		nc_getmouse		mouse
		ungetmouse		mouse
		wenclose		mouse
		wmouse_trafo		mouse

	PDCurses-specific functions -- avoid these in code that's 
	intended to be portable:

		addrawch		addch
		insrawch		insch
		is_termresized		initscr
		mvaddrawch		addch
		mvdeleteln		deleteln
		mvinsertln		deleteln
		mvinsrawch		insch
		mvwaddrawch		addch
		mvwdeleteln		deleteln
		mvwinsertln		deleteln
		mvwinsrawch		insch
		raw_output		outopts
		resize_term		initscr
		resize_window		window
		waddrawch		addch
		winsrawch		insch
		wordchar		termattr

		PDC_debug		debug
		PDC_ungetch		getch
		PDC_set_blink		pdcsetsc
		PDC_set_line_color	color
		PDC_set_title		pdcsetsc

		PDC_clearclipboard	pdcclip
		PDC_freeclipboard	pdcclip
		PDC_getclipboard	pdcclip
		PDC_setclipboard	pdcclip

		PDC_get_input_fd	pdckbd
		PDC_get_key_modifiers	getch
		PDC_return_key_modifiers getch
		PDC_save_key_modifiers	getch

	Functions specific to the X11 port of PDCurses:

		Xinitscr		initscr
		XCursesExit		-
		sb_init			sb
		sb_set_horz		sb
		sb_set_vert		sb
		sb_get_horz		sb
		sb_get_vert		sb
		sb_refresh		sb

**man-end****************************************************************/
