/* -*- coding: cp852 -*- */
/** Datagram Test
 * by Tomasz Zbroek
 * PUBLIC DOMAIN
 */

#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <conio.h>
#include <netinet/in.h>
#include <sys/socket.h>

#define BUFFER_SIZE 2048

void errorlog(char *i_pName)
{
  FILE *fp;
  int nErrNo = errno;
  fp = fopen("datagram.log","a");
  if(fp != NULL)
    {
      fprintf(fp, "%s, errno=%d, %s\n", i_pName, nErrNo, sock_strerror(nErrNo));
      fclose(fp);
    }
}

void Test(const char *i_pAddr, const char *i_pPort)
{
  int nRes;
  int nSocket;
  struct sockaddr_in sAddr;
  int nAddrSize;
  char szHost[254];
  char aBuffer[BUFFER_SIZE + 1] = "";
  const char szMsg[] = "Hello from DJGPP!";

  nSocket = socket(AF_INET, SOCK_DGRAM, IPPROTO_UDP);
  if(nSocket < 0)
    {
      errorlog("socket");
      return;
    }

  gethostname(szHost, 254);
  
  printf("UDP Port      : %s\n", i_pPort);
  printf("Host name     : %s\n", szHost);

  sAddr.sin_family = AF_INET;          
  sAddr.sin_port = htons(atoi(i_pPort)); 
  sAddr.sin_addr.s_addr = INADDR_ANY;
  memset(sAddr.sin_zero, '\0', sizeof sAddr.sin_zero);
  
  nRes = bind(nSocket, &sAddr, sizeof(sAddr));
  if(nRes < 0)
    {                                                                   
      errorlog("bind");
      close_socket(nSocket);
      return;
    }
  
  while(!kbhit())
    {
      nAddrSize = sizeof(sAddr);
      nRes = recvfrom(nSocket, aBuffer, sizeof aBuffer, 0 , (struct sockaddr *)&sAddr, &nAddrSize);
      if(nRes == -1)
        {
          errorlog("recvfrom");
          close_socket(nSocket);
          return;
        }
      else
        {
          if(nRes > BUFFER_SIZE)
            nRes = BUFFER_SIZE;
          aBuffer[nRes] = 0;
          printf("received: %s\n", aBuffer);
        }
    }

  close_socket(nSocket);
}

int main(int argc, char *argv[])
{
  int nRes;

  const char aPort[] = "23";
  const char aAddr[] = "192.168.0.49";

  const char *pPort = NULL;
  const char *pAddr = NULL;

  if(argc > 1)
    pPort = argv[1];
  if(argc > 2)
    pAddr = argv[2];
  
  printf("Datagram Test for DJGPP MSClient wrapper\n");
  if(argc > 1) 
    if(strcmp(argv[1], "-h")==0)
      {
        printf("datagram.exe <PORT> <ADDRESS>\n\n");
        return 0;
      }

  if(pPort == NULL)
    pPort = aPort;
  if(pAddr == NULL)
    pAddr = aAddr;

  Test(pAddr, pPort);

  return 0;
}
