/****************************************************************************/
/* STRINGS                                                                  */
/*--------------------------------------------------------------------------*/
/* Fonctions de manipulation des chanes de caractres (caption,text...)    */
/****************************************************************************/

#ifndef _STRINGS_H_
#define _STRINGS_H_

#include <string.h>

#include "Types.h"

/*ͻ*/
/*                                CONSTANTES                              */
/*ͼ*/

#define LONG_MAX_LENGTH    11    // Un long fait au plus 11 caractres
#define DOUBLE_MAX_LENGTH  24    // Un double fait au plus 24 caractres
                                 // (prvoyons large)

#define DOUBLE_NB_DIGITS   5     // Nombre de chiffres significatifs pour un
                                 // double

/*ͻ*/
/*                                 FONCTIONS                              */
/*ͼ*/

// Returns the last char of string (or 0 if string is "")

char EndOfString(const char *string);

// Conversion d'un chiffre hexa en nombre dcimal

int HexaToInt(char hexa_digit);

// Conversion d'une chane en un nombre du type indiqu.
// Retourne TRUE si la chane tait valide.

boolean StringToLong(const char *string, long &value);
boolean StringToDouble(const char *string, double &value);

// Conversion d'un nombre en une chane
// (la chane doit tre alloue)

void LongToString(long value, char *string);
void DoubleToString(double value, char *string);

// Manipulation des lgendes des lments de l'interface
// (hot-key ventuelle prcde de ~, ~~ pour afficher ~)

char HotKey(const char *caption);        // Hot-key de caption
int  DisplayLength(const char *caption); // Longueur d'affichage de caption


// Manipulation des textes
// -> lignes spares par \n
// -> changement de couleur par [clx] o x est la couleur d'affichage en hexa
//                          par [atxx] o xx est l'attribut en hexa
// -> toute combinaison [..] ne fait pas partie des caractres affichs
// -> [[ pour afficher le caractre [

int  GetTextHeight(const char *text);    // Hauteur d'affichage de text
int  GetTextWidth(const char *text);     // Largeur d'affichage de text


#endif
