#include "xalloc.h"

#define prepare_spawn(argv)                                       \
({                                                                \
   size_t _argc;                                                  \
   char **_new_argv;                                              \
                                                                  \
   for (_argc = 0; (argv)[_argc]; _argc++)                        \
     ;                                                            \
                                                                  \
   _new_argv = xmalloc ((1 + _argc + 1) * sizeof(_new_argv[0]));  \
   *_new_argv++ = "/dev/env/DJDIR/bin/sh";                        \
                                                                  \
   for (_argc = 0; _new_argv[_argc] = argv[_argc]; _argc++)       \
     ;                                                            \
                                                                  \
   _new_argv;                                                     \
})


#define PIPE_STDIN   0
#define PIPE_STDOUT  1


char tmp_file_name[2][L_tmpnam];  /*  0: pipe stdin, 1: pipe stdout.  */


#define remove_tmp_file(name)                                               \
 do {                                                                       \
   if ((name))                                                              \
   {                                                                        \
     if (unlink ((name)))                                                   \
       error (exit_on_error ? EXIT_FAILURE : 0, errno,                      \
              _("removing of `%s' failed"), (name));                        \
   }                                                                        \
   else                                                                     \
   {                                                                        \
     if (tmp_file_name[PIPE_STDIN][0])                                      \
     {                                                                      \
       if (unlink (tmp_file_name[PIPE_STDIN]))                              \
         error (exit_on_error ? EXIT_FAILURE : 0, errno,                    \
                _("removing of `%s' failed"), tmp_file_name[PIPE_STDIN]);   \
     }                                                                      \
     if (tmp_file_name[PIPE_STDOUT][0])                                     \
     {                                                                      \
       if (unlink (tmp_file_name[PIPE_STDOUT]))                             \
         error (exit_on_error ? EXIT_FAILURE : 0, errno,                    \
                _("removing of `%s' failed"), tmp_file_name[PIPE_STDOUT]);  \
     }                                                                      \
   }                                                                        \
 } while (0)


#ifdef _PIPE_H
static int
_pipe(int pipe_fd[2], int pipe_end)
{
  int fd;

  strcpy (tmp_file_name[pipe_end], "/dev/env/TMPDIR/m4XXXXXX");
  fd = mkstemp (tmp_file_name[pipe_end]);
  if (fd < 0)
    return -1;

  if (pipe_end == PIPE_STDIN)
  {
    pipe_fd[PIPE_STDIN] = fd;
    pipe_fd[PIPE_STDOUT] = -1;
    tmp_file_name[PIPE_STDOUT][0] = '\0';
  }
  else if (pipe_end == PIPE_STDOUT)
  {
    pipe_fd[PIPE_STDOUT] = fd;
    pipe_fd[PIPE_STDIN] = -1;
    tmp_file_name[PIPE_STDIN][0] = '\0';
  }

  return 0;
}
#endif
