(* Problem: The implementation of Kevin13FOO imports the Kevin13FOO
   interface which only contains the listed identifiers (twine, not
   String25).

   Solution: For every module interface, implicitly create another
   interface containing everything (i.e., like handle_autoexport()
   does, but without caring about autoexport_suspended), and import
   that one in the implementation. This will also get rid of the GPM
   mechanism. *)

Module Kevin13FOO interface;

Export
  Kevin13FOO = (twine);
type
  String25 = String(25);
function twine( foobar: CString ): String25;

end. {interface}

Module Kevin13FOO implementation;

function twine( foobar: CString ): String25;
begin
  twine := CString2String ( foobar )
end; {twine}
end.

{-----------------------------------------------------}
program KFoss( input, output );
import Kevin13FOO;

begin
  writeln ( twine ( 'OK' ) )
end.
