------------------------------------------------------------------------------
--                                                                          --
--                         GNAT RUNTIME COMPONENTS                          --
--                                                                          --
--                          G N A T . U T F _ 3 2                           --
--                                                                          --
--                                 B o d y                                  --
--                                                                          --
--             Copyright (C) 2005 Free Software Foundation, Inc.            --
--                                                                          --
-- GNAT is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with GNAT;  see file COPYING.  If not, write --
-- to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
-- MA 02111-1307, USA.                                                      --
--                                                                          --
-- As a special exception,  if other files  instantiate  generics from this --
-- unit, or you link  this unit with other files  to produce an executable, --
-- this  unit  does not  by itself cause  the resulting  executable  to  be --
-- covered  by the  GNU  General  Public  License.  This exception does not --
-- however invalidate  any other reasons why  the executable file  might be --
-- covered by the  GNU Public License.                                      --
--                                                                          --
-- GNAT was originally developed  by the GNAT team at  New York University. --
-- Extensive contributions were provided by Ada Core Technologies Inc.      --
--                                                                          --
------------------------------------------------------------------------------

pragma Style_Checks (Off);
--  Allow long lines in this unit

package body GNAT.UTF_32 is

   ----------------------
   -- Character Tables --
   ----------------------

   --  Note these tables are derived from those given in AI-285. For details
   --  see //www.ada-auth.org/cgi-bin/cvsweb.cgi/AIs/AI-00285.TXT?rev=1.22.

   type UTF_32_Range is record
      Lo : UTF_32;
      Hi : UTF_32;
   end record;

   type UTF_32_Ranges is array (Positive range <>) of UTF_32_Range;

   --  The following array includes all characters considered digits, i.e.
   --  all characters from the Unicode table with categories:

   --    Number, Decimal Digit (Nd)

   UTF_32_Digits : constant UTF_32_Ranges := (
     (16#00030#, 16#00039#),  -- DIGIT ZERO .. DIGIT NINE
     (16#00660#, 16#00669#),  -- ARABIC-INDIC DIGIT ZERO .. ARABIC-INDIC DIGIT NINE
     (16#006F0#, 16#006F9#),  -- EXTENDED ARABIC-INDIC DIGIT ZERO .. EXTENDED ARABIC-INDIC DIGIT NINE
     (16#00966#, 16#0096F#),  -- DEVANAGARI DIGIT ZERO .. DEVANAGARI DIGIT NINE
     (16#009E6#, 16#009EF#),  -- BENGALI DIGIT ZERO .. BENGALI DIGIT NINE
     (16#00A66#, 16#00A6F#),  -- GURMUKHI DIGIT ZERO .. GURMUKHI DIGIT NINE
     (16#00AE6#, 16#00AEF#),  -- GUJARATI DIGIT ZERO .. GUJARATI DIGIT NINE
     (16#00B66#, 16#00B6F#),  -- ORIYA DIGIT ZERO .. ORIYA DIGIT NINE
     (16#00BE7#, 16#00BEF#),  -- TAMIL DIGIT ONE .. TAMIL DIGIT NINE
     (16#00C66#, 16#00C6F#),  -- TELUGU DIGIT ZERO .. TELUGU DIGIT NINE
     (16#00CE6#, 16#00CEF#),  -- KANNADA DIGIT ZERO .. KANNADA DIGIT NINE
     (16#00D66#, 16#00D6F#),  -- MALAYALAM DIGIT ZERO .. MALAYALAM DIGIT NINE
     (16#00E50#, 16#00E59#),  -- THAI DIGIT ZERO .. THAI DIGIT NINE
     (16#00ED0#, 16#00ED9#),  -- LAO DIGIT ZERO .. LAO DIGIT NINE
     (16#00F20#, 16#00F29#),  -- TIBETAN DIGIT ZERO .. TIBETAN DIGIT NINE
     (16#01040#, 16#01049#),  -- MYANMAR DIGIT ZERO .. MYANMAR DIGIT NINE
     (16#01369#, 16#01371#),  -- ETHIOPIC DIGIT ONE .. ETHIOPIC DIGIT NINE
     (16#017E0#, 16#017E9#),  -- KHMER DIGIT ZERO .. KHMER DIGIT NINE
     (16#01810#, 16#01819#),  -- MONGOLIAN DIGIT ZERO .. MONGOLIAN DIGIT NINE
     (16#01946#, 16#0194F#),  -- LIMBU DIGIT ZERO .. LIMBU DIGIT NINE
     (16#0FF10#, 16#0FF19#),  -- FULLWIDTH DIGIT ZERO .. FULLWIDTH DIGIT NINE
     (16#104A0#, 16#104A9#),  -- OSMANYA DIGIT ZERO .. OSMANYA DIGIT NINE
     (16#1D7CE#, 16#1D7FF#)); -- MATHEMATICAL BOLD DIGIT ZERO .. MATHEMATICAL MONOSPACE DIGIT NINE

   --  The following table includes all characters considered letters, i.e.
   --  all characters from the Unicode table with categories:

   --    Letter, Uppercase (Lu)
   --    Letter, Lowercase (Ll)
   --    Letter, Titlecase (Lt)
   --    Letter, Modifier (Lm)
   --    Letter, Other (Lo)
   --    Number, Letter (Nl)

   UTF_32_Letters : constant UTF_32_Ranges := (
     (16#00041#, 16#0005A#),  -- LATIN CAPITAL LETTER A .. LATIN CAPITAL LETTER Z
     (16#00061#, 16#0007A#),  -- LATIN SMALL LETTER A .. LATIN SMALL LETTER Z
     (16#000AA#, 16#000AA#),  -- FEMININE ORDINAL INDICATOR .. FEMININE ORDINAL INDICATOR
     (16#000B5#, 16#000B5#),  -- MICRO SIGN .. MICRO SIGN
     (16#000BA#, 16#000BA#),  -- MASCULINE ORDINAL INDICATOR .. MASCULINE ORDINAL INDICATOR
     (16#000C0#, 16#000D6#),  -- LATIN CAPITAL LETTER A WITH GRAVE .. LATIN CAPITAL LETTER O WITH DIAERESIS
     (16#000D8#, 16#000F6#),  -- LATIN CAPITAL LETTER O WITH STROKE .. LATIN SMALL LETTER O WITH DIAERESIS
     (16#000F8#, 16#00236#),  -- LATIN SMALL LETTER O WITH STROKE .. LATIN SMALL LETTER T WITH CURL
     (16#00250#, 16#002C1#),  -- LATIN SMALL LETTER TURNED A .. MODIFIER LETTER REVERSED GLOTTAL STOP
     (16#002C6#, 16#002D1#),  -- MODIFIER LETTER CIRCUMFLEX ACCENT .. MODIFIER LETTER HALF TRIANGULAR COLON
     (16#002E0#, 16#002E4#),  -- MODIFIER LETTER SMALL GAMMA .. MODIFIER LETTER SMALL REVERSED GLOTTAL STOP
     (16#002EE#, 16#002EE#),  -- MODIFIER LETTER DOUBLE APOSTROPHE .. MODIFIER LETTER DOUBLE APOSTROPHE
     (16#0037A#, 16#0037A#),  -- GREEK YPOGEGRAMMENI .. GREEK YPOGEGRAMMENI
     (16#00386#, 16#00386#),  -- GREEK CAPITAL LETTER ALPHA WITH TONOS .. GREEK CAPITAL LETTER ALPHA WITH TONOS
     (16#00388#, 16#0038A#),  -- GREEK CAPITAL LETTER EPSILON WITH TONOS .. GREEK CAPITAL LETTER IOTA WITH TONOS
     (16#0038C#, 16#0038C#),  -- GREEK CAPITAL LETTER OMICRON WITH TONOS .. GREEK CAPITAL LETTER OMICRON WITH TONOS
     (16#0038E#, 16#003A1#),  -- GREEK CAPITAL LETTER UPSILON WITH TONOS .. GREEK CAPITAL LETTER RHO
     (16#003A3#, 16#003CE#),  -- GREEK CAPITAL LETTER SIGMA .. GREEK SMALL LETTER OMEGA WITH TONOS
     (16#003D0#, 16#003F5#),  -- GREEK BETA SYMBOL .. GREEK LUNATE EPSILON SYMBOL
     (16#003F7#, 16#003FB#),  -- GREEK CAPITAL LETTER SHO .. GREEK SMALL LETTER SAN
     (16#00400#, 16#00481#),  -- CYRILLIC CAPITAL LETTER IE WITH GRAVE .. CYRILLIC SMALL LETTER KOPPA
     (16#0048A#, 16#004CE#),  -- CYRILLIC CAPITAL LETTER SHORT I WITH TAIL .. CYRILLIC SMALL LETTER EM WITH TAIL
     (16#004D0#, 16#004F5#),  -- CYRILLIC CAPITAL LETTER A WITH BREVE .. CYRILLIC SMALL LETTER CHE WITH DIAERESIS
     (16#004F8#, 16#004F9#),  -- CYRILLIC CAPITAL LETTER YERU WITH DIAERESIS .. CYRILLIC SMALL LETTER YERU WITH DIAERESIS
     (16#00500#, 16#0050F#),  -- CYRILLIC CAPITAL LETTER KOMI DE .. CYRILLIC SMALL LETTER KOMI TJE
     (16#00531#, 16#00556#),  -- ARMENIAN CAPITAL LETTER AYB .. ARMENIAN CAPITAL LETTER FEH
     (16#00559#, 16#00559#),  -- ARMENIAN MODIFIER LETTER LEFT HALF RING .. ARMENIAN MODIFIER LETTER LEFT HALF RING
     (16#00561#, 16#00587#),  -- ARMENIAN SMALL LETTER AYB .. ARMENIAN SMALL LIGATURE ECH YIWN
     (16#005D0#, 16#005EA#),  -- HEBREW LETTER ALEF .. HEBREW LETTER TAV
     (16#005F0#, 16#005F2#),  -- HEBREW LIGATURE YIDDISH DOUBLE VAV .. HEBREW LIGATURE YIDDISH DOUBLE YOD
     (16#00621#, 16#0063A#),  -- ARABIC LETTER HAMZA .. ARABIC LETTER GHAIN
     (16#00640#, 16#0064A#),  -- ARABIC TATWEEL .. ARABIC LETTER YEH
     (16#0066E#, 16#0066F#),  -- ARABIC LETTER DOTLESS BEH .. ARABIC LETTER DOTLESS QAF
     (16#00671#, 16#006D3#),  -- ARABIC LETTER ALEF WASLA .. ARABIC LETTER YEH BARREE WITH HAMZA ABOVE
     (16#006D5#, 16#006D5#),  -- ARABIC LETTER AE .. ARABIC LETTER AE
     (16#006E5#, 16#006E6#),  -- ARABIC SMALL WAW .. ARABIC SMALL YEH
     (16#006EE#, 16#006EF#),  -- ARABIC LETTER DAL WITH INVERTED V .. ARABIC LETTER REH WITH INVERTED V
     (16#006FA#, 16#006FC#),  -- ARABIC LETTER SHEEN WITH DOT BELOW .. ARABIC LETTER GHAIN WITH DOT BELOW
     (16#006FF#, 16#006FF#),  -- ARABIC LETTER HEH WITH INVERTED V .. ARABIC LETTER HEH WITH INVERTED V
     (16#00710#, 16#00710#),  -- SYRIAC LETTER ALAPH .. SYRIAC LETTER ALAPH
     (16#00712#, 16#0072F#),  -- SYRIAC LETTER BETH .. SYRIAC LETTER PERSIAN DHALATH
     (16#0074D#, 16#0074F#),  -- SYRIAC LETTER SOGDIAN ZHAIN .. SYRIAC LETTER SOGDIAN FE
     (16#00780#, 16#007A5#),  -- THAANA LETTER HAA .. THAANA LETTER WAAVU
     (16#007B1#, 16#007B1#),  -- THAANA LETTER NAA .. THAANA LETTER NAA
     (16#00904#, 16#00939#),  -- DEVANAGARI LETTER SHORT A .. DEVANAGARI LETTER HA
     (16#0093D#, 16#0093D#),  -- DEVANAGARI SIGN AVAGRAHA .. DEVANAGARI SIGN AVAGRAHA
     (16#00950#, 16#00950#),  -- DEVANAGARI OM .. DEVANAGARI OM
     (16#00958#, 16#00961#),  -- DEVANAGARI LETTER QA .. DEVANAGARI LETTER VOCALIC LL
     (16#00985#, 16#0098C#),  -- BENGALI LETTER A .. BENGALI LETTER VOCALIC L
     (16#0098F#, 16#00990#),  -- BENGALI LETTER E .. BENGALI LETTER AI
     (16#00993#, 16#009A8#),  -- BENGALI LETTER O .. BENGALI LETTER NA
     (16#009AA#, 16#009B0#),  -- BENGALI LETTER PA .. BENGALI LETTER RA
     (16#009B2#, 16#009B2#),  -- BENGALI LETTER LA .. BENGALI LETTER LA
     (16#009B6#, 16#009B9#),  -- BENGALI LETTER SHA .. BENGALI LETTER HA
     (16#009BD#, 16#009BD#),  -- BENGALI SIGN AVAGRAHA .. BENGALI SIGN AVAGRAHA
     (16#009DC#, 16#009DD#),  -- BENGALI LETTER RRA .. BENGALI LETTER RHA
     (16#009DF#, 16#009E1#),  -- BENGALI LETTER YYA .. BENGALI LETTER VOCALIC LL
     (16#009F0#, 16#009F1#),  -- BENGALI LETTER RA WITH MIDDLE DIAGONAL .. BENGALI LETTER RA WITH LOWER DIAGONAL
     (16#00A05#, 16#00A0A#),  -- GURMUKHI LETTER A .. GURMUKHI LETTER UU
     (16#00A0F#, 16#00A10#),  -- GURMUKHI LETTER EE .. GURMUKHI LETTER AI
     (16#00A13#, 16#00A28#),  -- GURMUKHI LETTER OO .. GURMUKHI LETTER NA
     (16#00A2A#, 16#00A30#),  -- GURMUKHI LETTER PA .. GURMUKHI LETTER RA
     (16#00A32#, 16#00A33#),  -- GURMUKHI LETTER LA .. GURMUKHI LETTER LLA
     (16#00A35#, 16#00A36#),  -- GURMUKHI LETTER VA .. GURMUKHI LETTER SHA
     (16#00A38#, 16#00A39#),  -- GURMUKHI LETTER SA .. GURMUKHI LETTER HA
     (16#00A59#, 16#00A5C#),  -- GURMUKHI LETTER KHHA .. GURMUKHI LETTER RRA
     (16#00A5E#, 16#00A5E#),  -- GURMUKHI LETTER FA .. GURMUKHI LETTER FA
     (16#00A72#, 16#00A74#),  -- GURMUKHI IRI .. GURMUKHI EK ONKAR
     (16#00A85#, 16#00A8D#),  -- GUJARATI LETTER A .. GUJARATI VOWEL CANDRA E
     (16#00A8F#, 16#00A91#),  -- GUJARATI LETTER E .. GUJARATI VOWEL CANDRA O
     (16#00A93#, 16#00AA8#),  -- GUJARATI LETTER O .. GUJARATI LETTER NA
     (16#00AAA#, 16#00AB0#),  -- GUJARATI LETTER PA .. GUJARATI LETTER RA
     (16#00AB2#, 16#00AB3#),  -- GUJARATI LETTER LA .. GUJARATI LETTER LLA
     (16#00AB5#, 16#00AB9#),  -- GUJARATI LETTER VA .. GUJARATI LETTER HA
     (16#00ABD#, 16#00ABD#),  -- GUJARATI SIGN AVAGRAHA .. GUJARATI SIGN AVAGRAHA
     (16#00AD0#, 16#00AD0#),  -- GUJARATI OM .. GUJARATI OM
     (16#00AE0#, 16#00AE1#),  -- GUJARATI LETTER VOCALIC RR .. GUJARATI LETTER VOCALIC LL
     (16#00B05#, 16#00B0C#),  -- ORIYA LETTER A .. ORIYA LETTER VOCALIC L
     (16#00B0F#, 16#00B10#),  -- ORIYA LETTER E .. ORIYA LETTER AI
     (16#00B13#, 16#00B28#),  -- ORIYA LETTER O .. ORIYA LETTER NA
     (16#00B2A#, 16#00B30#),  -- ORIYA LETTER PA .. ORIYA LETTER RA
     (16#00B32#, 16#00B33#),  -- ORIYA LETTER LA .. ORIYA LETTER LLA
     (16#00B35#, 16#00B39#),  -- ORIYA LETTER VA .. ORIYA LETTER HA
     (16#00B3D#, 16#00B3D#),  -- ORIYA SIGN AVAGRAHA .. ORIYA SIGN AVAGRAHA
     (16#00B5C#, 16#00B5D#),  -- ORIYA LETTER RRA .. ORIYA LETTER RHA
     (16#00B5F#, 16#00B61#),  -- ORIYA LETTER YYA .. ORIYA LETTER VOCALIC LL
     (16#00B71#, 16#00B71#),  -- ORIYA LETTER WA .. ORIYA LETTER WA
     (16#00B83#, 16#00B83#),  -- TAMIL SIGN VISARGA .. TAMIL SIGN VISARGA
     (16#00B85#, 16#00B8A#),  -- TAMIL LETTER A .. TAMIL LETTER UU
     (16#00B8E#, 16#00B90#),  -- TAMIL LETTER E .. TAMIL LETTER AI
     (16#00B92#, 16#00B95#),  -- TAMIL LETTER O .. TAMIL LETTER KA
     (16#00B99#, 16#00B9A#),  -- TAMIL LETTER NGA .. TAMIL LETTER CA
     (16#00B9C#, 16#00B9C#),  -- TAMIL LETTER JA .. TAMIL LETTER JA
     (16#00B9E#, 16#00B9F#),  -- TAMIL LETTER NYA .. TAMIL LETTER TTA
     (16#00BA3#, 16#00BA4#),  -- TAMIL LETTER NNA .. TAMIL LETTER TA
     (16#00BA8#, 16#00BAA#),  -- TAMIL LETTER NA .. TAMIL LETTER PA
     (16#00BAE#, 16#00BB5#),  -- TAMIL LETTER MA .. TAMIL LETTER VA
     (16#00BB7#, 16#00BB9#),  -- TAMIL LETTER SSA .. TAMIL LETTER HA
     (16#00C05#, 16#00C0C#),  -- TELUGU LETTER A .. TELUGU LETTER VOCALIC L
     (16#00C0E#, 16#00C10#),  -- TELUGU LETTER E .. TELUGU LETTER AI
     (16#00C12#, 16#00C28#),  -- TELUGU LETTER O .. TELUGU LETTER NA
     (16#00C2A#, 16#00C33#),  -- TELUGU LETTER PA .. TELUGU LETTER LLA
     (16#00C35#, 16#00C39#),  -- TELUGU LETTER VA .. TELUGU LETTER HA
     (16#00C60#, 16#00C61#),  -- TELUGU LETTER VOCALIC RR .. TELUGU LETTER VOCALIC LL
     (16#00C85#, 16#00C8C#),  -- KANNADA LETTER A .. KANNADA LETTER VOCALIC L
     (16#00C8E#, 16#00C90#),  -- KANNADA LETTER E .. KANNADA LETTER AI
     (16#00C92#, 16#00CA8#),  -- KANNADA LETTER O .. KANNADA LETTER NA
     (16#00CAA#, 16#00CB3#),  -- KANNADA LETTER PA .. KANNADA LETTER LLA
     (16#00CB5#, 16#00CB9#),  -- KANNADA LETTER VA .. KANNADA LETTER HA
     (16#00CBD#, 16#00CBD#),  -- KANNADA SIGN AVAGRAHA .. KANNADA SIGN AVAGRAHA
     (16#00CDE#, 16#00CDE#),  -- KANNADA LETTER FA .. KANNADA LETTER FA
     (16#00CE0#, 16#00CE1#),  -- KANNADA LETTER VOCALIC RR .. KANNADA LETTER VOCALIC LL
     (16#00D05#, 16#00D0C#),  -- MALAYALAM LETTER A .. MALAYALAM LETTER VOCALIC L
     (16#00D0E#, 16#00D10#),  -- MALAYALAM LETTER E .. MALAYALAM LETTER AI
     (16#00D12#, 16#00D28#),  -- MALAYALAM LETTER O .. MALAYALAM LETTER NA
     (16#00D2A#, 16#00D39#),  -- MALAYALAM LETTER PA .. MALAYALAM LETTER HA
     (16#00D60#, 16#00D61#),  -- MALAYALAM LETTER VOCALIC RR .. MALAYALAM LETTER VOCALIC LL
     (16#00D85#, 16#00D96#),  -- SINHALA LETTER AYANNA .. SINHALA LETTER AUYANNA
     (16#00D9A#, 16#00DB1#),  -- SINHALA LETTER ALPAPRAANA KAYANNA .. SINHALA LETTER DANTAJA NAYANNA
     (16#00DB3#, 16#00DBB#),  -- SINHALA LETTER SANYAKA DAYANNA .. SINHALA LETTER RAYANNA
     (16#00DBD#, 16#00DBD#),  -- SINHALA LETTER DANTAJA LAYANNA .. SINHALA LETTER DANTAJA LAYANNA
     (16#00DC0#, 16#00DC6#),  -- SINHALA LETTER VAYANNA .. SINHALA LETTER FAYANNA
     (16#00E01#, 16#00E30#),  -- THAI CHARACTER KO KAI .. THAI CHARACTER SARA A
     (16#00E32#, 16#00E33#),  -- THAI CHARACTER SARA AA .. THAI CHARACTER SARA AM
     (16#00E40#, 16#00E46#),  -- THAI CHARACTER SARA E .. THAI CHARACTER MAIYAMOK
     (16#00E81#, 16#00E82#),  -- LAO LETTER KO .. LAO LETTER KHO SUNG
     (16#00E84#, 16#00E84#),  -- LAO LETTER KHO TAM .. LAO LETTER KHO TAM
     (16#00E87#, 16#00E88#),  -- LAO LETTER NGO .. LAO LETTER CO
     (16#00E8A#, 16#00E8A#),  -- LAO LETTER SO TAM .. LAO LETTER SO TAM
     (16#00E8D#, 16#00E8D#),  -- LAO LETTER NYO .. LAO LETTER NYO
     (16#00E94#, 16#00E97#),  -- LAO LETTER DO .. LAO LETTER THO TAM
     (16#00E99#, 16#00E9F#),  -- LAO LETTER NO .. LAO LETTER FO SUNG
     (16#00EA1#, 16#00EA3#),  -- LAO LETTER MO .. LAO LETTER LO LING
     (16#00EA5#, 16#00EA5#),  -- LAO LETTER LO LOOT .. LAO LETTER LO LOOT
     (16#00EA7#, 16#00EA7#),  -- LAO LETTER WO .. LAO LETTER WO
     (16#00EAA#, 16#00EAB#),  -- LAO LETTER SO SUNG .. LAO LETTER HO SUNG
     (16#00EAD#, 16#00EB0#),  -- LAO LETTER O .. LAO VOWEL SIGN A
     (16#00EB2#, 16#00EB3#),  -- LAO VOWEL SIGN AA .. LAO VOWEL SIGN AM
     (16#00EBD#, 16#00EBD#),  -- LAO SEMIVOWEL SIGN NYO .. LAO SEMIVOWEL SIGN NYO
     (16#00EC0#, 16#00EC4#),  -- LAO VOWEL SIGN E .. LAO VOWEL SIGN AI
     (16#00EC6#, 16#00EC6#),  -- LAO KO LA .. LAO KO LA
     (16#00EDC#, 16#00EDD#),  -- LAO HO NO .. LAO HO MO
     (16#00F00#, 16#00F00#),  -- TIBETAN SYLLABLE OM .. TIBETAN SYLLABLE OM
     (16#00F40#, 16#00F47#),  -- TIBETAN LETTER KA .. TIBETAN LETTER JA
     (16#00F49#, 16#00F6A#),  -- TIBETAN LETTER NYA .. TIBETAN LETTER FIXED-FORM RA
     (16#00F88#, 16#00F8B#),  -- TIBETAN SIGN LCE TSA CAN .. TIBETAN SIGN GRU MED RGYINGS
     (16#01000#, 16#01021#),  -- MYANMAR LETTER KA .. MYANMAR LETTER A
     (16#01023#, 16#01027#),  -- MYANMAR LETTER I .. MYANMAR LETTER E
     (16#01029#, 16#0102A#),  -- MYANMAR LETTER O .. MYANMAR LETTER AU
     (16#01050#, 16#01055#),  -- MYANMAR LETTER SHA .. MYANMAR LETTER VOCALIC LL
     (16#010A0#, 16#010C5#),  -- GEORGIAN CAPITAL LETTER AN .. GEORGIAN CAPITAL LETTER HOE
     (16#010D0#, 16#010F8#),  -- GEORGIAN LETTER AN .. GEORGIAN LETTER ELIFI
     (16#01100#, 16#01159#),  -- HANGUL CHOSEONG KIYEOK .. HANGUL CHOSEONG YEORINHIEUH
     (16#0115F#, 16#011A2#),  -- HANGUL CHOSEONG FILLER .. HANGUL JUNGSEONG SSANGARAEA
     (16#011A8#, 16#011F9#),  -- HANGUL JONGSEONG KIYEOK .. HANGUL JONGSEONG YEORINHIEUH
     (16#01200#, 16#01206#),  -- ETHIOPIC SYLLABLE HA .. ETHIOPIC SYLLABLE HO
     (16#01208#, 16#01246#),  -- ETHIOPIC SYLLABLE LA .. ETHIOPIC SYLLABLE QO
     (16#01248#, 16#01248#),  -- ETHIOPIC SYLLABLE QWA .. ETHIOPIC SYLLABLE QWA
     (16#0124A#, 16#0124D#),  -- ETHIOPIC SYLLABLE QWI .. ETHIOPIC SYLLABLE QWE
     (16#01250#, 16#01256#),  -- ETHIOPIC SYLLABLE QHA .. ETHIOPIC SYLLABLE QHO
     (16#01258#, 16#01258#),  -- ETHIOPIC SYLLABLE QHWA .. ETHIOPIC SYLLABLE QHWA
     (16#0125A#, 16#0125D#),  -- ETHIOPIC SYLLABLE QHWI .. ETHIOPIC SYLLABLE QHWE
     (16#01260#, 16#01286#),  -- ETHIOPIC SYLLABLE BA .. ETHIOPIC SYLLABLE XO
     (16#01288#, 16#01288#),  -- ETHIOPIC SYLLABLE XWA .. ETHIOPIC SYLLABLE XWA
     (16#0128A#, 16#0128D#),  -- ETHIOPIC SYLLABLE XWI .. ETHIOPIC SYLLABLE XWE
     (16#01290#, 16#012AE#),  -- ETHIOPIC SYLLABLE NA .. ETHIOPIC SYLLABLE KO
     (16#012B0#, 16#012B0#),  -- ETHIOPIC SYLLABLE KWA .. ETHIOPIC SYLLABLE KWA
     (16#012B2#, 16#012B5#),  -- ETHIOPIC SYLLABLE KWI .. ETHIOPIC SYLLABLE KWE
     (16#012B8#, 16#012BE#),  -- ETHIOPIC SYLLABLE KXA .. ETHIOPIC SYLLABLE KXO
     (16#012C0#, 16#012C0#),  -- ETHIOPIC SYLLABLE KXWA .. ETHIOPIC SYLLABLE KXWA
     (16#012C2#, 16#012C5#),  -- ETHIOPIC SYLLABLE KXWI .. ETHIOPIC SYLLABLE KXWE
     (16#012C8#, 16#012CE#),  -- ETHIOPIC SYLLABLE WA .. ETHIOPIC SYLLABLE WO
     (16#012D0#, 16#012D6#),  -- ETHIOPIC SYLLABLE PHARYNGEAL A .. ETHIOPIC SYLLABLE PHARYNGEAL O
     (16#012D8#, 16#012EE#),  -- ETHIOPIC SYLLABLE ZA .. ETHIOPIC SYLLABLE YO
     (16#012F0#, 16#0130E#),  -- ETHIOPIC SYLLABLE DA .. ETHIOPIC SYLLABLE GO
     (16#01310#, 16#01310#),  -- ETHIOPIC SYLLABLE GWA .. ETHIOPIC SYLLABLE GWA
     (16#01312#, 16#01315#),  -- ETHIOPIC SYLLABLE GWI .. ETHIOPIC SYLLABLE GWE
     (16#01318#, 16#0131E#),  -- ETHIOPIC SYLLABLE GGA .. ETHIOPIC SYLLABLE GGO
     (16#01320#, 16#01346#),  -- ETHIOPIC SYLLABLE THA .. ETHIOPIC SYLLABLE TZO
     (16#01348#, 16#0135A#),  -- ETHIOPIC SYLLABLE FA .. ETHIOPIC SYLLABLE FYA
     (16#013A0#, 16#013F4#),  -- CHEROKEE LETTER A .. CHEROKEE LETTER YV
     (16#01401#, 16#0166C#),  -- CANADIAN SYLLABICS E .. CANADIAN SYLLABICS CARRIER TTSA
     (16#0166F#, 16#01676#),  -- CANADIAN SYLLABICS QAI .. CANADIAN SYLLABICS NNGAA
     (16#01681#, 16#0169A#),  -- OGHAM LETTER BEITH .. OGHAM LETTER PEITH
     (16#016A0#, 16#016EA#),  -- RUNIC LETTER FEHU FEOH FE F .. RUNIC LETTER X
     (16#016EE#, 16#016F0#),  -- RUNIC ARLAUG SYMBOL .. RUNIC BELGTHOR SYMBOL
     (16#01700#, 16#0170C#),  -- TAGALOG LETTER A .. TAGALOG LETTER YA
     (16#0170E#, 16#01711#),  -- TAGALOG LETTER LA .. TAGALOG LETTER HA
     (16#01720#, 16#01731#),  -- HANUNOO LETTER A .. HANUNOO LETTER HA
     (16#01740#, 16#01751#),  -- BUHID LETTER A .. BUHID LETTER HA
     (16#01760#, 16#0176C#),  -- TAGBANWA LETTER A .. TAGBANWA LETTER YA
     (16#0176E#, 16#01770#),  -- TAGBANWA LETTER LA .. TAGBANWA LETTER SA
     (16#01780#, 16#017B3#),  -- KHMER LETTER KA .. KHMER INDEPENDENT VOWEL QAU
     (16#017D7#, 16#017D7#),  -- KHMER SIGN LEK TOO .. KHMER SIGN LEK TOO
     (16#017DC#, 16#017DC#),  -- KHMER SIGN AVAKRAHASANYA .. KHMER SIGN AVAKRAHASANYA
     (16#01820#, 16#01877#),  -- MONGOLIAN LETTER A .. MONGOLIAN LETTER MANCHU ZHA
     (16#01880#, 16#018A8#),  -- MONGOLIAN LETTER ALI GALI ANUSVARA ONE .. MONGOLIAN LETTER MANCHU ALI GALI BHA
     (16#01900#, 16#0191C#),  -- LIMBU VOWEL-CARRIER LETTER .. LIMBU LETTER HA
     (16#01950#, 16#0196D#),  -- TAI LE LETTER KA .. TAI LE LETTER AI
     (16#01970#, 16#01974#),  -- TAI LE LETTER TONE-2 .. TAI LE LETTER TONE-6
     (16#01D00#, 16#01D6B#),  -- LATIN LETTER SMALL CAPITAL A .. LATIN SMALL LETTER UE
     (16#01E00#, 16#01E9B#),  -- LATIN CAPITAL LETTER A WITH RING BELOW .. LATIN SMALL LETTER LONG S WITH DOT ABOVE
     (16#01EA0#, 16#01EF9#),  -- LATIN CAPITAL LETTER A WITH DOT BELOW .. LATIN SMALL LETTER Y WITH TILDE
     (16#01F00#, 16#01F15#),  -- GREEK SMALL LETTER ALPHA WITH PSILI .. GREEK SMALL LETTER EPSILON WITH DASIA AND OXIA
     (16#01F18#, 16#01F1D#),  -- GREEK CAPITAL LETTER EPSILON WITH PSILI .. GREEK CAPITAL LETTER EPSILON WITH DASIA AND OXIA
     (16#01F20#, 16#01F45#),  -- GREEK SMALL LETTER ETA WITH PSILI .. GREEK SMALL LETTER OMICRON WITH DASIA AND OXIA
     (16#01F48#, 16#01F4D#),  -- GREEK CAPITAL LETTER OMICRON WITH PSILI .. GREEK CAPITAL LETTER OMICRON WITH DASIA AND OXIA
     (16#01F50#, 16#01F57#),  -- GREEK SMALL LETTER UPSILON WITH PSILI .. GREEK SMALL LETTER UPSILON WITH DASIA AND PERISPOMENI
     (16#01F59#, 16#01F59#),  -- GREEK CAPITAL LETTER UPSILON WITH DASIA .. GREEK CAPITAL LETTER UPSILON WITH DASIA
     (16#01F5B#, 16#01F5B#),  -- GREEK CAPITAL LETTER UPSILON WITH DASIA AND VARIA .. GREEK CAPITAL LETTER UPSILON WITH DASIA AND VARIA
     (16#01F5D#, 16#01F5D#),  -- GREEK CAPITAL LETTER UPSILON WITH DASIA AND OXIA .. GREEK CAPITAL LETTER UPSILON WITH DASIA AND OXIA
     (16#01F5F#, 16#01F7D#),  -- GREEK CAPITAL LETTER UPSILON WITH DASIA AND PERISPOMENI .. GREEK SMALL LETTER OMEGA WITH OXIA
     (16#01F80#, 16#01FB4#),  -- GREEK SMALL LETTER ALPHA WITH PSILI AND YPOGEGRAMMENI .. GREEK SMALL LETTER ALPHA WITH OXIA AND YPOGEGRAMMENI
     (16#01FB6#, 16#01FBC#),  -- GREEK SMALL LETTER ALPHA WITH PERISPOMENI .. GREEK CAPITAL LETTER ALPHA WITH PROSGEGRAMMENI
     (16#01FBE#, 16#01FBE#),  -- GREEK PROSGEGRAMMENI .. GREEK PROSGEGRAMMENI
     (16#01FC2#, 16#01FC4#),  -- GREEK SMALL LETTER ETA WITH VARIA AND YPOGEGRAMMENI .. GREEK SMALL LETTER ETA WITH OXIA AND YPOGEGRAMMENI
     (16#01FC6#, 16#01FCC#),  -- GREEK SMALL LETTER ETA WITH PERISPOMENI .. GREEK CAPITAL LETTER ETA WITH PROSGEGRAMMENI
     (16#01FD0#, 16#01FD3#),  -- GREEK SMALL LETTER IOTA WITH VRACHY .. GREEK SMALL LETTER IOTA WITH DIALYTIKA AND OXIA
     (16#01FD6#, 16#01FDB#),  -- GREEK SMALL LETTER IOTA WITH PERISPOMENI .. GREEK CAPITAL LETTER IOTA WITH OXIA
     (16#01FE0#, 16#01FEC#),  -- GREEK SMALL LETTER UPSILON WITH VRACHY .. GREEK CAPITAL LETTER RHO WITH DASIA
     (16#01FF2#, 16#01FF4#),  -- GREEK SMALL LETTER OMEGA WITH VARIA AND YPOGEGRAMMENI .. GREEK SMALL LETTER OMEGA WITH OXIA AND YPOGEGRAMMENI
     (16#01FF6#, 16#01FFC#),  -- GREEK SMALL LETTER OMEGA WITH PERISPOMENI .. GREEK CAPITAL LETTER OMEGA WITH PROSGEGRAMMENI
     (16#02071#, 16#02071#),  -- SUPERSCRIPT LATIN SMALL LETTER I .. SUPERSCRIPT LATIN SMALL LETTER I
     (16#0207F#, 16#0207F#),  -- SUPERSCRIPT LATIN SMALL LETTER N .. SUPERSCRIPT LATIN SMALL LETTER N
     (16#02102#, 16#02102#),  -- DOUBLE-STRUCK CAPITAL C .. DOUBLE-STRUCK CAPITAL C
     (16#02107#, 16#02107#),  -- EULER CONSTANT .. EULER CONSTANT
     (16#0210A#, 16#02113#),  -- SCRIPT SMALL G .. SCRIPT SMALL L
     (16#02115#, 16#02115#),  -- DOUBLE-STRUCK CAPITAL N .. DOUBLE-STRUCK CAPITAL N
     (16#02119#, 16#0211D#),  -- DOUBLE-STRUCK CAPITAL P .. DOUBLE-STRUCK CAPITAL R
     (16#02124#, 16#02124#),  -- DOUBLE-STRUCK CAPITAL Z .. DOUBLE-STRUCK CAPITAL Z
     (16#02126#, 16#02126#),  -- OHM SIGN .. OHM SIGN
     (16#02128#, 16#02128#),  -- BLACK-LETTER CAPITAL Z .. BLACK-LETTER CAPITAL Z
     (16#0212A#, 16#0212D#),  -- KELVIN SIGN .. BLACK-LETTER CAPITAL C
     (16#0212F#, 16#02131#),  -- SCRIPT SMALL E .. SCRIPT CAPITAL F
     (16#02133#, 16#02139#),  -- SCRIPT CAPITAL M .. INFORMATION SOURCE
     (16#0213D#, 16#0213F#),  -- DOUBLE-STRUCK SMALL GAMMA .. DOUBLE-STRUCK CAPITAL PI
     (16#02145#, 16#02149#),  -- DOUBLE-STRUCK ITALIC CAPITAL D .. DOUBLE-STRUCK ITALIC SMALL J
     (16#02160#, 16#02183#),  -- ROMAN NUMERAL ONE .. ROMAN NUMERAL REVERSED ONE HUNDRED
     (16#03005#, 16#03007#),  -- IDEOGRAPHIC ITERATION MARK .. IDEOGRAPHIC NUMBER ZERO
     (16#03021#, 16#03029#),  -- HANGZHOU NUMERAL ONE .. HANGZHOU NUMERAL NINE
     (16#03031#, 16#03035#),  -- VERTICAL KANA REPEAT MARK .. VERTICAL KANA REPEAT MARK LOWER HALF
     (16#03038#, 16#0303C#),  -- HANGZHOU NUMERAL TEN .. MASU MARK
     (16#03041#, 16#03096#),  -- HIRAGANA LETTER SMALL A .. HIRAGANA LETTER SMALL KE
     (16#0309D#, 16#0309F#),  -- HIRAGANA ITERATION MARK .. HIRAGANA DIGRAPH YORI
     (16#030A1#, 16#030FA#),  -- KATAKANA LETTER SMALL A .. KATAKANA LETTER VO
     (16#030FC#, 16#030FF#),  -- KATAKANA-HIRAGANA PROLONGED SOUND MARK .. KATAKANA DIGRAPH KOTO
     (16#03105#, 16#0312C#),  -- BOPOMOFO LETTER B .. BOPOMOFO LETTER GN
     (16#03131#, 16#0318E#),  -- HANGUL LETTER KIYEOK .. HANGUL LETTER ARAEAE
     (16#031A0#, 16#031B7#),  -- BOPOMOFO LETTER BU .. BOPOMOFO FINAL LETTER H
     (16#031F0#, 16#031FF#),  -- KATAKANA LETTER SMALL KU .. KATAKANA LETTER SMALL RO
     (16#03400#, 16#04DB5#),  -- <CJK Ideograph Extension A, First> .. <CJK Ideograph Extension A, Last>
     (16#04E00#, 16#09FA5#),  -- <CJK Ideograph, First> .. <CJK Ideograph, Last>
     (16#0A000#, 16#0A48C#),  -- YI SYLLABLE IT .. YI SYLLABLE YYR
     (16#0AC00#, 16#0D7A3#),  -- <Hangul Syllable, First> .. <Hangul Syllable, Last>
     (16#0F900#, 16#0FA2D#),  -- CJK COMPATIBILITY IDEOGRAPH-F900 .. CJK COMPATIBILITY IDEOGRAPH-FA2D
     (16#0FA30#, 16#0FA6A#),  -- CJK COMPATIBILITY IDEOGRAPH-FA30 .. CJK COMPATIBILITY IDEOGRAPH-FA6A
     (16#0FB00#, 16#0FB06#),  -- LATIN SMALL LIGATURE FF .. LATIN SMALL LIGATURE ST
     (16#0FB13#, 16#0FB17#),  -- ARMENIAN SMALL LIGATURE MEN NOW .. ARMENIAN SMALL LIGATURE MEN XEH
     (16#0FB1D#, 16#0FB1D#),  -- HEBREW LETTER YOD WITH HIRIQ .. HEBREW LETTER YOD WITH HIRIQ
     (16#0FB1F#, 16#0FB28#),  -- HEBREW LIGATURE YIDDISH YOD YOD PATAH .. HEBREW LETTER WIDE TAV
     (16#0FB2A#, 16#0FB36#),  -- HEBREW LETTER SHIN WITH SHIN DOT .. HEBREW LETTER ZAYIN WITH DAGESH
     (16#0FB38#, 16#0FB3C#),  -- HEBREW LETTER TET WITH DAGESH .. HEBREW LETTER LAMED WITH DAGESH
     (16#0FB3E#, 16#0FB3E#),  -- HEBREW LETTER MEM WITH DAGESH .. HEBREW LETTER MEM WITH DAGESH
     (16#0FB40#, 16#0FB41#),  -- HEBREW LETTER NUN WITH DAGESH .. HEBREW LETTER SAMEKH WITH DAGESH
     (16#0FB43#, 16#0FB44#),  -- HEBREW LETTER FINAL PE WITH DAGESH .. HEBREW LETTER PE WITH DAGESH
     (16#0FB46#, 16#0FBB1#),  -- HEBREW LETTER TSADI WITH DAGESH .. ARABIC LETTER YEH BARREE WITH HAMZA ABOVE FINAL FORM
     (16#0FBD3#, 16#0FD3D#),  -- ARABIC LETTER NG ISOLATED FORM .. ARABIC LIGATURE ALEF WITH FATHATAN ISOLATED FORM
     (16#0FD50#, 16#0FD8F#),  -- ARABIC LIGATURE TEH WITH JEEM WITH MEEM INITIAL FORM .. ARABIC LIGATURE MEEM WITH KHAH WITH MEEM INITIAL FORM
     (16#0FD92#, 16#0FDC7#),  -- ARABIC LIGATURE MEEM WITH JEEM WITH KHAH INITIAL FORM .. ARABIC LIGATURE NOON WITH JEEM WITH YEH FINAL FORM
     (16#0FDF0#, 16#0FDFB#),  -- ARABIC LIGATURE SALLA USED AS KORANIC STOP SIGN ISOLATED FORM .. ARABIC LIGATURE JALLAJALALOUHOU
     (16#0FE70#, 16#0FE74#),  -- ARABIC FATHATAN ISOLATED FORM .. ARABIC KASRATAN ISOLATED FORM
     (16#0FE76#, 16#0FEFC#),  -- ARABIC FATHA ISOLATED FORM .. ARABIC LIGATURE LAM WITH ALEF FINAL FORM
     (16#0FF21#, 16#0FF3A#),  -- FULLWIDTH LATIN CAPITAL LETTER A .. FULLWIDTH LATIN CAPITAL LETTER Z
     (16#0FF41#, 16#0FF5A#),  -- FULLWIDTH LATIN SMALL LETTER A .. FULLWIDTH LATIN SMALL LETTER Z
     (16#0FF66#, 16#0FFBE#),  -- HALFWIDTH KATAKANA LETTER WO .. HALFWIDTH HANGUL LETTER HIEUH
     (16#0FFC2#, 16#0FFC7#),  -- HALFWIDTH HANGUL LETTER A .. HALFWIDTH HANGUL LETTER E
     (16#0FFCA#, 16#0FFCF#),  -- HALFWIDTH HANGUL LETTER YEO .. HALFWIDTH HANGUL LETTER OE
     (16#0FFD2#, 16#0FFD7#),  -- HALFWIDTH HANGUL LETTER YO .. HALFWIDTH HANGUL LETTER YU
     (16#0FFDA#, 16#0FFDC#),  -- HALFWIDTH HANGUL LETTER EU .. HALFWIDTH HANGUL LETTER I
     (16#10000#, 16#1000B#),  -- LINEAR B SYLLABLE B008 A .. LINEAR B SYLLABLE B046 JE
     (16#1000D#, 16#10026#),  -- LINEAR B SYLLABLE B036 JO .. LINEAR B SYLLABLE B032 QO
     (16#10028#, 16#1003A#),  -- LINEAR B SYLLABLE B060 RA .. LINEAR B SYLLABLE B042 WO
     (16#1003C#, 16#1003D#),  -- LINEAR B SYLLABLE B017 ZA .. LINEAR B SYLLABLE B074 ZE
     (16#1003F#, 16#1004D#),  -- LINEAR B SYLLABLE B020 ZO .. LINEAR B SYLLABLE B091 TWO
     (16#10050#, 16#1005D#),  -- LINEAR B SYMBOL B018 .. LINEAR B SYMBOL B089
     (16#10080#, 16#100FA#),  -- LINEAR B IDEOGRAM B100 MAN .. LINEAR B IDEOGRAM VESSEL B305
     (16#10300#, 16#1031E#),  -- OLD ITALIC LETTER A .. OLD ITALIC LETTER UU
     (16#10330#, 16#1034A#),  -- GOTHIC LETTER AHSA .. GOTHIC LETTER NINE HUNDRED
     (16#10380#, 16#1039D#),  -- UGARITIC LETTER ALPA .. UGARITIC LETTER SSU
     (16#10400#, 16#1049D#),  -- DESERET CAPITAL LETTER LONG I .. OSMANYA LETTER OO
     (16#10800#, 16#10805#),  -- CYPRIOT SYLLABLE A .. CYPRIOT SYLLABLE JA
     (16#10808#, 16#10808#),  -- CYPRIOT SYLLABLE JO .. CYPRIOT SYLLABLE JO
     (16#1080A#, 16#10835#),  -- CYPRIOT SYLLABLE KA .. CYPRIOT SYLLABLE WO
     (16#10837#, 16#10838#),  -- CYPRIOT SYLLABLE XA .. CYPRIOT SYLLABLE XE
     (16#1083C#, 16#1083C#),  -- CYPRIOT SYLLABLE ZA .. CYPRIOT SYLLABLE ZA
     (16#1083F#, 16#1083F#),  -- CYPRIOT SYLLABLE ZO .. CYPRIOT SYLLABLE ZO
     (16#1D400#, 16#1D454#),  -- MATHEMATICAL BOLD CAPITAL A .. MATHEMATICAL ITALIC SMALL G
     (16#1D456#, 16#1D49C#),  -- MATHEMATICAL ITALIC SMALL I .. MATHEMATICAL SCRIPT CAPITAL A
     (16#1D49E#, 16#1D49F#),  -- MATHEMATICAL SCRIPT CAPITAL C .. MATHEMATICAL SCRIPT CAPITAL D
     (16#1D4A2#, 16#1D4A2#),  -- MATHEMATICAL SCRIPT CAPITAL G .. MATHEMATICAL SCRIPT CAPITAL G
     (16#1D4A5#, 16#1D4A6#),  -- MATHEMATICAL SCRIPT CAPITAL J .. MATHEMATICAL SCRIPT CAPITAL K
     (16#1D4A9#, 16#1D4AC#),  -- MATHEMATICAL SCRIPT CAPITAL N .. MATHEMATICAL SCRIPT CAPITAL Q
     (16#1D4AE#, 16#1D4B9#),  -- MATHEMATICAL SCRIPT CAPITAL S .. MATHEMATICAL SCRIPT SMALL D
     (16#1D4BB#, 16#1D4BB#),  -- MATHEMATICAL SCRIPT SMALL F .. MATHEMATICAL SCRIPT SMALL F
     (16#1D4BD#, 16#1D4C3#),  -- MATHEMATICAL SCRIPT SMALL H .. MATHEMATICAL SCRIPT SMALL N
     (16#1D4C5#, 16#1D505#),  -- MATHEMATICAL SCRIPT SMALL P .. MATHEMATICAL FRAKTUR CAPITAL B
     (16#1D507#, 16#1D50A#),  -- MATHEMATICAL FRAKTUR CAPITAL D .. MATHEMATICAL FRAKTUR CAPITAL G
     (16#1D50D#, 16#1D514#),  -- MATHEMATICAL FRAKTUR CAPITAL J .. MATHEMATICAL FRAKTUR CAPITAL Q
     (16#1D516#, 16#1D51C#),  -- MATHEMATICAL FRAKTUR CAPITAL S .. MATHEMATICAL FRAKTUR CAPITAL Y
     (16#1D51E#, 16#1D539#),  -- MATHEMATICAL FRAKTUR SMALL A .. MATHEMATICAL DOUBLE-STRUCK CAPITAL B
     (16#1D53B#, 16#1D53E#),  -- MATHEMATICAL DOUBLE-STRUCK CAPITAL D .. MATHEMATICAL DOUBLE-STRUCK CAPITAL G
     (16#1D540#, 16#1D544#),  -- MATHEMATICAL DOUBLE-STRUCK CAPITAL I .. MATHEMATICAL DOUBLE-STRUCK CAPITAL M
     (16#1D546#, 16#1D546#),  -- MATHEMATICAL DOUBLE-STRUCK CAPITAL O .. MATHEMATICAL DOUBLE-STRUCK CAPITAL O
     (16#1D54A#, 16#1D550#),  -- MATHEMATICAL DOUBLE-STRUCK CAPITAL S .. MATHEMATICAL DOUBLE-STRUCK CAPITAL Y
     (16#1D552#, 16#1D6A3#),  -- MATHEMATICAL DOUBLE-STRUCK SMALL A .. MATHEMATICAL MONOSPACE SMALL Z
     (16#1D6A8#, 16#1D6C0#),  -- MATHEMATICAL BOLD CAPITAL ALPHA .. MATHEMATICAL BOLD CAPITAL OMEGA
     (16#1D6C2#, 16#1D6DA#),  -- MATHEMATICAL BOLD SMALL ALPHA .. MATHEMATICAL BOLD SMALL OMEGA
     (16#1D6DC#, 16#1D6FA#),  -- MATHEMATICAL BOLD EPSILON SYMBOL .. MATHEMATICAL ITALIC CAPITAL OMEGA
     (16#1D6FC#, 16#1D714#),  -- MATHEMATICAL ITALIC SMALL ALPHA .. MATHEMATICAL ITALIC SMALL OMEGA
     (16#1D716#, 16#1D734#),  -- MATHEMATICAL ITALIC EPSILON SYMBOL .. MATHEMATICAL BOLD ITALIC CAPITAL OMEGA
     (16#1D736#, 16#1D74E#),  -- MATHEMATICAL BOLD ITALIC SMALL ALPHA .. MATHEMATICAL BOLD ITALIC SMALL OMEGA
     (16#1D750#, 16#1D76E#),  -- MATHEMATICAL BOLD ITALIC EPSILON SYMBOL .. MATHEMATICAL SANS-SERIF BOLD CAPITAL OMEGA
     (16#1D770#, 16#1D788#),  -- MATHEMATICAL SANS-SERIF BOLD SMALL ALPHA .. MATHEMATICAL SANS-SERIF BOLD SMALL OMEGA
     (16#1D78A#, 16#1D7A8#),  -- MATHEMATICAL SANS-SERIF BOLD EPSILON SYMBOL .. MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL OMEGA
     (16#1D7AA#, 16#1D7C2#),  -- MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL ALPHA .. MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL OMEGA
     (16#1D7C4#, 16#1D7C9#),  -- MATHEMATICAL SANS-SERIF BOLD ITALIC EPSILON SYMBOL .. MATHEMATICAL SANS-SERIF BOLD ITALIC PI SYMBOL
     (16#20000#, 16#2A6D6#),  -- <CJK Ideograph Extension B, First> .. <CJK Ideograph Extension B, Last>
     (16#2F800#, 16#2FA1D#)); -- CJK COMPATIBILITY IDEOGRAPH-2F800 .. CJK COMPATIBILITY IDEOGRAPH-2FA1D

   --  The following table includes all characters considered spaces, i.e.
   --  all characters from the Unicode table with categories:

   --    Separator, Space (Zs)

   UTF_32_Spaces : constant UTF_32_Ranges := (
     (16#00020#, 16#00020#),  -- SPACE .. SPACE
     (16#000A0#, 16#000A0#),  -- NO-BREAK SPACE .. NO-BREAK SPACE
     (16#01680#, 16#01680#),  -- OGHAM SPACE MARK .. OGHAM SPACE MARK
     (16#0180E#, 16#0180E#),  -- MONGOLIAN VOWEL SEPARATOR .. MONGOLIAN VOWEL SEPARATOR
     (16#02000#, 16#0200B#),  -- EN QUAD .. ZERO WIDTH SPACE
     (16#0202F#, 16#0202F#),  -- NARROW NO-BREAK SPACE .. NARROW NO-BREAK SPACE
     (16#0205F#, 16#0205F#),  -- MEDIUM MATHEMATICAL SPACE .. MEDIUM MATHEMATICAL SPACE
     (16#03000#, 16#03000#)); -- IDEOGRAPHIC SPACE .. IDEOGRAPHIC SPACE

   --  The following table includes all characters considered punctuation,
   --  i.e. all characters from the Unicode table with categories:

   --    Punctuation, Connector (Pc)

   UTF_32_Punctuation : constant UTF_32_Ranges := (
     (16#0005F#, 16#0005F#),  -- LOW LINE .. LOW LINE
     (16#0203F#, 16#02040#),  -- UNDERTIE .. CHARACTER TIE
     (16#02054#, 16#02054#),  -- INVERTED UNDERTIE .. INVERTED UNDERTIE
     (16#030FB#, 16#030FB#),  -- KATAKANA MIDDLE DOT .. KATAKANA MIDDLE DOT
     (16#0FE33#, 16#0FE34#),  -- PRESENTATION FORM FOR VERTICAL LOW LINE .. PRESENTATION FORM FOR VERTICAL WAVY LOW LINE
     (16#0FE4D#, 16#0FE4F#),  -- DASHED LOW LINE .. WAVY LOW LINE
     (16#0FF3F#, 16#0FF3F#),  -- FULLWIDTH LOW LINE .. FULLWIDTH LOW LINE
     (16#0FF65#, 16#0FF65#)); -- HALFWIDTH KATAKANA MIDDLE DOT .. HALFWIDTH KATAKANA MIDDLE DOT

   --  The following table includes all characters considered as other format,
   --  i.e. all characters from the Unicode table with categories:

   --    Other, Format (Cf)

   UTF_32_Other_Format : constant UTF_32_Ranges := (
     (16#000AD#, 16#000AD#),  -- SOFT HYPHEN .. SOFT HYPHEN
     (16#00600#, 16#00603#),  -- ARABIC NUMBER SIGN .. ARABIC SIGN SAFHA
     (16#006DD#, 16#006DD#),  -- ARABIC END OF AYAH .. ARABIC END OF AYAH
     (16#0070F#, 16#0070F#),  -- SYRIAC ABBREVIATION MARK .. SYRIAC ABBREVIATION MARK
     (16#017B4#, 16#017B5#),  -- KHMER VOWEL INHERENT AQ .. KHMER VOWEL INHERENT AA
     (16#0200C#, 16#0200F#),  -- ZERO WIDTH NON-JOINER .. RIGHT-TO-LEFT MARK
     (16#0202A#, 16#0202E#),  -- LEFT-TO-RIGHT EMBEDDING .. RIGHT-TO-LEFT OVERRIDE
     (16#02060#, 16#02063#),  -- WORD JOINER .. INVISIBLE SEPARATOR
     (16#0206A#, 16#0206F#),  -- INHIBIT SYMMETRIC SWAPPING .. NOMINAL DIGIT SHAPES
     (16#0FEFF#, 16#0FEFF#),  -- ZERO WIDTH NO-BREAK SPACE .. ZERO WIDTH NO-BREAK SPACE
     (16#0FFF9#, 16#0FFFB#),  -- INTERLINEAR ANNOTATION ANCHOR .. INTERLINEAR ANNOTATION TERMINATOR
     (16#1D173#, 16#1D17A#),  -- MUSICAL SYMBOL BEGIN BEAM .. MUSICAL SYMBOL END PHRASE
     (16#E0001#, 16#E0001#),  -- LANGUAGE TAG .. LANGUAGE TAG
     (16#E0020#, 16#E007F#)); -- TAG SPACE .. CANCEL TAG

   --  The following table includes all characters considered marks i.e.
   --  all characters from the Unicode table with categories:

   --    Mark, Nonspacing (Mn)
   --    Mark, Spacing Combining (Mc)

   UTF_32_Marks : constant UTF_32_Ranges := (
     (16#00300#, 16#00357#),  -- COMBINING GRAVE ACCENT .. COMBINING RIGHT HALF RING ABOVE
     (16#0035D#, 16#0036F#),  -- COMBINING DOUBLE BREVE .. COMBINING LATIN SMALL LETTER X
     (16#00483#, 16#00486#),  -- COMBINING CYRILLIC TITLO .. COMBINING CYRILLIC PSILI PNEUMATA
     (16#00591#, 16#005A1#),  -- HEBREW ACCENT ETNAHTA .. HEBREW ACCENT PAZER
     (16#005A3#, 16#005B9#),  -- HEBREW ACCENT MUNAH .. HEBREW POINT HOLAM
     (16#005BB#, 16#005BD#),  -- HEBREW POINT QUBUTS .. HEBREW POINT METEG
     (16#005BF#, 16#005BF#),  -- HEBREW POINT RAFE .. HEBREW POINT RAFE
     (16#005C1#, 16#005C2#),  -- HEBREW POINT SHIN DOT .. HEBREW POINT SIN DOT
     (16#005C4#, 16#005C4#),  -- HEBREW MARK UPPER DOT .. HEBREW MARK UPPER DOT
     (16#00610#, 16#00615#),  -- ARABIC SIGN SALLALLAHOU ALAYHE WASSALLAM .. ARABIC SMALL HIGH TAH
     (16#0064B#, 16#00658#),  -- ARABIC FATHATAN .. ARABIC MARK NOON GHUNNA
     (16#00670#, 16#00670#),  -- ARABIC LETTER SUPERSCRIPT ALEF .. ARABIC LETTER SUPERSCRIPT ALEF
     (16#006D6#, 16#006DC#),  -- ARABIC SMALL HIGH LIGATURE SAD WITH LAM WITH ALEF MAKSURA .. ARABIC SMALL HIGH SEEN
     (16#006DF#, 16#006E4#),  -- ARABIC SMALL HIGH ROUNDED ZERO .. ARABIC SMALL HIGH MADDA
     (16#006E7#, 16#006E8#),  -- ARABIC SMALL HIGH YEH .. ARABIC SMALL HIGH NOON
     (16#006EA#, 16#006ED#),  -- ARABIC EMPTY CENTRE LOW STOP .. ARABIC SMALL LOW MEEM
     (16#00711#, 16#00711#),  -- SYRIAC LETTER SUPERSCRIPT ALAPH .. SYRIAC LETTER SUPERSCRIPT ALAPH
     (16#00730#, 16#0074A#),  -- SYRIAC PTHAHA ABOVE .. SYRIAC BARREKH
     (16#007A6#, 16#007B0#),  -- THAANA ABAFILI .. THAANA SUKUN
     (16#00901#, 16#00903#),  -- DEVANAGARI SIGN CANDRABINDU .. DEVANAGARI SIGN VISARGA
     (16#0093C#, 16#0093C#),  -- DEVANAGARI SIGN NUKTA .. DEVANAGARI SIGN NUKTA
     (16#0093E#, 16#0094D#),  -- DEVANAGARI VOWEL SIGN AA .. DEVANAGARI SIGN VIRAMA
     (16#00951#, 16#00954#),  -- DEVANAGARI STRESS SIGN UDATTA .. DEVANAGARI ACUTE ACCENT
     (16#00962#, 16#00963#),  -- DEVANAGARI VOWEL SIGN VOCALIC L .. DEVANAGARI VOWEL SIGN VOCALIC LL
     (16#00981#, 16#00983#),  -- BENGALI SIGN CANDRABINDU .. BENGALI SIGN VISARGA
     (16#009BC#, 16#009BC#),  -- BENGALI SIGN NUKTA .. BENGALI SIGN NUKTA
     (16#009BE#, 16#009C4#),  -- BENGALI VOWEL SIGN AA .. BENGALI VOWEL SIGN VOCALIC RR
     (16#009C7#, 16#009C8#),  -- BENGALI VOWEL SIGN E .. BENGALI VOWEL SIGN AI
     (16#009CB#, 16#009CD#),  -- BENGALI VOWEL SIGN O .. BENGALI SIGN VIRAMA
     (16#009D7#, 16#009D7#),  -- BENGALI AU LENGTH MARK .. BENGALI AU LENGTH MARK
     (16#009E2#, 16#009E3#),  -- BENGALI VOWEL SIGN VOCALIC L .. BENGALI VOWEL SIGN VOCALIC LL
     (16#00A01#, 16#00A03#),  -- GURMUKHI SIGN ADAK BINDI .. GURMUKHI SIGN VISARGA
     (16#00A3C#, 16#00A3C#),  -- GURMUKHI SIGN NUKTA .. GURMUKHI SIGN NUKTA
     (16#00A3E#, 16#00A42#),  -- GURMUKHI VOWEL SIGN AA .. GURMUKHI VOWEL SIGN UU
     (16#00A47#, 16#00A48#),  -- GURMUKHI VOWEL SIGN EE .. GURMUKHI VOWEL SIGN AI
     (16#00A4B#, 16#00A4D#),  -- GURMUKHI VOWEL SIGN OO .. GURMUKHI SIGN VIRAMA
     (16#00A70#, 16#00A71#),  -- GURMUKHI TIPPI .. GURMUKHI ADDAK
     (16#00A81#, 16#00A83#),  -- GUJARATI SIGN CANDRABINDU .. GUJARATI SIGN VISARGA
     (16#00ABC#, 16#00ABC#),  -- GUJARATI SIGN NUKTA .. GUJARATI SIGN NUKTA
     (16#00ABE#, 16#00AC5#),  -- GUJARATI VOWEL SIGN AA .. GUJARATI VOWEL SIGN CANDRA E
     (16#00AC7#, 16#00AC9#),  -- GUJARATI VOWEL SIGN E .. GUJARATI VOWEL SIGN CANDRA O
     (16#00ACB#, 16#00ACD#),  -- GUJARATI VOWEL SIGN O .. GUJARATI SIGN VIRAMA
     (16#00AE2#, 16#00AE3#),  -- GUJARATI VOWEL SIGN VOCALIC L .. GUJARATI VOWEL SIGN VOCALIC LL
     (16#00B01#, 16#00B03#),  -- ORIYA SIGN CANDRABINDU .. ORIYA SIGN VISARGA
     (16#00B3C#, 16#00B3C#),  -- ORIYA SIGN NUKTA .. ORIYA SIGN NUKTA
     (16#00B3E#, 16#00B43#),  -- ORIYA VOWEL SIGN AA .. ORIYA VOWEL SIGN VOCALIC R
     (16#00B47#, 16#00B48#),  -- ORIYA VOWEL SIGN E .. ORIYA VOWEL SIGN AI
     (16#00B4B#, 16#00B4D#),  -- ORIYA VOWEL SIGN O .. ORIYA SIGN VIRAMA
     (16#00B56#, 16#00B57#),  -- ORIYA AI LENGTH MARK .. ORIYA AU LENGTH MARK
     (16#00B82#, 16#00B82#),  -- TAMIL SIGN ANUSVARA .. TAMIL SIGN ANUSVARA
     (16#00BBE#, 16#00BC2#),  -- TAMIL VOWEL SIGN AA .. TAMIL VOWEL SIGN UU
     (16#00BC6#, 16#00BC8#),  -- TAMIL VOWEL SIGN E .. TAMIL VOWEL SIGN AI
     (16#00BCA#, 16#00BCD#),  -- TAMIL VOWEL SIGN O .. TAMIL SIGN VIRAMA
     (16#00BD7#, 16#00BD7#),  -- TAMIL AU LENGTH MARK .. TAMIL AU LENGTH MARK
     (16#00C01#, 16#00C03#),  -- TELUGU SIGN CANDRABINDU .. TELUGU SIGN VISARGA
     (16#00C3E#, 16#00C44#),  -- TELUGU VOWEL SIGN AA .. TELUGU VOWEL SIGN VOCALIC RR
     (16#00C46#, 16#00C48#),  -- TELUGU VOWEL SIGN E .. TELUGU VOWEL SIGN AI
     (16#00C4A#, 16#00C4D#),  -- TELUGU VOWEL SIGN O .. TELUGU SIGN VIRAMA
     (16#00C55#, 16#00C56#),  -- TELUGU LENGTH MARK .. TELUGU AI LENGTH MARK
     (16#00C82#, 16#00C83#),  -- KANNADA SIGN ANUSVARA .. KANNADA SIGN VISARGA
     (16#00CBC#, 16#00CBC#),  -- KANNADA SIGN NUKTA .. KANNADA SIGN NUKTA
     (16#00CBE#, 16#00CC4#),  -- KANNADA VOWEL SIGN AA .. KANNADA VOWEL SIGN VOCALIC RR
     (16#00CC6#, 16#00CC8#),  -- KANNADA VOWEL SIGN E .. KANNADA VOWEL SIGN AI
     (16#00CCA#, 16#00CCD#),  -- KANNADA VOWEL SIGN O .. KANNADA SIGN VIRAMA
     (16#00CD5#, 16#00CD6#),  -- KANNADA LENGTH MARK .. KANNADA AI LENGTH MARK
     (16#00D02#, 16#00D03#),  -- MALAYALAM SIGN ANUSVARA .. MALAYALAM SIGN VISARGA
     (16#00D3E#, 16#00D43#),  -- MALAYALAM VOWEL SIGN AA .. MALAYALAM VOWEL SIGN VOCALIC R
     (16#00D46#, 16#00D48#),  -- MALAYALAM VOWEL SIGN E .. MALAYALAM VOWEL SIGN AI
     (16#00D4A#, 16#00D4D#),  -- MALAYALAM VOWEL SIGN O .. MALAYALAM SIGN VIRAMA
     (16#00D57#, 16#00D57#),  -- MALAYALAM AU LENGTH MARK .. MALAYALAM AU LENGTH MARK
     (16#00D82#, 16#00D83#),  -- SINHALA SIGN ANUSVARAYA .. SINHALA SIGN VISARGAYA
     (16#00DCA#, 16#00DCA#),  -- SINHALA SIGN AL-LAKUNA .. SINHALA SIGN AL-LAKUNA
     (16#00DCF#, 16#00DD4#),  -- SINHALA VOWEL SIGN AELA-PILLA .. SINHALA VOWEL SIGN KETTI PAA-PILLA
     (16#00DD6#, 16#00DD6#),  -- SINHALA VOWEL SIGN DIGA PAA-PILLA .. SINHALA VOWEL SIGN DIGA PAA-PILLA
     (16#00DD8#, 16#00DDF#),  -- SINHALA VOWEL SIGN GAETTA-PILLA .. SINHALA VOWEL SIGN GAYANUKITTA
     (16#00DF2#, 16#00DF3#),  -- SINHALA VOWEL SIGN DIGA GAETTA-PILLA .. SINHALA VOWEL SIGN DIGA GAYANUKITTA
     (16#00E31#, 16#00E31#),  -- THAI CHARACTER MAI HAN-AKAT .. THAI CHARACTER MAI HAN-AKAT
     (16#00E34#, 16#00E3A#),  -- THAI CHARACTER SARA I .. THAI CHARACTER PHINTHU
     (16#00E47#, 16#00E4E#),  -- THAI CHARACTER MAITAIKHU .. THAI CHARACTER YAMAKKAN
     (16#00EB1#, 16#00EB1#),  -- LAO VOWEL SIGN MAI KAN .. LAO VOWEL SIGN MAI KAN
     (16#00EB4#, 16#00EB9#),  -- LAO VOWEL SIGN I .. LAO VOWEL SIGN UU
     (16#00EBB#, 16#00EBC#),  -- LAO VOWEL SIGN MAI KON .. LAO SEMIVOWEL SIGN LO
     (16#00EC8#, 16#00ECD#),  -- LAO TONE MAI EK .. LAO NIGGAHITA
     (16#00F18#, 16#00F19#),  -- TIBETAN ASTROLOGICAL SIGN -KHYUD PA .. TIBETAN ASTROLOGICAL SIGN SDONG TSHUGS
     (16#00F35#, 16#00F35#),  -- TIBETAN MARK NGAS BZUNG NYI ZLA .. TIBETAN MARK NGAS BZUNG NYI ZLA
     (16#00F37#, 16#00F37#),  -- TIBETAN MARK NGAS BZUNG SGOR RTAGS .. TIBETAN MARK NGAS BZUNG SGOR RTAGS
     (16#00F39#, 16#00F39#),  -- TIBETAN MARK TSA -PHRU .. TIBETAN MARK TSA -PHRU
     (16#00F3E#, 16#00F3F#),  -- TIBETAN SIGN YAR TSHES .. TIBETAN SIGN MAR TSHES
     (16#00F71#, 16#00F84#),  -- TIBETAN VOWEL SIGN AA .. TIBETAN MARK HALANTA
     (16#00F86#, 16#00F87#),  -- TIBETAN SIGN LCI RTAGS .. TIBETAN SIGN YANG RTAGS
     (16#00F90#, 16#00F97#),  -- TIBETAN SUBJOINED LETTER KA .. TIBETAN SUBJOINED LETTER JA
     (16#00F99#, 16#00FBC#),  -- TIBETAN SUBJOINED LETTER NYA .. TIBETAN SUBJOINED LETTER FIXED-FORM RA
     (16#00FC6#, 16#00FC6#),  -- TIBETAN SYMBOL PADMA GDAN .. TIBETAN SYMBOL PADMA GDAN
     (16#0102C#, 16#01032#),  -- MYANMAR VOWEL SIGN AA .. MYANMAR VOWEL SIGN AI
     (16#01036#, 16#01039#),  -- MYANMAR SIGN ANUSVARA .. MYANMAR SIGN VIRAMA
     (16#01056#, 16#01059#),  -- MYANMAR VOWEL SIGN VOCALIC R .. MYANMAR VOWEL SIGN VOCALIC LL
     (16#01712#, 16#01714#),  -- TAGALOG VOWEL SIGN I .. TAGALOG SIGN VIRAMA
     (16#01732#, 16#01734#),  -- HANUNOO VOWEL SIGN I .. HANUNOO SIGN PAMUDPOD
     (16#01752#, 16#01753#),  -- BUHID VOWEL SIGN I .. BUHID VOWEL SIGN U
     (16#01772#, 16#01773#),  -- TAGBANWA VOWEL SIGN I .. TAGBANWA VOWEL SIGN U
     (16#017B6#, 16#017D3#),  -- KHMER VOWEL SIGN AA .. KHMER SIGN BATHAMASAT
     (16#017DD#, 16#017DD#),  -- KHMER SIGN ATTHACAN .. KHMER SIGN ATTHACAN
     (16#0180B#, 16#0180D#),  -- MONGOLIAN FREE VARIATION SELECTOR ONE .. MONGOLIAN FREE VARIATION SELECTOR THREE
     (16#018A9#, 16#018A9#),  -- MONGOLIAN LETTER ALI GALI DAGALGA .. MONGOLIAN LETTER ALI GALI DAGALGA
     (16#01920#, 16#0192B#),  -- LIMBU VOWEL SIGN A .. LIMBU SUBJOINED LETTER WA
     (16#01930#, 16#0193B#),  -- LIMBU SMALL LETTER KA .. LIMBU SIGN SA-I
     (16#020D0#, 16#020DC#),  -- COMBINING LEFT HARPOON ABOVE .. COMBINING FOUR DOTS ABOVE
     (16#020E1#, 16#020E1#),  -- COMBINING LEFT RIGHT ARROW ABOVE .. COMBINING LEFT RIGHT ARROW ABOVE
     (16#020E5#, 16#020EA#),  -- COMBINING REVERSE SOLIDUS OVERLAY .. COMBINING LEFTWARDS ARROW OVERLAY
     (16#0302A#, 16#0302F#),  -- IDEOGRAPHIC LEVEL TONE MARK .. HANGUL DOUBLE DOT TONE MARK
     (16#03099#, 16#0309A#),  -- COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK .. COMBINING KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK
     (16#0FB1E#, 16#0FB1E#),  -- HEBREW POINT JUDEO-SPANISH VARIKA .. HEBREW POINT JUDEO-SPANISH VARIKA
     (16#0FE00#, 16#0FE0F#),  -- VARIATION SELECTOR-1 .. VARIATION SELECTOR-16
     (16#0FE20#, 16#0FE23#),  -- COMBINING LIGATURE LEFT HALF .. COMBINING DOUBLE TILDE RIGHT HALF
     (16#1D165#, 16#1D169#),  -- MUSICAL SYMBOL COMBINING STEM .. MUSICAL SYMBOL COMBINING TREMOLO-3
     (16#1D16D#, 16#1D172#),  -- MUSICAL SYMBOL COMBINING AUGMENTATION DOT .. MUSICAL SYMBOL COMBINING FLAG-5
     (16#1D17B#, 16#1D182#),  -- MUSICAL SYMBOL COMBINING ACCENT .. MUSICAL SYMBOL COMBINING LOURE
     (16#1D185#, 16#1D18B#),  -- MUSICAL SYMBOL COMBINING DOIT .. MUSICAL SYMBOL COMBINING TRIPLE TONGUE
     (16#1D1AA#, 16#1D1AD#),  -- MUSICAL SYMBOL COMBINING DOWN BOW .. MUSICAL SYMBOL COMBINING SNAP PIZZICATO
     (16#E0100#, 16#E01EF#)); -- VARIATION SELECTOR-17 .. VARIATION SELECTOR-256

   --  The following table includes all characters considered non-graphic,
   --  i.e. all characters from the Unicode table with categories:

   --    Other, Control (Cc)
   --    Other, Private Use (Co)
   --    Other, Surrogate (Cs)
   --    Other, Format (Cf)
   --    Separator, Line (Zl)
   --    Separator, Paragraph (Zp)

   --  In addition, the characters FFFE and FFFF are excluded. Note that the
   --  defined Ada category of format effector is subsumed by the above set
   --  of Unicode categories.

   UTF_32_Non_Graphic : constant UTF_32_Ranges := (
     (16#00000#, 16#0001F#),  -- <control> .. <control>
     (16#0007F#, 16#0009F#),  -- <control> .. <control>
     (16#000AD#, 16#000AD#),  -- SOFT HYPHEN .. SOFT HYPHEN
     (16#00600#, 16#00603#),  -- ARABIC NUMBER SIGN .. ARABIC SIGN SAFHA
     (16#006DD#, 16#006DD#),  -- ARABIC END OF AYAH .. ARABIC END OF AYAH
     (16#0070F#, 16#0070F#),  -- SYRIAC ABBREVIATION MARK .. SYRIAC ABBREVIATION MARK
     (16#017B4#, 16#017B5#),  -- KHMER VOWEL INHERENT AQ .. KHMER VOWEL INHERENT AA
     (16#0200C#, 16#0200F#),  -- ZERO WIDTH NON-JOINER .. RIGHT-TO-LEFT MARK
     (16#02028#, 16#0202E#),  -- LINE SEPARATOR .. RIGHT-TO-LEFT OVERRIDE
     (16#02060#, 16#02063#),  -- WORD JOINER .. INVISIBLE SEPARATOR
     (16#0206A#, 16#0206F#),  -- INHIBIT SYMMETRIC SWAPPING .. NOMINAL DIGIT SHAPES
     (16#0D800#, 16#0F8FF#),  -- <Non Private Use High Surrogate, First> .. <Private Use, Last>
     (16#0FEFF#, 16#0FEFF#),  -- ZERO WIDTH NO-BREAK SPACE .. ZERO WIDTH NO-BREAK SPACE
     (16#0FFF9#, 16#0FFFB#),  -- INTERLINEAR ANNOTATION ANCHOR .. INTERLINEAR ANNOTATION TERMINATOR
     (16#0FFFE#, 16#0FFFF#),  -- excluded code positions
     (16#1D173#, 16#1D17A#),  -- MUSICAL SYMBOL BEGIN BEAM .. MUSICAL SYMBOL END PHRASE
     (16#E0001#, 16#E0001#),  -- LANGUAGE TAG .. LANGUAGE TAG
     (16#E0020#, 16#E007F#),  -- TAG SPACE .. CANCEL TAG
     (16#F0000#, 16#FFFFD#),  -- <Plane 15 Private Use, First> .. <Plane 15 Private Use, Last>
     (16#100000#, 16#10FFFD#)); -- <Plane 16 Private Use, First> .. <Plane 16 Private Use, Last>

   --  The following two tables define the mapping to upper case. The first
   --  table gives the ranges of lower case letters. The corresponding entry
   --  in Uppercase_Adjust shows the amount to be added (or subtracted) from
   --  the code value to get the corresponding upper case letter.

   --  Note that this folding is not reversible, for example lower case
   --  dotless i folds to normal upper case I, and that cannot be reversed.

   Lower_Case_Letters : constant UTF_32_Ranges := (
     (16#00061#, 16#0007A#),  -- LATIN SMALL LETTER A .. LATIN SMALL LETTER Z
     (16#000B5#, 16#000B5#),  -- MICRO SIGN .. MICRO SIGN
     (16#000E0#, 16#000F6#),  -- LATIN SMALL LETTER A WITH GRAVE .. LATIN SMALL LETTER O WITH DIAERESIS
     (16#000F8#, 16#000FE#),  -- LATIN SMALL LETTER O WITH STROKE .. LATIN SMALL LETTER THORN
     (16#000FF#, 16#000FF#),  -- LATIN SMALL LETTER Y WITH DIAERESIS .. LATIN SMALL LETTER Y WITH DIAERESIS
     (16#00101#, 16#00101#),  -- LATIN SMALL LETTER A WITH MACRON .. LATIN SMALL LETTER A WITH MACRON
     (16#00103#, 16#00103#),  -- LATIN SMALL LETTER A WITH BREVE .. LATIN SMALL LETTER A WITH BREVE
     (16#00105#, 16#00105#),  -- LATIN SMALL LETTER A WITH OGONEK .. LATIN SMALL LETTER A WITH OGONEK
     (16#00107#, 16#00107#),  -- LATIN SMALL LETTER C WITH ACUTE .. LATIN SMALL LETTER C WITH ACUTE
     (16#00109#, 16#00109#),  -- LATIN SMALL LETTER C WITH CIRCUMFLEX .. LATIN SMALL LETTER C WITH CIRCUMFLEX
     (16#0010B#, 16#0010B#),  -- LATIN SMALL LETTER C WITH DOT ABOVE .. LATIN SMALL LETTER C WITH DOT ABOVE
     (16#0010D#, 16#0010D#),  -- LATIN SMALL LETTER C WITH CARON .. LATIN SMALL LETTER C WITH CARON
     (16#0010F#, 16#0010F#),  -- LATIN SMALL LETTER D WITH CARON .. LATIN SMALL LETTER D WITH CARON
     (16#00111#, 16#00111#),  -- LATIN SMALL LETTER D WITH STROKE .. LATIN SMALL LETTER D WITH STROKE
     (16#00113#, 16#00113#),  -- LATIN SMALL LETTER E WITH MACRON .. LATIN SMALL LETTER E WITH MACRON
     (16#00115#, 16#00115#),  -- LATIN SMALL LETTER E WITH BREVE .. LATIN SMALL LETTER E WITH BREVE
     (16#00117#, 16#00117#),  -- LATIN SMALL LETTER E WITH DOT ABOVE .. LATIN SMALL LETTER E WITH DOT ABOVE
     (16#00119#, 16#00119#),  -- LATIN SMALL LETTER E WITH OGONEK .. LATIN SMALL LETTER E WITH OGONEK
     (16#0011B#, 16#0011B#),  -- LATIN SMALL LETTER E WITH CARON .. LATIN SMALL LETTER E WITH CARON
     (16#0011D#, 16#0011D#),  -- LATIN SMALL LETTER G WITH CIRCUMFLEX .. LATIN SMALL LETTER G WITH CIRCUMFLEX
     (16#0011F#, 16#0011F#),  -- LATIN SMALL LETTER G WITH BREVE .. LATIN SMALL LETTER G WITH BREVE
     (16#00121#, 16#00121#),  -- LATIN SMALL LETTER G WITH DOT ABOVE .. LATIN SMALL LETTER G WITH DOT ABOVE
     (16#00123#, 16#00123#),  -- LATIN SMALL LETTER G WITH CEDILLA .. LATIN SMALL LETTER G WITH CEDILLA
     (16#00125#, 16#00125#),  -- LATIN SMALL LETTER H WITH CIRCUMFLEX .. LATIN SMALL LETTER H WITH CIRCUMFLEX
     (16#00127#, 16#00127#),  -- LATIN SMALL LETTER H WITH STROKE .. LATIN SMALL LETTER H WITH STROKE
     (16#00129#, 16#00129#),  -- LATIN SMALL LETTER I WITH TILDE .. LATIN SMALL LETTER I WITH TILDE
     (16#0012B#, 16#0012B#),  -- LATIN SMALL LETTER I WITH MACRON .. LATIN SMALL LETTER I WITH MACRON
     (16#0012D#, 16#0012D#),  -- LATIN SMALL LETTER I WITH BREVE .. LATIN SMALL LETTER I WITH BREVE
     (16#0012F#, 16#0012F#),  -- LATIN SMALL LETTER I WITH OGONEK .. LATIN SMALL LETTER I WITH OGONEK
     (16#00131#, 16#00131#),  -- LATIN SMALL LETTER DOTLESS I .. LATIN SMALL LETTER DOTLESS I
     (16#00133#, 16#00133#),  -- LATIN SMALL LIGATURE IJ .. LATIN SMALL LIGATURE IJ
     (16#00135#, 16#00135#),  -- LATIN SMALL LETTER J WITH CIRCUMFLEX .. LATIN SMALL LETTER J WITH CIRCUMFLEX
     (16#00137#, 16#00137#),  -- LATIN SMALL LETTER K WITH CEDILLA .. LATIN SMALL LETTER K WITH CEDILLA
     (16#0013A#, 16#0013A#),  -- LATIN SMALL LETTER L WITH ACUTE .. LATIN SMALL LETTER L WITH ACUTE
     (16#0013C#, 16#0013C#),  -- LATIN SMALL LETTER L WITH CEDILLA .. LATIN SMALL LETTER L WITH CEDILLA
     (16#0013E#, 16#0013E#),  -- LATIN SMALL LETTER L WITH CARON .. LATIN SMALL LETTER L WITH CARON
     (16#00140#, 16#00140#),  -- LATIN SMALL LETTER L WITH MIDDLE DOT .. LATIN SMALL LETTER L WITH MIDDLE DOT
     (16#00142#, 16#00142#),  -- LATIN SMALL LETTER L WITH STROKE .. LATIN SMALL LETTER L WITH STROKE
     (16#00144#, 16#00144#),  -- LATIN SMALL LETTER N WITH ACUTE .. LATIN SMALL LETTER N WITH ACUTE
     (16#00146#, 16#00146#),  -- LATIN SMALL LETTER N WITH CEDILLA .. LATIN SMALL LETTER N WITH CEDILLA
     (16#00148#, 16#00148#),  -- LATIN SMALL LETTER N WITH CARON .. LATIN SMALL LETTER N WITH CARON
     (16#0014B#, 16#0014B#),  -- LATIN SMALL LETTER ENG .. LATIN SMALL LETTER ENG
     (16#0014D#, 16#0014D#),  -- LATIN SMALL LETTER O WITH MACRON .. LATIN SMALL LETTER O WITH MACRON
     (16#0014F#, 16#0014F#),  -- LATIN SMALL LETTER O WITH BREVE .. LATIN SMALL LETTER O WITH BREVE
     (16#00151#, 16#00151#),  -- LATIN SMALL LETTER O WITH DOUBLE ACUTE .. LATIN SMALL LETTER O WITH DOUBLE ACUTE
     (16#00153#, 16#00153#),  -- LATIN SMALL LIGATURE OE .. LATIN SMALL LIGATURE OE
     (16#00155#, 16#00155#),  -- LATIN SMALL LETTER R WITH ACUTE .. LATIN SMALL LETTER R WITH ACUTE
     (16#00157#, 16#00157#),  -- LATIN SMALL LETTER R WITH CEDILLA .. LATIN SMALL LETTER R WITH CEDILLA
     (16#00159#, 16#00159#),  -- LATIN SMALL LETTER R WITH CARON .. LATIN SMALL LETTER R WITH CARON
     (16#0015B#, 16#0015B#),  -- LATIN SMALL LETTER S WITH ACUTE .. LATIN SMALL LETTER S WITH ACUTE
     (16#0015D#, 16#0015D#),  -- LATIN SMALL LETTER S WITH CIRCUMFLEX .. LATIN SMALL LETTER S WITH CIRCUMFLEX
     (16#0015F#, 16#0015F#),  -- LATIN SMALL LETTER S WITH CEDILLA .. LATIN SMALL LETTER S WITH CEDILLA
     (16#00161#, 16#00161#),  -- LATIN SMALL LETTER S WITH CARON .. LATIN SMALL LETTER S WITH CARON
     (16#00163#, 16#00163#),  -- LATIN SMALL LETTER T WITH CEDILLA .. LATIN SMALL LETTER T WITH CEDILLA
     (16#00165#, 16#00165#),  -- LATIN SMALL LETTER T WITH CARON .. LATIN SMALL LETTER T WITH CARON
     (16#00167#, 16#00167#),  -- LATIN SMALL LETTER T WITH STROKE .. LATIN SMALL LETTER T WITH STROKE
     (16#00169#, 16#00169#),  -- LATIN SMALL LETTER U WITH TILDE .. LATIN SMALL LETTER U WITH TILDE
     (16#0016B#, 16#0016B#),  -- LATIN SMALL LETTER U WITH MACRON .. LATIN SMALL LETTER U WITH MACRON
     (16#0016D#, 16#0016D#),  -- LATIN SMALL LETTER U WITH BREVE .. LATIN SMALL LETTER U WITH BREVE
     (16#0016F#, 16#0016F#),  -- LATIN SMALL LETTER U WITH RING ABOVE .. LATIN SMALL LETTER U WITH RING ABOVE
     (16#00171#, 16#00171#),  -- LATIN SMALL LETTER U WITH DOUBLE ACUTE .. LATIN SMALL LETTER U WITH DOUBLE ACUTE
     (16#00173#, 16#00173#),  -- LATIN SMALL LETTER U WITH OGONEK .. LATIN SMALL LETTER U WITH OGONEK
     (16#00175#, 16#00175#),  -- LATIN SMALL LETTER W WITH CIRCUMFLEX .. LATIN SMALL LETTER W WITH CIRCUMFLEX
     (16#00177#, 16#00177#),  -- LATIN SMALL LETTER Y WITH CIRCUMFLEX .. LATIN SMALL LETTER Y WITH CIRCUMFLEX
     (16#0017A#, 16#0017A#),  -- LATIN SMALL LETTER Z WITH ACUTE .. LATIN SMALL LETTER Z WITH ACUTE
     (16#0017C#, 16#0017C#),  -- LATIN SMALL LETTER Z WITH DOT ABOVE .. LATIN SMALL LETTER Z WITH DOT ABOVE
     (16#0017E#, 16#0017E#),  -- LATIN SMALL LETTER Z WITH CARON .. LATIN SMALL LETTER Z WITH CARON
     (16#0017F#, 16#0017F#),  -- LATIN SMALL LETTER LONG S .. LATIN SMALL LETTER LONG S
     (16#00183#, 16#00183#),  -- LATIN SMALL LETTER B WITH TOPBAR .. LATIN SMALL LETTER B WITH TOPBAR
     (16#00185#, 16#00185#),  -- LATIN SMALL LETTER TONE SIX .. LATIN SMALL LETTER TONE SIX
     (16#00188#, 16#00188#),  -- LATIN SMALL LETTER C WITH HOOK .. LATIN SMALL LETTER C WITH HOOK
     (16#0018C#, 16#0018C#),  -- LATIN SMALL LETTER D WITH TOPBAR .. LATIN SMALL LETTER D WITH TOPBAR
     (16#00192#, 16#00192#),  -- LATIN SMALL LETTER F WITH HOOK .. LATIN SMALL LETTER F WITH HOOK
     (16#00195#, 16#00195#),  -- LATIN SMALL LETTER HV .. LATIN SMALL LETTER HV
     (16#00199#, 16#00199#),  -- LATIN SMALL LETTER K WITH HOOK .. LATIN SMALL LETTER K WITH HOOK
     (16#0019E#, 16#0019E#),  -- LATIN SMALL LETTER N WITH LONG RIGHT LEG .. LATIN SMALL LETTER N WITH LONG RIGHT LEG
     (16#001A1#, 16#001A1#),  -- LATIN SMALL LETTER O WITH HORN .. LATIN SMALL LETTER O WITH HORN
     (16#001A3#, 16#001A3#),  -- LATIN SMALL LETTER OI .. LATIN SMALL LETTER OI
     (16#001A5#, 16#001A5#),  -- LATIN SMALL LETTER P WITH HOOK .. LATIN SMALL LETTER P WITH HOOK
     (16#001A8#, 16#001A8#),  -- LATIN SMALL LETTER TONE TWO .. LATIN SMALL LETTER TONE TWO
     (16#001AD#, 16#001AD#),  -- LATIN SMALL LETTER T WITH HOOK .. LATIN SMALL LETTER T WITH HOOK
     (16#001B0#, 16#001B0#),  -- LATIN SMALL LETTER U WITH HORN .. LATIN SMALL LETTER U WITH HORN
     (16#001B4#, 16#001B4#),  -- LATIN SMALL LETTER Y WITH HOOK .. LATIN SMALL LETTER Y WITH HOOK
     (16#001B6#, 16#001B6#),  -- LATIN SMALL LETTER Z WITH STROKE .. LATIN SMALL LETTER Z WITH STROKE
     (16#001B9#, 16#001B9#),  -- LATIN SMALL LETTER EZH REVERSED .. LATIN SMALL LETTER EZH REVERSED
     (16#001BD#, 16#001BD#),  -- LATIN SMALL LETTER TONE FIVE .. LATIN SMALL LETTER TONE FIVE
     (16#001BF#, 16#001BF#),  -- LATIN LETTER WYNN .. LATIN LETTER WYNN
     (16#001C5#, 16#001C5#),  -- LATIN CAPITAL LETTER D WITH SMALL LETTER Z WITH CARON .. LATIN CAPITAL LETTER D WITH SMALL LETTER Z WITH CARON
     (16#001C6#, 16#001C6#),  -- LATIN SMALL LETTER DZ WITH CARON .. LATIN SMALL LETTER DZ WITH CARON
     (16#001C8#, 16#001C8#),  -- LATIN CAPITAL LETTER L WITH SMALL LETTER J .. LATIN CAPITAL LETTER L WITH SMALL LETTER J
     (16#001C9#, 16#001C9#),  -- LATIN SMALL LETTER LJ .. LATIN SMALL LETTER LJ
     (16#001CB#, 16#001CB#),  -- LATIN CAPITAL LETTER N WITH SMALL LETTER J .. LATIN CAPITAL LETTER N WITH SMALL LETTER J
     (16#001CC#, 16#001CC#),  -- LATIN SMALL LETTER NJ .. LATIN SMALL LETTER NJ
     (16#001CE#, 16#001CE#),  -- LATIN SMALL LETTER A WITH CARON .. LATIN SMALL LETTER A WITH CARON
     (16#001D0#, 16#001D0#),  -- LATIN SMALL LETTER I WITH CARON .. LATIN SMALL LETTER I WITH CARON
     (16#001D2#, 16#001D2#),  -- LATIN SMALL LETTER O WITH CARON .. LATIN SMALL LETTER O WITH CARON
     (16#001D4#, 16#001D4#),  -- LATIN SMALL LETTER U WITH CARON .. LATIN SMALL LETTER U WITH CARON
     (16#001D6#, 16#001D6#),  -- LATIN SMALL LETTER U WITH DIAERESIS AND MACRON .. LATIN SMALL LETTER U WITH DIAERESIS AND MACRON
     (16#001D8#, 16#001D8#),  -- LATIN SMALL LETTER U WITH DIAERESIS AND ACUTE .. LATIN SMALL LETTER U WITH DIAERESIS AND ACUTE
     (16#001DA#, 16#001DA#),  -- LATIN SMALL LETTER U WITH DIAERESIS AND CARON .. LATIN SMALL LETTER U WITH DIAERESIS AND CARON
     (16#001DC#, 16#001DC#),  -- LATIN SMALL LETTER U WITH DIAERESIS AND GRAVE .. LATIN SMALL LETTER U WITH DIAERESIS AND GRAVE
     (16#001DD#, 16#001DD#),  -- LATIN SMALL LETTER TURNED E .. LATIN SMALL LETTER TURNED E
     (16#001DF#, 16#001DF#),  -- LATIN SMALL LETTER A WITH DIAERESIS AND MACRON .. LATIN SMALL LETTER A WITH DIAERESIS AND MACRON
     (16#001E1#, 16#001E1#),  -- LATIN SMALL LETTER A WITH DOT ABOVE AND MACRON .. LATIN SMALL LETTER A WITH DOT ABOVE AND MACRON
     (16#001E3#, 16#001E3#),  -- LATIN SMALL LETTER AE WITH MACRON .. LATIN SMALL LETTER AE WITH MACRON
     (16#001E5#, 16#001E5#),  -- LATIN SMALL LETTER G WITH STROKE .. LATIN SMALL LETTER G WITH STROKE
     (16#001E7#, 16#001E7#),  -- LATIN SMALL LETTER G WITH CARON .. LATIN SMALL LETTER G WITH CARON
     (16#001E9#, 16#001E9#),  -- LATIN SMALL LETTER K WITH CARON .. LATIN SMALL LETTER K WITH CARON
     (16#001EB#, 16#001EB#),  -- LATIN SMALL LETTER O WITH OGONEK .. LATIN SMALL LETTER O WITH OGONEK
     (16#001ED#, 16#001ED#),  -- LATIN SMALL LETTER O WITH OGONEK AND MACRON .. LATIN SMALL LETTER O WITH OGONEK AND MACRON
     (16#001EF#, 16#001EF#),  -- LATIN SMALL LETTER EZH WITH CARON .. LATIN SMALL LETTER EZH WITH CARON
     (16#001F2#, 16#001F2#),  -- LATIN CAPITAL LETTER D WITH SMALL LETTER Z .. LATIN CAPITAL LETTER D WITH SMALL LETTER Z
     (16#001F3#, 16#001F3#),  -- LATIN SMALL LETTER DZ .. LATIN SMALL LETTER DZ
     (16#001F5#, 16#001F5#),  -- LATIN SMALL LETTER G WITH ACUTE .. LATIN SMALL LETTER G WITH ACUTE
     (16#001F9#, 16#001F9#),  -- LATIN SMALL LETTER N WITH GRAVE .. LATIN SMALL LETTER N WITH GRAVE
     (16#001FB#, 16#001FB#),  -- LATIN SMALL LETTER A WITH RING ABOVE AND ACUTE .. LATIN SMALL LETTER A WITH RING ABOVE AND ACUTE
     (16#001FD#, 16#001FD#),  -- LATIN SMALL LETTER AE WITH ACUTE .. LATIN SMALL LETTER AE WITH ACUTE
     (16#001FF#, 16#001FF#),  -- LATIN SMALL LETTER O WITH STROKE AND ACUTE .. LATIN SMALL LETTER O WITH STROKE AND ACUTE
     (16#00201#, 16#00201#),  -- LATIN SMALL LETTER A WITH DOUBLE GRAVE .. LATIN SMALL LETTER A WITH DOUBLE GRAVE
     (16#00203#, 16#00203#),  -- LATIN SMALL LETTER A WITH INVERTED BREVE .. LATIN SMALL LETTER A WITH INVERTED BREVE
     (16#00205#, 16#00205#),  -- LATIN SMALL LETTER E WITH DOUBLE GRAVE .. LATIN SMALL LETTER E WITH DOUBLE GRAVE
     (16#00207#, 16#00207#),  -- LATIN SMALL LETTER E WITH INVERTED BREVE .. LATIN SMALL LETTER E WITH INVERTED BREVE
     (16#00209#, 16#00209#),  -- LATIN SMALL LETTER I WITH DOUBLE GRAVE .. LATIN SMALL LETTER I WITH DOUBLE GRAVE
     (16#0020B#, 16#0020B#),  -- LATIN SMALL LETTER I WITH INVERTED BREVE .. LATIN SMALL LETTER I WITH INVERTED BREVE
     (16#0020D#, 16#0020D#),  -- LATIN SMALL LETTER O WITH DOUBLE GRAVE .. LATIN SMALL LETTER O WITH DOUBLE GRAVE
     (16#0020F#, 16#0020F#),  -- LATIN SMALL LETTER O WITH INVERTED BREVE .. LATIN SMALL LETTER O WITH INVERTED BREVE
     (16#00211#, 16#00211#),  -- LATIN SMALL LETTER R WITH DOUBLE GRAVE .. LATIN SMALL LETTER R WITH DOUBLE GRAVE
     (16#00213#, 16#00213#),  -- LATIN SMALL LETTER R WITH INVERTED BREVE .. LATIN SMALL LETTER R WITH INVERTED BREVE
     (16#00215#, 16#00215#),  -- LATIN SMALL LETTER U WITH DOUBLE GRAVE .. LATIN SMALL LETTER U WITH DOUBLE GRAVE
     (16#00217#, 16#00217#),  -- LATIN SMALL LETTER U WITH INVERTED BREVE .. LATIN SMALL LETTER U WITH INVERTED BREVE
     (16#00219#, 16#00219#),  -- LATIN SMALL LETTER S WITH COMMA BELOW .. LATIN SMALL LETTER S WITH COMMA BELOW
     (16#0021B#, 16#0021B#),  -- LATIN SMALL LETTER T WITH COMMA BELOW .. LATIN SMALL LETTER T WITH COMMA BELOW
     (16#0021D#, 16#0021D#),  -- LATIN SMALL LETTER YOGH .. LATIN SMALL LETTER YOGH
     (16#0021F#, 16#0021F#),  -- LATIN SMALL LETTER H WITH CARON .. LATIN SMALL LETTER H WITH CARON
     (16#00223#, 16#00223#),  -- LATIN SMALL LETTER OU .. LATIN SMALL LETTER OU
     (16#00225#, 16#00225#),  -- LATIN SMALL LETTER Z WITH HOOK .. LATIN SMALL LETTER Z WITH HOOK
     (16#00227#, 16#00227#),  -- LATIN SMALL LETTER A WITH DOT ABOVE .. LATIN SMALL LETTER A WITH DOT ABOVE
     (16#00229#, 16#00229#),  -- LATIN SMALL LETTER E WITH CEDILLA .. LATIN SMALL LETTER E WITH CEDILLA
     (16#0022B#, 16#0022B#),  -- LATIN SMALL LETTER O WITH DIAERESIS AND MACRON .. LATIN SMALL LETTER O WITH DIAERESIS AND MACRON
     (16#0022D#, 16#0022D#),  -- LATIN SMALL LETTER O WITH TILDE AND MACRON .. LATIN SMALL LETTER O WITH TILDE AND MACRON
     (16#0022F#, 16#0022F#),  -- LATIN SMALL LETTER O WITH DOT ABOVE .. LATIN SMALL LETTER O WITH DOT ABOVE
     (16#00231#, 16#00231#),  -- LATIN SMALL LETTER O WITH DOT ABOVE AND MACRON .. LATIN SMALL LETTER O WITH DOT ABOVE AND MACRON
     (16#00233#, 16#00233#),  -- LATIN SMALL LETTER Y WITH MACRON .. LATIN SMALL LETTER Y WITH MACRON
     (16#00253#, 16#00253#),  -- LATIN SMALL LETTER B WITH HOOK .. LATIN SMALL LETTER B WITH HOOK
     (16#00254#, 16#00254#),  -- LATIN SMALL LETTER OPEN O .. LATIN SMALL LETTER OPEN O
     (16#00256#, 16#00257#),  -- LATIN SMALL LETTER D WITH TAIL .. LATIN SMALL LETTER D WITH HOOK
     (16#00259#, 16#00259#),  -- LATIN SMALL LETTER SCHWA .. LATIN SMALL LETTER SCHWA
     (16#0025B#, 16#0025B#),  -- LATIN SMALL LETTER OPEN E .. LATIN SMALL LETTER OPEN E
     (16#00260#, 16#00260#),  -- LATIN SMALL LETTER G WITH HOOK .. LATIN SMALL LETTER G WITH HOOK
     (16#00263#, 16#00263#),  -- LATIN SMALL LETTER GAMMA .. LATIN SMALL LETTER GAMMA
     (16#00268#, 16#00268#),  -- LATIN SMALL LETTER I WITH STROKE .. LATIN SMALL LETTER I WITH STROKE
     (16#00269#, 16#00269#),  -- LATIN SMALL LETTER IOTA .. LATIN SMALL LETTER IOTA
     (16#0026F#, 16#0026F#),  -- LATIN SMALL LETTER TURNED M .. LATIN SMALL LETTER TURNED M
     (16#00272#, 16#00272#),  -- LATIN SMALL LETTER N WITH LEFT HOOK .. LATIN SMALL LETTER N WITH LEFT HOOK
     (16#00275#, 16#00275#),  -- LATIN SMALL LETTER BARRED O .. LATIN SMALL LETTER BARRED O
     (16#00280#, 16#00280#),  -- LATIN LETTER SMALL CAPITAL R .. LATIN LETTER SMALL CAPITAL R
     (16#00283#, 16#00283#),  -- LATIN SMALL LETTER ESH .. LATIN SMALL LETTER ESH
     (16#00288#, 16#00288#),  -- LATIN SMALL LETTER T WITH RETROFLEX HOOK .. LATIN SMALL LETTER T WITH RETROFLEX HOOK
     (16#0028A#, 16#0028B#),  -- LATIN SMALL LETTER UPSILON .. LATIN SMALL LETTER V WITH HOOK
     (16#00292#, 16#00292#),  -- LATIN SMALL LETTER EZH .. LATIN SMALL LETTER EZH
     (16#003AC#, 16#003AC#),  -- GREEK SMALL LETTER ALPHA WITH TONOS .. GREEK SMALL LETTER ALPHA WITH TONOS
     (16#003AD#, 16#003AF#),  -- GREEK SMALL LETTER EPSILON WITH TONOS .. GREEK SMALL LETTER IOTA WITH TONOS
     (16#003B1#, 16#003C1#),  -- GREEK SMALL LETTER ALPHA .. GREEK SMALL LETTER RHO
     (16#003C2#, 16#003C2#),  -- GREEK SMALL LETTER FINAL SIGMA .. GREEK SMALL LETTER FINAL SIGMA
     (16#003C3#, 16#003CB#),  -- GREEK SMALL LETTER SIGMA .. GREEK SMALL LETTER UPSILON WITH DIALYTIKA
     (16#003CC#, 16#003CC#),  -- GREEK SMALL LETTER OMICRON WITH TONOS .. GREEK SMALL LETTER OMICRON WITH TONOS
     (16#003CD#, 16#003CE#),  -- GREEK SMALL LETTER UPSILON WITH TONOS .. GREEK SMALL LETTER OMEGA WITH TONOS
     (16#003D0#, 16#003D0#),  -- GREEK BETA SYMBOL .. GREEK BETA SYMBOL
     (16#003D1#, 16#003D1#),  -- GREEK THETA SYMBOL .. GREEK THETA SYMBOL
     (16#003D5#, 16#003D5#),  -- GREEK PHI SYMBOL .. GREEK PHI SYMBOL
     (16#003D6#, 16#003D6#),  -- GREEK PI SYMBOL .. GREEK PI SYMBOL
     (16#003D9#, 16#003D9#),  -- GREEK SMALL LETTER ARCHAIC KOPPA .. GREEK SMALL LETTER ARCHAIC KOPPA
     (16#003DB#, 16#003DB#),  -- GREEK SMALL LETTER STIGMA .. GREEK SMALL LETTER STIGMA
     (16#003DD#, 16#003DD#),  -- GREEK SMALL LETTER DIGAMMA .. GREEK SMALL LETTER DIGAMMA
     (16#003DF#, 16#003DF#),  -- GREEK SMALL LETTER KOPPA .. GREEK SMALL LETTER KOPPA
     (16#003E1#, 16#003E1#),  -- GREEK SMALL LETTER SAMPI .. GREEK SMALL LETTER SAMPI
     (16#003E3#, 16#003E3#),  -- COPTIC SMALL LETTER SHEI .. COPTIC SMALL LETTER SHEI
     (16#003E5#, 16#003E5#),  -- COPTIC SMALL LETTER FEI .. COPTIC SMALL LETTER FEI
     (16#003E7#, 16#003E7#),  -- COPTIC SMALL LETTER KHEI .. COPTIC SMALL LETTER KHEI
     (16#003E9#, 16#003E9#),  -- COPTIC SMALL LETTER HORI .. COPTIC SMALL LETTER HORI
     (16#003EB#, 16#003EB#),  -- COPTIC SMALL LETTER GANGIA .. COPTIC SMALL LETTER GANGIA
     (16#003ED#, 16#003ED#),  -- COPTIC SMALL LETTER SHIMA .. COPTIC SMALL LETTER SHIMA
     (16#003EF#, 16#003EF#),  -- COPTIC SMALL LETTER DEI .. COPTIC SMALL LETTER DEI
     (16#003F0#, 16#003F0#),  -- GREEK KAPPA SYMBOL .. GREEK KAPPA SYMBOL
     (16#003F1#, 16#003F1#),  -- GREEK RHO SYMBOL .. GREEK RHO SYMBOL
     (16#003F2#, 16#003F2#),  -- GREEK LUNATE SIGMA SYMBOL .. GREEK LUNATE SIGMA SYMBOL
     (16#003F5#, 16#003F5#),  -- GREEK LUNATE EPSILON SYMBOL .. GREEK LUNATE EPSILON SYMBOL
     (16#00430#, 16#0044F#),  -- CYRILLIC SMALL LETTER A .. CYRILLIC SMALL LETTER YA
     (16#00450#, 16#0045F#),  -- CYRILLIC SMALL LETTER IE WITH GRAVE .. CYRILLIC SMALL LETTER DZHE
     (16#00461#, 16#00461#),  -- CYRILLIC SMALL LETTER OMEGA .. CYRILLIC SMALL LETTER OMEGA
     (16#00463#, 16#00463#),  -- CYRILLIC SMALL LETTER YAT .. CYRILLIC SMALL LETTER YAT
     (16#00465#, 16#00465#),  -- CYRILLIC SMALL LETTER IOTIFIED E .. CYRILLIC SMALL LETTER IOTIFIED E
     (16#00467#, 16#00467#),  -- CYRILLIC SMALL LETTER LITTLE YUS .. CYRILLIC SMALL LETTER LITTLE YUS
     (16#00469#, 16#00469#),  -- CYRILLIC SMALL LETTER IOTIFIED LITTLE YUS .. CYRILLIC SMALL LETTER IOTIFIED LITTLE YUS
     (16#0046B#, 16#0046B#),  -- CYRILLIC SMALL LETTER BIG YUS .. CYRILLIC SMALL LETTER BIG YUS
     (16#0046D#, 16#0046D#),  -- CYRILLIC SMALL LETTER IOTIFIED BIG YUS .. CYRILLIC SMALL LETTER IOTIFIED BIG YUS
     (16#0046F#, 16#0046F#),  -- CYRILLIC SMALL LETTER KSI .. CYRILLIC SMALL LETTER KSI
     (16#00471#, 16#00471#),  -- CYRILLIC SMALL LETTER PSI .. CYRILLIC SMALL LETTER PSI
     (16#00473#, 16#00473#),  -- CYRILLIC SMALL LETTER FITA .. CYRILLIC SMALL LETTER FITA
     (16#00475#, 16#00475#),  -- CYRILLIC SMALL LETTER IZHITSA .. CYRILLIC SMALL LETTER IZHITSA
     (16#00477#, 16#00477#),  -- CYRILLIC SMALL LETTER IZHITSA WITH DOUBLE GRAVE ACCENT .. CYRILLIC SMALL LETTER IZHITSA WITH DOUBLE GRAVE ACCENT
     (16#00479#, 16#00479#),  -- CYRILLIC SMALL LETTER UK .. CYRILLIC SMALL LETTER UK
     (16#0047B#, 16#0047B#),  -- CYRILLIC SMALL LETTER ROUND OMEGA .. CYRILLIC SMALL LETTER ROUND OMEGA
     (16#0047D#, 16#0047D#),  -- CYRILLIC SMALL LETTER OMEGA WITH TITLO .. CYRILLIC SMALL LETTER OMEGA WITH TITLO
     (16#0047F#, 16#0047F#),  -- CYRILLIC SMALL LETTER OT .. CYRILLIC SMALL LETTER OT
     (16#00481#, 16#00481#),  -- CYRILLIC SMALL LETTER KOPPA .. CYRILLIC SMALL LETTER KOPPA
     (16#0048B#, 16#0048B#),  -- CYRILLIC SMALL LETTER SHORT I WITH TAIL .. CYRILLIC SMALL LETTER SHORT I WITH TAIL
     (16#0048D#, 16#0048D#),  -- CYRILLIC SMALL LETTER SEMISOFT SIGN .. CYRILLIC SMALL LETTER SEMISOFT SIGN
     (16#0048F#, 16#0048F#),  -- CYRILLIC SMALL LETTER ER WITH TICK .. CYRILLIC SMALL LETTER ER WITH TICK
     (16#00491#, 16#00491#),  -- CYRILLIC SMALL LETTER GHE WITH UPTURN .. CYRILLIC SMALL LETTER GHE WITH UPTURN
     (16#00493#, 16#00493#),  -- CYRILLIC SMALL LETTER GHE WITH STROKE .. CYRILLIC SMALL LETTER GHE WITH STROKE
     (16#00495#, 16#00495#),  -- CYRILLIC SMALL LETTER GHE WITH MIDDLE HOOK .. CYRILLIC SMALL LETTER GHE WITH MIDDLE HOOK
     (16#00497#, 16#00497#),  -- CYRILLIC SMALL LETTER ZHE WITH DESCENDER .. CYRILLIC SMALL LETTER ZHE WITH DESCENDER
     (16#00499#, 16#00499#),  -- CYRILLIC SMALL LETTER ZE WITH DESCENDER .. CYRILLIC SMALL LETTER ZE WITH DESCENDER
     (16#0049B#, 16#0049B#),  -- CYRILLIC SMALL LETTER KA WITH DESCENDER .. CYRILLIC SMALL LETTER KA WITH DESCENDER
     (16#0049D#, 16#0049D#),  -- CYRILLIC SMALL LETTER KA WITH VERTICAL STROKE .. CYRILLIC SMALL LETTER KA WITH VERTICAL STROKE
     (16#0049F#, 16#0049F#),  -- CYRILLIC SMALL LETTER KA WITH STROKE .. CYRILLIC SMALL LETTER KA WITH STROKE
     (16#004A1#, 16#004A1#),  -- CYRILLIC SMALL LETTER BASHKIR KA .. CYRILLIC SMALL LETTER BASHKIR KA
     (16#004A3#, 16#004A3#),  -- CYRILLIC SMALL LETTER EN WITH DESCENDER .. CYRILLIC SMALL LETTER EN WITH DESCENDER
     (16#004A5#, 16#004A5#),  -- CYRILLIC SMALL LIGATURE EN GHE .. CYRILLIC SMALL LIGATURE EN GHE
     (16#004A7#, 16#004A7#),  -- CYRILLIC SMALL LETTER PE WITH MIDDLE HOOK .. CYRILLIC SMALL LETTER PE WITH MIDDLE HOOK
     (16#004A9#, 16#004A9#),  -- CYRILLIC SMALL LETTER ABKHASIAN HA .. CYRILLIC SMALL LETTER ABKHASIAN HA
     (16#004AB#, 16#004AB#),  -- CYRILLIC SMALL LETTER ES WITH DESCENDER .. CYRILLIC SMALL LETTER ES WITH DESCENDER
     (16#004AD#, 16#004AD#),  -- CYRILLIC SMALL LETTER TE WITH DESCENDER .. CYRILLIC SMALL LETTER TE WITH DESCENDER
     (16#004AF#, 16#004AF#),  -- CYRILLIC SMALL LETTER STRAIGHT U .. CYRILLIC SMALL LETTER STRAIGHT U
     (16#004B1#, 16#004B1#),  -- CYRILLIC SMALL LETTER STRAIGHT U WITH STROKE .. CYRILLIC SMALL LETTER STRAIGHT U WITH STROKE
     (16#004B3#, 16#004B3#),  -- CYRILLIC SMALL LETTER HA WITH DESCENDER .. CYRILLIC SMALL LETTER HA WITH DESCENDER
     (16#004B5#, 16#004B5#),  -- CYRILLIC SMALL LIGATURE TE TSE .. CYRILLIC SMALL LIGATURE TE TSE
     (16#004B7#, 16#004B7#),  -- CYRILLIC SMALL LETTER CHE WITH DESCENDER .. CYRILLIC SMALL LETTER CHE WITH DESCENDER
     (16#004B9#, 16#004B9#),  -- CYRILLIC SMALL LETTER CHE WITH VERTICAL STROKE .. CYRILLIC SMALL LETTER CHE WITH VERTICAL STROKE
     (16#004BB#, 16#004BB#),  -- CYRILLIC SMALL LETTER SHHA .. CYRILLIC SMALL LETTER SHHA
     (16#004BD#, 16#004BD#),  -- CYRILLIC SMALL LETTER ABKHASIAN CHE .. CYRILLIC SMALL LETTER ABKHASIAN CHE
     (16#004BF#, 16#004BF#),  -- CYRILLIC SMALL LETTER ABKHASIAN CHE WITH DESCENDER .. CYRILLIC SMALL LETTER ABKHASIAN CHE WITH DESCENDER
     (16#004C2#, 16#004C2#),  -- CYRILLIC SMALL LETTER ZHE WITH BREVE .. CYRILLIC SMALL LETTER ZHE WITH BREVE
     (16#004C4#, 16#004C4#),  -- CYRILLIC SMALL LETTER KA WITH HOOK .. CYRILLIC SMALL LETTER KA WITH HOOK
     (16#004C6#, 16#004C6#),  -- CYRILLIC SMALL LETTER EL WITH TAIL .. CYRILLIC SMALL LETTER EL WITH TAIL
     (16#004C8#, 16#004C8#),  -- CYRILLIC SMALL LETTER EN WITH HOOK .. CYRILLIC SMALL LETTER EN WITH HOOK
     (16#004CA#, 16#004CA#),  -- CYRILLIC SMALL LETTER EN WITH TAIL .. CYRILLIC SMALL LETTER EN WITH TAIL
     (16#004CC#, 16#004CC#),  -- CYRILLIC SMALL LETTER KHAKASSIAN CHE .. CYRILLIC SMALL LETTER KHAKASSIAN CHE
     (16#004CE#, 16#004CE#),  -- CYRILLIC SMALL LETTER EM WITH TAIL .. CYRILLIC SMALL LETTER EM WITH TAIL
     (16#004D1#, 16#004D1#),  -- CYRILLIC SMALL LETTER A WITH BREVE .. CYRILLIC SMALL LETTER A WITH BREVE
     (16#004D3#, 16#004D3#),  -- CYRILLIC SMALL LETTER A WITH DIAERESIS .. CYRILLIC SMALL LETTER A WITH DIAERESIS
     (16#004D5#, 16#004D5#),  -- CYRILLIC SMALL LIGATURE A IE .. CYRILLIC SMALL LIGATURE A IE
     (16#004D7#, 16#004D7#),  -- CYRILLIC SMALL LETTER IE WITH BREVE .. CYRILLIC SMALL LETTER IE WITH BREVE
     (16#004D9#, 16#004D9#),  -- CYRILLIC SMALL LETTER SCHWA .. CYRILLIC SMALL LETTER SCHWA
     (16#004DB#, 16#004DB#),  -- CYRILLIC SMALL LETTER SCHWA WITH DIAERESIS .. CYRILLIC SMALL LETTER SCHWA WITH DIAERESIS
     (16#004DD#, 16#004DD#),  -- CYRILLIC SMALL LETTER ZHE WITH DIAERESIS .. CYRILLIC SMALL LETTER ZHE WITH DIAERESIS
     (16#004DF#, 16#004DF#),  -- CYRILLIC SMALL LETTER ZE WITH DIAERESIS .. CYRILLIC SMALL LETTER ZE WITH DIAERESIS
     (16#004E1#, 16#004E1#),  -- CYRILLIC SMALL LETTER ABKHASIAN DZE .. CYRILLIC SMALL LETTER ABKHASIAN DZE
     (16#004E3#, 16#004E3#),  -- CYRILLIC SMALL LETTER I WITH MACRON .. CYRILLIC SMALL LETTER I WITH MACRON
     (16#004E5#, 16#004E5#),  -- CYRILLIC SMALL LETTER I WITH DIAERESIS .. CYRILLIC SMALL LETTER I WITH DIAERESIS
     (16#004E7#, 16#004E7#),  -- CYRILLIC SMALL LETTER O WITH DIAERESIS .. CYRILLIC SMALL LETTER O WITH DIAERESIS
     (16#004E9#, 16#004E9#),  -- CYRILLIC SMALL LETTER BARRED O .. CYRILLIC SMALL LETTER BARRED O
     (16#004EB#, 16#004EB#),  -- CYRILLIC SMALL LETTER BARRED O WITH DIAERESIS .. CYRILLIC SMALL LETTER BARRED O WITH DIAERESIS
     (16#004ED#, 16#004ED#),  -- CYRILLIC SMALL LETTER E WITH DIAERESIS .. CYRILLIC SMALL LETTER E WITH DIAERESIS
     (16#004EF#, 16#004EF#),  -- CYRILLIC SMALL LETTER U WITH MACRON .. CYRILLIC SMALL LETTER U WITH MACRON
     (16#004F1#, 16#004F1#),  -- CYRILLIC SMALL LETTER U WITH DIAERESIS .. CYRILLIC SMALL LETTER U WITH DIAERESIS
     (16#004F3#, 16#004F3#),  -- CYRILLIC SMALL LETTER U WITH DOUBLE ACUTE .. CYRILLIC SMALL LETTER U WITH DOUBLE ACUTE
     (16#004F5#, 16#004F5#),  -- CYRILLIC SMALL LETTER CHE WITH DIAERESIS .. CYRILLIC SMALL LETTER CHE WITH DIAERESIS
     (16#004F9#, 16#004F9#),  -- CYRILLIC SMALL LETTER YERU WITH DIAERESIS .. CYRILLIC SMALL LETTER YERU WITH DIAERESIS
     (16#00501#, 16#00501#),  -- CYRILLIC SMALL LETTER KOMI DE .. CYRILLIC SMALL LETTER KOMI DE
     (16#00503#, 16#00503#),  -- CYRILLIC SMALL LETTER KOMI DJE .. CYRILLIC SMALL LETTER KOMI DJE
     (16#00505#, 16#00505#),  -- CYRILLIC SMALL LETTER KOMI ZJE .. CYRILLIC SMALL LETTER KOMI ZJE
     (16#00507#, 16#00507#),  -- CYRILLIC SMALL LETTER KOMI DZJE .. CYRILLIC SMALL LETTER KOMI DZJE
     (16#00509#, 16#00509#),  -- CYRILLIC SMALL LETTER KOMI LJE .. CYRILLIC SMALL LETTER KOMI LJE
     (16#0050B#, 16#0050B#),  -- CYRILLIC SMALL LETTER KOMI NJE .. CYRILLIC SMALL LETTER KOMI NJE
     (16#0050D#, 16#0050D#),  -- CYRILLIC SMALL LETTER KOMI SJE .. CYRILLIC SMALL LETTER KOMI SJE
     (16#0050F#, 16#0050F#),  -- CYRILLIC SMALL LETTER KOMI TJE .. CYRILLIC SMALL LETTER KOMI TJE
     (16#00561#, 16#00586#),  -- ARMENIAN SMALL LETTER AYB .. ARMENIAN SMALL LETTER FEH
     (16#01E01#, 16#01E01#),  -- LATIN SMALL LETTER A WITH RING BELOW .. LATIN SMALL LETTER A WITH RING BELOW
     (16#01E03#, 16#01E03#),  -- LATIN SMALL LETTER B WITH DOT ABOVE .. LATIN SMALL LETTER B WITH DOT ABOVE
     (16#01E05#, 16#01E05#),  -- LATIN SMALL LETTER B WITH DOT BELOW .. LATIN SMALL LETTER B WITH DOT BELOW
     (16#01E07#, 16#01E07#),  -- LATIN SMALL LETTER B WITH LINE BELOW .. LATIN SMALL LETTER B WITH LINE BELOW
     (16#01E09#, 16#01E09#),  -- LATIN SMALL LETTER C WITH CEDILLA AND ACUTE .. LATIN SMALL LETTER C WITH CEDILLA AND ACUTE
     (16#01E0B#, 16#01E0B#),  -- LATIN SMALL LETTER D WITH DOT ABOVE .. LATIN SMALL LETTER D WITH DOT ABOVE
     (16#01E0D#, 16#01E0D#),  -- LATIN SMALL LETTER D WITH DOT BELOW .. LATIN SMALL LETTER D WITH DOT BELOW
     (16#01E0F#, 16#01E0F#),  -- LATIN SMALL LETTER D WITH LINE BELOW .. LATIN SMALL LETTER D WITH LINE BELOW
     (16#01E11#, 16#01E11#),  -- LATIN SMALL LETTER D WITH CEDILLA .. LATIN SMALL LETTER D WITH CEDILLA
     (16#01E13#, 16#01E13#),  -- LATIN SMALL LETTER D WITH CIRCUMFLEX BELOW .. LATIN SMALL LETTER D WITH CIRCUMFLEX BELOW
     (16#01E15#, 16#01E15#),  -- LATIN SMALL LETTER E WITH MACRON AND GRAVE .. LATIN SMALL LETTER E WITH MACRON AND GRAVE
     (16#01E17#, 16#01E17#),  -- LATIN SMALL LETTER E WITH MACRON AND ACUTE .. LATIN SMALL LETTER E WITH MACRON AND ACUTE
     (16#01E19#, 16#01E19#),  -- LATIN SMALL LETTER E WITH CIRCUMFLEX BELOW .. LATIN SMALL LETTER E WITH CIRCUMFLEX BELOW
     (16#01E1B#, 16#01E1B#),  -- LATIN SMALL LETTER E WITH TILDE BELOW .. LATIN SMALL LETTER E WITH TILDE BELOW
     (16#01E1D#, 16#01E1D#),  -- LATIN SMALL LETTER E WITH CEDILLA AND BREVE .. LATIN SMALL LETTER E WITH CEDILLA AND BREVE
     (16#01E1F#, 16#01E1F#),  -- LATIN SMALL LETTER F WITH DOT ABOVE .. LATIN SMALL LETTER F WITH DOT ABOVE
     (16#01E21#, 16#01E21#),  -- LATIN SMALL LETTER G WITH MACRON .. LATIN SMALL LETTER G WITH MACRON
     (16#01E23#, 16#01E23#),  -- LATIN SMALL LETTER H WITH DOT ABOVE .. LATIN SMALL LETTER H WITH DOT ABOVE
     (16#01E25#, 16#01E25#),  -- LATIN SMALL LETTER H WITH DOT BELOW .. LATIN SMALL LETTER H WITH DOT BELOW
     (16#01E27#, 16#01E27#),  -- LATIN SMALL LETTER H WITH DIAERESIS .. LATIN SMALL LETTER H WITH DIAERESIS
     (16#01E29#, 16#01E29#),  -- LATIN SMALL LETTER H WITH CEDILLA .. LATIN SMALL LETTER H WITH CEDILLA
     (16#01E2B#, 16#01E2B#),  -- LATIN SMALL LETTER H WITH BREVE BELOW .. LATIN SMALL LETTER H WITH BREVE BELOW
     (16#01E2D#, 16#01E2D#),  -- LATIN SMALL LETTER I WITH TILDE BELOW .. LATIN SMALL LETTER I WITH TILDE BELOW
     (16#01E2F#, 16#01E2F#),  -- LATIN SMALL LETTER I WITH DIAERESIS AND ACUTE .. LATIN SMALL LETTER I WITH DIAERESIS AND ACUTE
     (16#01E31#, 16#01E31#),  -- LATIN SMALL LETTER K WITH ACUTE .. LATIN SMALL LETTER K WITH ACUTE
     (16#01E33#, 16#01E33#),  -- LATIN SMALL LETTER K WITH DOT BELOW .. LATIN SMALL LETTER K WITH DOT BELOW
     (16#01E35#, 16#01E35#),  -- LATIN SMALL LETTER K WITH LINE BELOW .. LATIN SMALL LETTER K WITH LINE BELOW
     (16#01E37#, 16#01E37#),  -- LATIN SMALL LETTER L WITH DOT BELOW .. LATIN SMALL LETTER L WITH DOT BELOW
     (16#01E39#, 16#01E39#),  -- LATIN SMALL LETTER L WITH DOT BELOW AND MACRON .. LATIN SMALL LETTER L WITH DOT BELOW AND MACRON
     (16#01E3B#, 16#01E3B#),  -- LATIN SMALL LETTER L WITH LINE BELOW .. LATIN SMALL LETTER L WITH LINE BELOW
     (16#01E3D#, 16#01E3D#),  -- LATIN SMALL LETTER L WITH CIRCUMFLEX BELOW .. LATIN SMALL LETTER L WITH CIRCUMFLEX BELOW
     (16#01E3F#, 16#01E3F#),  -- LATIN SMALL LETTER M WITH ACUTE .. LATIN SMALL LETTER M WITH ACUTE
     (16#01E41#, 16#01E41#),  -- LATIN SMALL LETTER M WITH DOT ABOVE .. LATIN SMALL LETTER M WITH DOT ABOVE
     (16#01E43#, 16#01E43#),  -- LATIN SMALL LETTER M WITH DOT BELOW .. LATIN SMALL LETTER M WITH DOT BELOW
     (16#01E45#, 16#01E45#),  -- LATIN SMALL LETTER N WITH DOT ABOVE .. LATIN SMALL LETTER N WITH DOT ABOVE
     (16#01E47#, 16#01E47#),  -- LATIN SMALL LETTER N WITH DOT BELOW .. LATIN SMALL LETTER N WITH DOT BELOW
     (16#01E49#, 16#01E49#),  -- LATIN SMALL LETTER N WITH LINE BELOW .. LATIN SMALL LETTER N WITH LINE BELOW
     (16#01E4B#, 16#01E4B#),  -- LATIN SMALL LETTER N WITH CIRCUMFLEX BELOW .. LATIN SMALL LETTER N WITH CIRCUMFLEX BELOW
     (16#01E4D#, 16#01E4D#),  -- LATIN SMALL LETTER O WITH TILDE AND ACUTE .. LATIN SMALL LETTER O WITH TILDE AND ACUTE
     (16#01E4F#, 16#01E4F#),  -- LATIN SMALL LETTER O WITH TILDE AND DIAERESIS .. LATIN SMALL LETTER O WITH TILDE AND DIAERESIS
     (16#01E51#, 16#01E51#),  -- LATIN SMALL LETTER O WITH MACRON AND GRAVE .. LATIN SMALL LETTER O WITH MACRON AND GRAVE
     (16#01E53#, 16#01E53#),  -- LATIN SMALL LETTER O WITH MACRON AND ACUTE .. LATIN SMALL LETTER O WITH MACRON AND ACUTE
     (16#01E55#, 16#01E55#),  -- LATIN SMALL LETTER P WITH ACUTE .. LATIN SMALL LETTER P WITH ACUTE
     (16#01E57#, 16#01E57#),  -- LATIN SMALL LETTER P WITH DOT ABOVE .. LATIN SMALL LETTER P WITH DOT ABOVE
     (16#01E59#, 16#01E59#),  -- LATIN SMALL LETTER R WITH DOT ABOVE .. LATIN SMALL LETTER R WITH DOT ABOVE
     (16#01E5B#, 16#01E5B#),  -- LATIN SMALL LETTER R WITH DOT BELOW .. LATIN SMALL LETTER R WITH DOT BELOW
     (16#01E5D#, 16#01E5D#),  -- LATIN SMALL LETTER R WITH DOT BELOW AND MACRON .. LATIN SMALL LETTER R WITH DOT BELOW AND MACRON
     (16#01E5F#, 16#01E5F#),  -- LATIN SMALL LETTER R WITH LINE BELOW .. LATIN SMALL LETTER R WITH LINE BELOW
     (16#01E61#, 16#01E61#),  -- LATIN SMALL LETTER S WITH DOT ABOVE .. LATIN SMALL LETTER S WITH DOT ABOVE
     (16#01E63#, 16#01E63#),  -- LATIN SMALL LETTER S WITH DOT BELOW .. LATIN SMALL LETTER S WITH DOT BELOW
     (16#01E65#, 16#01E65#),  -- LATIN SMALL LETTER S WITH ACUTE AND DOT ABOVE .. LATIN SMALL LETTER S WITH ACUTE AND DOT ABOVE
     (16#01E67#, 16#01E67#),  -- LATIN SMALL LETTER S WITH CARON AND DOT ABOVE .. LATIN SMALL LETTER S WITH CARON AND DOT ABOVE
     (16#01E69#, 16#01E69#),  -- LATIN SMALL LETTER S WITH DOT BELOW AND DOT ABOVE .. LATIN SMALL LETTER S WITH DOT BELOW AND DOT ABOVE
     (16#01E6B#, 16#01E6B#),  -- LATIN SMALL LETTER T WITH DOT ABOVE .. LATIN SMALL LETTER T WITH DOT ABOVE
     (16#01E6D#, 16#01E6D#),  -- LATIN SMALL LETTER T WITH DOT BELOW .. LATIN SMALL LETTER T WITH DOT BELOW
     (16#01E6F#, 16#01E6F#),  -- LATIN SMALL LETTER T WITH LINE BELOW .. LATIN SMALL LETTER T WITH LINE BELOW
     (16#01E71#, 16#01E71#),  -- LATIN SMALL LETTER T WITH CIRCUMFLEX BELOW .. LATIN SMALL LETTER T WITH CIRCUMFLEX BELOW
     (16#01E73#, 16#01E73#),  -- LATIN SMALL LETTER U WITH DIAERESIS BELOW .. LATIN SMALL LETTER U WITH DIAERESIS BELOW
     (16#01E75#, 16#01E75#),  -- LATIN SMALL LETTER U WITH TILDE BELOW .. LATIN SMALL LETTER U WITH TILDE BELOW
     (16#01E77#, 16#01E77#),  -- LATIN SMALL LETTER U WITH CIRCUMFLEX BELOW .. LATIN SMALL LETTER U WITH CIRCUMFLEX BELOW
     (16#01E79#, 16#01E79#),  -- LATIN SMALL LETTER U WITH TILDE AND ACUTE .. LATIN SMALL LETTER U WITH TILDE AND ACUTE
     (16#01E7B#, 16#01E7B#),  -- LATIN SMALL LETTER U WITH MACRON AND DIAERESIS .. LATIN SMALL LETTER U WITH MACRON AND DIAERESIS
     (16#01E7D#, 16#01E7D#),  -- LATIN SMALL LETTER V WITH TILDE .. LATIN SMALL LETTER V WITH TILDE
     (16#01E7F#, 16#01E7F#),  -- LATIN SMALL LETTER V WITH DOT BELOW .. LATIN SMALL LETTER V WITH DOT BELOW
     (16#01E81#, 16#01E81#),  -- LATIN SMALL LETTER W WITH GRAVE .. LATIN SMALL LETTER W WITH GRAVE
     (16#01E83#, 16#01E83#),  -- LATIN SMALL LETTER W WITH ACUTE .. LATIN SMALL LETTER W WITH ACUTE
     (16#01E85#, 16#01E85#),  -- LATIN SMALL LETTER W WITH DIAERESIS .. LATIN SMALL LETTER W WITH DIAERESIS
     (16#01E87#, 16#01E87#),  -- LATIN SMALL LETTER W WITH DOT ABOVE .. LATIN SMALL LETTER W WITH DOT ABOVE
     (16#01E89#, 16#01E89#),  -- LATIN SMALL LETTER W WITH DOT BELOW .. LATIN SMALL LETTER W WITH DOT BELOW
     (16#01E8B#, 16#01E8B#),  -- LATIN SMALL LETTER X WITH DOT ABOVE .. LATIN SMALL LETTER X WITH DOT ABOVE
     (16#01E8D#, 16#01E8D#),  -- LATIN SMALL LETTER X WITH DIAERESIS .. LATIN SMALL LETTER X WITH DIAERESIS
     (16#01E8F#, 16#01E8F#),  -- LATIN SMALL LETTER Y WITH DOT ABOVE .. LATIN SMALL LETTER Y WITH DOT ABOVE
     (16#01E91#, 16#01E91#),  -- LATIN SMALL LETTER Z WITH CIRCUMFLEX .. LATIN SMALL LETTER Z WITH CIRCUMFLEX
     (16#01E93#, 16#01E93#),  -- LATIN SMALL LETTER Z WITH DOT BELOW .. LATIN SMALL LETTER Z WITH DOT BELOW
     (16#01E95#, 16#01E95#),  -- LATIN SMALL LETTER Z WITH LINE BELOW .. LATIN SMALL LETTER Z WITH LINE BELOW
     (16#01E9B#, 16#01E9B#),  -- LATIN SMALL LETTER LONG S WITH DOT ABOVE .. LATIN SMALL LETTER LONG S WITH DOT ABOVE
     (16#01EA1#, 16#01EA1#),  -- LATIN SMALL LETTER A WITH DOT BELOW .. LATIN SMALL LETTER A WITH DOT BELOW
     (16#01EA3#, 16#01EA3#),  -- LATIN SMALL LETTER A WITH HOOK ABOVE .. LATIN SMALL LETTER A WITH HOOK ABOVE
     (16#01EA5#, 16#01EA5#),  -- LATIN SMALL LETTER A WITH CIRCUMFLEX AND ACUTE .. LATIN SMALL LETTER A WITH CIRCUMFLEX AND ACUTE
     (16#01EA7#, 16#01EA7#),  -- LATIN SMALL LETTER A WITH CIRCUMFLEX AND GRAVE .. LATIN SMALL LETTER A WITH CIRCUMFLEX AND GRAVE
     (16#01EA9#, 16#01EA9#),  -- LATIN SMALL LETTER A WITH CIRCUMFLEX AND HOOK ABOVE .. LATIN SMALL LETTER A WITH CIRCUMFLEX AND HOOK ABOVE
     (16#01EAB#, 16#01EAB#),  -- LATIN SMALL LETTER A WITH CIRCUMFLEX AND TILDE .. LATIN SMALL LETTER A WITH CIRCUMFLEX AND TILDE
     (16#01EAD#, 16#01EAD#),  -- LATIN SMALL LETTER A WITH CIRCUMFLEX AND DOT BELOW .. LATIN SMALL LETTER A WITH CIRCUMFLEX AND DOT BELOW
     (16#01EAF#, 16#01EAF#),  -- LATIN SMALL LETTER A WITH BREVE AND ACUTE .. LATIN SMALL LETTER A WITH BREVE AND ACUTE
     (16#01EB1#, 16#01EB1#),  -- LATIN SMALL LETTER A WITH BREVE AND GRAVE .. LATIN SMALL LETTER A WITH BREVE AND GRAVE
     (16#01EB3#, 16#01EB3#),  -- LATIN SMALL LETTER A WITH BREVE AND HOOK ABOVE .. LATIN SMALL LETTER A WITH BREVE AND HOOK ABOVE
     (16#01EB5#, 16#01EB5#),  -- LATIN SMALL LETTER A WITH BREVE AND TILDE .. LATIN SMALL LETTER A WITH BREVE AND TILDE
     (16#01EB7#, 16#01EB7#),  -- LATIN SMALL LETTER A WITH BREVE AND DOT BELOW .. LATIN SMALL LETTER A WITH BREVE AND DOT BELOW
     (16#01EB9#, 16#01EB9#),  -- LATIN SMALL LETTER E WITH DOT BELOW .. LATIN SMALL LETTER E WITH DOT BELOW
     (16#01EBB#, 16#01EBB#),  -- LATIN SMALL LETTER E WITH HOOK ABOVE .. LATIN SMALL LETTER E WITH HOOK ABOVE
     (16#01EBD#, 16#01EBD#),  -- LATIN SMALL LETTER E WITH TILDE .. LATIN SMALL LETTER E WITH TILDE
     (16#01EBF#, 16#01EBF#),  -- LATIN SMALL LETTER E WITH CIRCUMFLEX AND ACUTE .. LATIN SMALL LETTER E WITH CIRCUMFLEX AND ACUTE
     (16#01EC1#, 16#01EC1#),  -- LATIN SMALL LETTER E WITH CIRCUMFLEX AND GRAVE .. LATIN SMALL LETTER E WITH CIRCUMFLEX AND GRAVE
     (16#01EC3#, 16#01EC3#),  -- LATIN SMALL LETTER E WITH CIRCUMFLEX AND HOOK ABOVE .. LATIN SMALL LETTER E WITH CIRCUMFLEX AND HOOK ABOVE
     (16#01EC5#, 16#01EC5#),  -- LATIN SMALL LETTER E WITH CIRCUMFLEX AND TILDE .. LATIN SMALL LETTER E WITH CIRCUMFLEX AND TILDE
     (16#01EC7#, 16#01EC7#),  -- LATIN SMALL LETTER E WITH CIRCUMFLEX AND DOT BELOW .. LATIN SMALL LETTER E WITH CIRCUMFLEX AND DOT BELOW
     (16#01EC9#, 16#01EC9#),  -- LATIN SMALL LETTER I WITH HOOK ABOVE .. LATIN SMALL LETTER I WITH HOOK ABOVE
     (16#01ECB#, 16#01ECB#),  -- LATIN SMALL LETTER I WITH DOT BELOW .. LATIN SMALL LETTER I WITH DOT BELOW
     (16#01ECD#, 16#01ECD#),  -- LATIN SMALL LETTER O WITH DOT BELOW .. LATIN SMALL LETTER O WITH DOT BELOW
     (16#01ECF#, 16#01ECF#),  -- LATIN SMALL LETTER O WITH HOOK ABOVE .. LATIN SMALL LETTER O WITH HOOK ABOVE
     (16#01ED1#, 16#01ED1#),  -- LATIN SMALL LETTER O WITH CIRCUMFLEX AND ACUTE .. LATIN SMALL LETTER O WITH CIRCUMFLEX AND ACUTE
     (16#01ED3#, 16#01ED3#),  -- LATIN SMALL LETTER O WITH CIRCUMFLEX AND GRAVE .. LATIN SMALL LETTER O WITH CIRCUMFLEX AND GRAVE
     (16#01ED5#, 16#01ED5#),  -- LATIN SMALL LETTER O WITH CIRCUMFLEX AND HOOK ABOVE .. LATIN SMALL LETTER O WITH CIRCUMFLEX AND HOOK ABOVE
     (16#01ED7#, 16#01ED7#),  -- LATIN SMALL LETTER O WITH CIRCUMFLEX AND TILDE .. LATIN SMALL LETTER O WITH CIRCUMFLEX AND TILDE
     (16#01ED9#, 16#01ED9#),  -- LATIN SMALL LETTER O WITH CIRCUMFLEX AND DOT BELOW .. LATIN SMALL LETTER O WITH CIRCUMFLEX AND DOT BELOW
     (16#01EDB#, 16#01EDB#),  -- LATIN SMALL LETTER O WITH HORN AND ACUTE .. LATIN SMALL LETTER O WITH HORN AND ACUTE
     (16#01EDD#, 16#01EDD#),  -- LATIN SMALL LETTER O WITH HORN AND GRAVE .. LATIN SMALL LETTER O WITH HORN AND GRAVE
     (16#01EDF#, 16#01EDF#),  -- LATIN SMALL LETTER O WITH HORN AND HOOK ABOVE .. LATIN SMALL LETTER O WITH HORN AND HOOK ABOVE
     (16#01EE1#, 16#01EE1#),  -- LATIN SMALL LETTER O WITH HORN AND TILDE .. LATIN SMALL LETTER O WITH HORN AND TILDE
     (16#01EE3#, 16#01EE3#),  -- LATIN SMALL LETTER O WITH HORN AND DOT BELOW .. LATIN SMALL LETTER O WITH HORN AND DOT BELOW
     (16#01EE5#, 16#01EE5#),  -- LATIN SMALL LETTER U WITH DOT BELOW .. LATIN SMALL LETTER U WITH DOT BELOW
     (16#01EE7#, 16#01EE7#),  -- LATIN SMALL LETTER U WITH HOOK ABOVE .. LATIN SMALL LETTER U WITH HOOK ABOVE
     (16#01EE9#, 16#01EE9#),  -- LATIN SMALL LETTER U WITH HORN AND ACUTE .. LATIN SMALL LETTER U WITH HORN AND ACUTE
     (16#01EEB#, 16#01EEB#),  -- LATIN SMALL LETTER U WITH HORN AND GRAVE .. LATIN SMALL LETTER U WITH HORN AND GRAVE
     (16#01EED#, 16#01EED#),  -- LATIN SMALL LETTER U WITH HORN AND HOOK ABOVE .. LATIN SMALL LETTER U WITH HORN AND HOOK ABOVE
     (16#01EEF#, 16#01EEF#),  -- LATIN SMALL LETTER U WITH HORN AND TILDE .. LATIN SMALL LETTER U WITH HORN AND TILDE
     (16#01EF1#, 16#01EF1#),  -- LATIN SMALL LETTER U WITH HORN AND DOT BELOW .. LATIN SMALL LETTER U WITH HORN AND DOT BELOW
     (16#01EF3#, 16#01EF3#),  -- LATIN SMALL LETTER Y WITH GRAVE .. LATIN SMALL LETTER Y WITH GRAVE
     (16#01EF5#, 16#01EF5#),  -- LATIN SMALL LETTER Y WITH DOT BELOW .. LATIN SMALL LETTER Y WITH DOT BELOW
     (16#01EF7#, 16#01EF7#),  -- LATIN SMALL LETTER Y WITH HOOK ABOVE .. LATIN SMALL LETTER Y WITH HOOK ABOVE
     (16#01EF9#, 16#01EF9#),  -- LATIN SMALL LETTER Y WITH TILDE .. LATIN SMALL LETTER Y WITH TILDE
     (16#01F00#, 16#01F07#),  -- GREEK SMALL LETTER ALPHA WITH PSILI .. GREEK SMALL LETTER ALPHA WITH DASIA AND PERISPOMENI
     (16#01F10#, 16#01F15#),  -- GREEK SMALL LETTER EPSILON WITH PSILI .. GREEK SMALL LETTER EPSILON WITH DASIA AND OXIA
     (16#01F20#, 16#01F27#),  -- GREEK SMALL LETTER ETA WITH PSILI .. GREEK SMALL LETTER ETA WITH DASIA AND PERISPOMENI
     (16#01F30#, 16#01F37#),  -- GREEK SMALL LETTER IOTA WITH PSILI .. GREEK SMALL LETTER IOTA WITH DASIA AND PERISPOMENI
     (16#01F40#, 16#01F45#),  -- GREEK SMALL LETTER OMICRON WITH PSILI .. GREEK SMALL LETTER OMICRON WITH DASIA AND OXIA
     (16#01F51#, 16#01F51#),  -- GREEK SMALL LETTER UPSILON WITH DASIA .. GREEK SMALL LETTER UPSILON WITH DASIA
     (16#01F53#, 16#01F53#),  -- GREEK SMALL LETTER UPSILON WITH DASIA AND VARIA .. GREEK SMALL LETTER UPSILON WITH DASIA AND VARIA
     (16#01F55#, 16#01F55#),  -- GREEK SMALL LETTER UPSILON WITH DASIA AND OXIA .. GREEK SMALL LETTER UPSILON WITH DASIA AND OXIA
     (16#01F57#, 16#01F57#),  -- GREEK SMALL LETTER UPSILON WITH DASIA AND PERISPOMENI .. GREEK SMALL LETTER UPSILON WITH DASIA AND PERISPOMENI
     (16#01F60#, 16#01F67#),  -- GREEK SMALL LETTER OMEGA WITH PSILI .. GREEK SMALL LETTER OMEGA WITH DASIA AND PERISPOMENI
     (16#01F70#, 16#01F71#),  -- GREEK SMALL LETTER ALPHA WITH VARIA .. GREEK SMALL LETTER ALPHA WITH OXIA
     (16#01F72#, 16#01F75#),  -- GREEK SMALL LETTER EPSILON WITH VARIA .. GREEK SMALL LETTER ETA WITH OXIA
     (16#01F76#, 16#01F77#),  -- GREEK SMALL LETTER IOTA WITH VARIA .. GREEK SMALL LETTER IOTA WITH OXIA
     (16#01F78#, 16#01F79#),  -- GREEK SMALL LETTER OMICRON WITH VARIA .. GREEK SMALL LETTER OMICRON WITH OXIA
     (16#01F7A#, 16#01F7B#),  -- GREEK SMALL LETTER UPSILON WITH VARIA .. GREEK SMALL LETTER UPSILON WITH OXIA
     (16#01F7C#, 16#01F7D#),  -- GREEK SMALL LETTER OMEGA WITH VARIA .. GREEK SMALL LETTER OMEGA WITH OXIA
     (16#01F80#, 16#01F87#),  -- GREEK SMALL LETTER ALPHA WITH PSILI AND YPOGEGRAMMENI .. GREEK SMALL LETTER ALPHA WITH DASIA AND PERISPOMENI AND YPOGEGRAMMENI
     (16#01F90#, 16#01F97#),  -- GREEK SMALL LETTER ETA WITH PSILI AND YPOGEGRAMMENI .. GREEK SMALL LETTER ETA WITH DASIA AND PERISPOMENI AND YPOGEGRAMMENI
     (16#01FA0#, 16#01FA7#),  -- GREEK SMALL LETTER OMEGA WITH PSILI AND YPOGEGRAMMENI .. GREEK SMALL LETTER OMEGA WITH DASIA AND PERISPOMENI AND YPOGEGRAMMENI
     (16#01FB0#, 16#01FB1#),  -- GREEK SMALL LETTER ALPHA WITH VRACHY .. GREEK SMALL LETTER ALPHA WITH MACRON
     (16#01FB3#, 16#01FB3#),  -- GREEK SMALL LETTER ALPHA WITH YPOGEGRAMMENI .. GREEK SMALL LETTER ALPHA WITH YPOGEGRAMMENI
     (16#01FBE#, 16#01FBE#),  -- GREEK PROSGEGRAMMENI .. GREEK PROSGEGRAMMENI
     (16#01FC3#, 16#01FC3#),  -- GREEK SMALL LETTER ETA WITH YPOGEGRAMMENI .. GREEK SMALL LETTER ETA WITH YPOGEGRAMMENI
     (16#01FD0#, 16#01FD1#),  -- GREEK SMALL LETTER IOTA WITH VRACHY .. GREEK SMALL LETTER IOTA WITH MACRON
     (16#01FE0#, 16#01FE1#),  -- GREEK SMALL LETTER UPSILON WITH VRACHY .. GREEK SMALL LETTER UPSILON WITH MACRON
     (16#01FE5#, 16#01FE5#),  -- GREEK SMALL LETTER RHO WITH DASIA .. GREEK SMALL LETTER RHO WITH DASIA
     (16#01FF3#, 16#01FF3#),  -- GREEK SMALL LETTER OMEGA WITH YPOGEGRAMMENI .. GREEK SMALL LETTER OMEGA WITH YPOGEGRAMMENI
     (16#0FF41#, 16#0FF5A#),  -- FULLWIDTH LATIN SMALL LETTER A .. FULLWIDTH LATIN SMALL LETTER Z
     (16#10428#, 16#1044D#)); -- DESERET SMALL LETTER LONG I .. DESERET SMALL LETTER ENG

   Upper_Case_Adjust : constant array (Lower_Case_Letters'Range) of UTF_32 := (
       -32,  -- LATIN SMALL LETTER A .. LATIN SMALL LETTER Z
       743,  -- MICRO SIGN .. MICRO SIGN
       -32,  -- LATIN SMALL LETTER A WITH GRAVE .. LATIN SMALL LETTER O WITH DIAERESIS
       -32,  -- LATIN SMALL LETTER O WITH STROKE .. LATIN SMALL LETTER THORN
       121,  -- LATIN SMALL LETTER Y WITH DIAERESIS .. LATIN SMALL LETTER Y WITH DIAERESIS
        -1,  -- LATIN SMALL LETTER A WITH MACRON .. LATIN SMALL LETTER A WITH MACRON
        -1,  -- LATIN SMALL LETTER A WITH BREVE .. LATIN SMALL LETTER A WITH BREVE
        -1,  -- LATIN SMALL LETTER A WITH OGONEK .. LATIN SMALL LETTER A WITH OGONEK
        -1,  -- LATIN SMALL LETTER C WITH ACUTE .. LATIN SMALL LETTER C WITH ACUTE
        -1,  -- LATIN SMALL LETTER C WITH CIRCUMFLEX .. LATIN SMALL LETTER C WITH CIRCUMFLEX
        -1,  -- LATIN SMALL LETTER C WITH DOT ABOVE .. LATIN SMALL LETTER C WITH DOT ABOVE
        -1,  -- LATIN SMALL LETTER C WITH CARON .. LATIN SMALL LETTER C WITH CARON
        -1,  -- LATIN SMALL LETTER D WITH CARON .. LATIN SMALL LETTER D WITH CARON
        -1,  -- LATIN SMALL LETTER D WITH STROKE .. LATIN SMALL LETTER D WITH STROKE
        -1,  -- LATIN SMALL LETTER E WITH MACRON .. LATIN SMALL LETTER E WITH MACRON
        -1,  -- LATIN SMALL LETTER E WITH BREVE .. LATIN SMALL LETTER E WITH BREVE
        -1,  -- LATIN SMALL LETTER E WITH DOT ABOVE .. LATIN SMALL LETTER E WITH DOT ABOVE
        -1,  -- LATIN SMALL LETTER E WITH OGONEK .. LATIN SMALL LETTER E WITH OGONEK
        -1,  -- LATIN SMALL LETTER E WITH CARON .. LATIN SMALL LETTER E WITH CARON
        -1,  -- LATIN SMALL LETTER G WITH CIRCUMFLEX .. LATIN SMALL LETTER G WITH CIRCUMFLEX
        -1,  -- LATIN SMALL LETTER G WITH BREVE .. LATIN SMALL LETTER G WITH BREVE
        -1,  -- LATIN SMALL LETTER G WITH DOT ABOVE .. LATIN SMALL LETTER G WITH DOT ABOVE
        -1,  -- LATIN SMALL LETTER G WITH CEDILLA .. LATIN SMALL LETTER G WITH CEDILLA
        -1,  -- LATIN SMALL LETTER H WITH CIRCUMFLEX .. LATIN SMALL LETTER H WITH CIRCUMFLEX
        -1,  -- LATIN SMALL LETTER H WITH STROKE .. LATIN SMALL LETTER H WITH STROKE
        -1,  -- LATIN SMALL LETTER I WITH TILDE .. LATIN SMALL LETTER I WITH TILDE
        -1,  -- LATIN SMALL LETTER I WITH MACRON .. LATIN SMALL LETTER I WITH MACRON
        -1,  -- LATIN SMALL LETTER I WITH BREVE .. LATIN SMALL LETTER I WITH BREVE
        -1,  -- LATIN SMALL LETTER I WITH OGONEK .. LATIN SMALL LETTER I WITH OGONEK
      -232,  -- LATIN SMALL LETTER DOTLESS I .. LATIN SMALL LETTER DOTLESS I
        -1,  -- LATIN SMALL LIGATURE IJ .. LATIN SMALL LIGATURE IJ
        -1,  -- LATIN SMALL LETTER J WITH CIRCUMFLEX .. LATIN SMALL LETTER J WITH CIRCUMFLEX
        -1,  -- LATIN SMALL LETTER K WITH CEDILLA .. LATIN SMALL LETTER K WITH CEDILLA
        -1,  -- LATIN SMALL LETTER L WITH ACUTE .. LATIN SMALL LETTER L WITH ACUTE
        -1,  -- LATIN SMALL LETTER L WITH CEDILLA .. LATIN SMALL LETTER L WITH CEDILLA
        -1,  -- LATIN SMALL LETTER L WITH CARON .. LATIN SMALL LETTER L WITH CARON
        -1,  -- LATIN SMALL LETTER L WITH MIDDLE DOT .. LATIN SMALL LETTER L WITH MIDDLE DOT
        -1,  -- LATIN SMALL LETTER L WITH STROKE .. LATIN SMALL LETTER L WITH STROKE
        -1,  -- LATIN SMALL LETTER N WITH ACUTE .. LATIN SMALL LETTER N WITH ACUTE
        -1,  -- LATIN SMALL LETTER N WITH CEDILLA .. LATIN SMALL LETTER N WITH CEDILLA
        -1,  -- LATIN SMALL LETTER N WITH CARON .. LATIN SMALL LETTER N WITH CARON
        -1,  -- LATIN SMALL LETTER ENG .. LATIN SMALL LETTER ENG
        -1,  -- LATIN SMALL LETTER O WITH MACRON .. LATIN SMALL LETTER O WITH MACRON
        -1,  -- LATIN SMALL LETTER O WITH BREVE .. LATIN SMALL LETTER O WITH BREVE
        -1,  -- LATIN SMALL LETTER O WITH DOUBLE ACUTE .. LATIN SMALL LETTER O WITH DOUBLE ACUTE
        -1,  -- LATIN SMALL LIGATURE OE .. LATIN SMALL LIGATURE OE
        -1,  -- LATIN SMALL LETTER R WITH ACUTE .. LATIN SMALL LETTER R WITH ACUTE
        -1,  -- LATIN SMALL LETTER R WITH CEDILLA .. LATIN SMALL LETTER R WITH CEDILLA
        -1,  -- LATIN SMALL LETTER R WITH CARON .. LATIN SMALL LETTER R WITH CARON
        -1,  -- LATIN SMALL LETTER S WITH ACUTE .. LATIN SMALL LETTER S WITH ACUTE
        -1,  -- LATIN SMALL LETTER S WITH CIRCUMFLEX .. LATIN SMALL LETTER S WITH CIRCUMFLEX
        -1,  -- LATIN SMALL LETTER S WITH CEDILLA .. LATIN SMALL LETTER S WITH CEDILLA
        -1,  -- LATIN SMALL LETTER S WITH CARON .. LATIN SMALL LETTER S WITH CARON
        -1,  -- LATIN SMALL LETTER T WITH CEDILLA .. LATIN SMALL LETTER T WITH CEDILLA
        -1,  -- LATIN SMALL LETTER T WITH CARON .. LATIN SMALL LETTER T WITH CARON
        -1,  -- LATIN SMALL LETTER T WITH STROKE .. LATIN SMALL LETTER T WITH STROKE
        -1,  -- LATIN SMALL LETTER U WITH TILDE .. LATIN SMALL LETTER U WITH TILDE
        -1,  -- LATIN SMALL LETTER U WITH MACRON .. LATIN SMALL LETTER U WITH MACRON
        -1,  -- LATIN SMALL LETTER U WITH BREVE .. LATIN SMALL LETTER U WITH BREVE
        -1,  -- LATIN SMALL LETTER U WITH RING ABOVE .. LATIN SMALL LETTER U WITH RING ABOVE
        -1,  -- LATIN SMALL LETTER U WITH DOUBLE ACUTE .. LATIN SMALL LETTER U WITH DOUBLE ACUTE
        -1,  -- LATIN SMALL LETTER U WITH OGONEK .. LATIN SMALL LETTER U WITH OGONEK
        -1,  -- LATIN SMALL LETTER W WITH CIRCUMFLEX .. LATIN SMALL LETTER W WITH CIRCUMFLEX
        -1,  -- LATIN SMALL LETTER Y WITH CIRCUMFLEX .. LATIN SMALL LETTER Y WITH CIRCUMFLEX
        -1,  -- LATIN SMALL LETTER Z WITH ACUTE .. LATIN SMALL LETTER Z WITH ACUTE
        -1,  -- LATIN SMALL LETTER Z WITH DOT ABOVE .. LATIN SMALL LETTER Z WITH DOT ABOVE
        -1,  -- LATIN SMALL LETTER Z WITH CARON .. LATIN SMALL LETTER Z WITH CARON
      -300,  -- LATIN SMALL LETTER LONG S .. LATIN SMALL LETTER LONG S
        -1,  -- LATIN SMALL LETTER B WITH TOPBAR .. LATIN SMALL LETTER B WITH TOPBAR
        -1,  -- LATIN SMALL LETTER TONE SIX .. LATIN SMALL LETTER TONE SIX
        -1,  -- LATIN SMALL LETTER C WITH HOOK .. LATIN SMALL LETTER C WITH HOOK
        -1,  -- LATIN SMALL LETTER D WITH TOPBAR .. LATIN SMALL LETTER D WITH TOPBAR
        -1,  -- LATIN SMALL LETTER F WITH HOOK .. LATIN SMALL LETTER F WITH HOOK
        97,  -- LATIN SMALL LETTER HV .. LATIN SMALL LETTER HV
        -1,  -- LATIN SMALL LETTER K WITH HOOK .. LATIN SMALL LETTER K WITH HOOK
       130,  -- LATIN SMALL LETTER N WITH LONG RIGHT LEG .. LATIN SMALL LETTER N WITH LONG RIGHT LEG
        -1,  -- LATIN SMALL LETTER O WITH HORN .. LATIN SMALL LETTER O WITH HORN
        -1,  -- LATIN SMALL LETTER OI .. LATIN SMALL LETTER OI
        -1,  -- LATIN SMALL LETTER P WITH HOOK .. LATIN SMALL LETTER P WITH HOOK
        -1,  -- LATIN SMALL LETTER TONE TWO .. LATIN SMALL LETTER TONE TWO
        -1,  -- LATIN SMALL LETTER T WITH HOOK .. LATIN SMALL LETTER T WITH HOOK
        -1,  -- LATIN SMALL LETTER U WITH HORN .. LATIN SMALL LETTER U WITH HORN
        -1,  -- LATIN SMALL LETTER Y WITH HOOK .. LATIN SMALL LETTER Y WITH HOOK
        -1,  -- LATIN SMALL LETTER Z WITH STROKE .. LATIN SMALL LETTER Z WITH STROKE
        -1,  -- LATIN SMALL LETTER EZH REVERSED .. LATIN SMALL LETTER EZH REVERSED
        -1,  -- LATIN SMALL LETTER TONE FIVE .. LATIN SMALL LETTER TONE FIVE
        56,  -- LATIN LETTER WYNN .. LATIN LETTER WYNN
        -1,  -- LATIN CAPITAL LETTER D WITH SMALL LETTER Z WITH CARON .. LATIN CAPITAL LETTER D WITH SMALL LETTER Z WITH CARON
        -2,  -- LATIN SMALL LETTER DZ WITH CARON .. LATIN SMALL LETTER DZ WITH CARON
        -1,  -- LATIN CAPITAL LETTER L WITH SMALL LETTER J .. LATIN CAPITAL LETTER L WITH SMALL LETTER J
        -2,  -- LATIN SMALL LETTER LJ .. LATIN SMALL LETTER LJ
        -1,  -- LATIN CAPITAL LETTER N WITH SMALL LETTER J .. LATIN CAPITAL LETTER N WITH SMALL LETTER J
        -2,  -- LATIN SMALL LETTER NJ .. LATIN SMALL LETTER NJ
        -1,  -- LATIN SMALL LETTER A WITH CARON .. LATIN SMALL LETTER A WITH CARON
        -1,  -- LATIN SMALL LETTER I WITH CARON .. LATIN SMALL LETTER I WITH CARON
        -1,  -- LATIN SMALL LETTER O WITH CARON .. LATIN SMALL LETTER O WITH CARON
        -1,  -- LATIN SMALL LETTER U WITH CARON .. LATIN SMALL LETTER U WITH CARON
        -1,  -- LATIN SMALL LETTER U WITH DIAERESIS AND MACRON .. LATIN SMALL LETTER U WITH DIAERESIS AND MACRON
        -1,  -- LATIN SMALL LETTER U WITH DIAERESIS AND ACUTE .. LATIN SMALL LETTER U WITH DIAERESIS AND ACUTE
        -1,  -- LATIN SMALL LETTER U WITH DIAERESIS AND CARON .. LATIN SMALL LETTER U WITH DIAERESIS AND CARON
        -1,  -- LATIN SMALL LETTER U WITH DIAERESIS AND GRAVE .. LATIN SMALL LETTER U WITH DIAERESIS AND GRAVE
       -79,  -- LATIN SMALL LETTER TURNED E .. LATIN SMALL LETTER TURNED E
        -1,  -- LATIN SMALL LETTER A WITH DIAERESIS AND MACRON .. LATIN SMALL LETTER A WITH DIAERESIS AND MACRON
        -1,  -- LATIN SMALL LETTER A WITH DOT ABOVE AND MACRON .. LATIN SMALL LETTER A WITH DOT ABOVE AND MACRON
        -1,  -- LATIN SMALL LETTER AE WITH MACRON .. LATIN SMALL LETTER AE WITH MACRON
        -1,  -- LATIN SMALL LETTER G WITH STROKE .. LATIN SMALL LETTER G WITH STROKE
        -1,  -- LATIN SMALL LETTER G WITH CARON .. LATIN SMALL LETTER G WITH CARON
        -1,  -- LATIN SMALL LETTER K WITH CARON .. LATIN SMALL LETTER K WITH CARON
        -1,  -- LATIN SMALL LETTER O WITH OGONEK .. LATIN SMALL LETTER O WITH OGONEK
        -1,  -- LATIN SMALL LETTER O WITH OGONEK AND MACRON .. LATIN SMALL LETTER O WITH OGONEK AND MACRON
        -1,  -- LATIN SMALL LETTER EZH WITH CARON .. LATIN SMALL LETTER EZH WITH CARON
        -1,  -- LATIN CAPITAL LETTER D WITH SMALL LETTER Z .. LATIN CAPITAL LETTER D WITH SMALL LETTER Z
        -2,  -- LATIN SMALL LETTER DZ .. LATIN SMALL LETTER DZ
        -1,  -- LATIN SMALL LETTER G WITH ACUTE .. LATIN SMALL LETTER G WITH ACUTE
        -1,  -- LATIN SMALL LETTER N WITH GRAVE .. LATIN SMALL LETTER N WITH GRAVE
        -1,  -- LATIN SMALL LETTER A WITH RING ABOVE AND ACUTE .. LATIN SMALL LETTER A WITH RING ABOVE AND ACUTE
        -1,  -- LATIN SMALL LETTER AE WITH ACUTE .. LATIN SMALL LETTER AE WITH ACUTE
        -1,  -- LATIN SMALL LETTER O WITH STROKE AND ACUTE .. LATIN SMALL LETTER O WITH STROKE AND ACUTE
        -1,  -- LATIN SMALL LETTER A WITH DOUBLE GRAVE .. LATIN SMALL LETTER A WITH DOUBLE GRAVE
        -1,  -- LATIN SMALL LETTER A WITH INVERTED BREVE .. LATIN SMALL LETTER A WITH INVERTED BREVE
        -1,  -- LATIN SMALL LETTER E WITH DOUBLE GRAVE .. LATIN SMALL LETTER E WITH DOUBLE GRAVE
        -1,  -- LATIN SMALL LETTER E WITH INVERTED BREVE .. LATIN SMALL LETTER E WITH INVERTED BREVE
        -1,  -- LATIN SMALL LETTER I WITH DOUBLE GRAVE .. LATIN SMALL LETTER I WITH DOUBLE GRAVE
        -1,  -- LATIN SMALL LETTER I WITH INVERTED BREVE .. LATIN SMALL LETTER I WITH INVERTED BREVE
        -1,  -- LATIN SMALL LETTER O WITH DOUBLE GRAVE .. LATIN SMALL LETTER O WITH DOUBLE GRAVE
        -1,  -- LATIN SMALL LETTER O WITH INVERTED BREVE .. LATIN SMALL LETTER O WITH INVERTED BREVE
        -1,  -- LATIN SMALL LETTER R WITH DOUBLE GRAVE .. LATIN SMALL LETTER R WITH DOUBLE GRAVE
        -1,  -- LATIN SMALL LETTER R WITH INVERTED BREVE .. LATIN SMALL LETTER R WITH INVERTED BREVE
        -1,  -- LATIN SMALL LETTER U WITH DOUBLE GRAVE .. LATIN SMALL LETTER U WITH DOUBLE GRAVE
        -1,  -- LATIN SMALL LETTER U WITH INVERTED BREVE .. LATIN SMALL LETTER U WITH INVERTED BREVE
        -1,  -- LATIN SMALL LETTER S WITH COMMA BELOW .. LATIN SMALL LETTER S WITH COMMA BELOW
        -1,  -- LATIN SMALL LETTER T WITH COMMA BELOW .. LATIN SMALL LETTER T WITH COMMA BELOW
        -1,  -- LATIN SMALL LETTER YOGH .. LATIN SMALL LETTER YOGH
        -1,  -- LATIN SMALL LETTER H WITH CARON .. LATIN SMALL LETTER H WITH CARON
        -1,  -- LATIN SMALL LETTER OU .. LATIN SMALL LETTER OU
        -1,  -- LATIN SMALL LETTER Z WITH HOOK .. LATIN SMALL LETTER Z WITH HOOK
        -1,  -- LATIN SMALL LETTER A WITH DOT ABOVE .. LATIN SMALL LETTER A WITH DOT ABOVE
        -1,  -- LATIN SMALL LETTER E WITH CEDILLA .. LATIN SMALL LETTER E WITH CEDILLA
        -1,  -- LATIN SMALL LETTER O WITH DIAERESIS AND MACRON .. LATIN SMALL LETTER O WITH DIAERESIS AND MACRON
        -1,  -- LATIN SMALL LETTER O WITH TILDE AND MACRON .. LATIN SMALL LETTER O WITH TILDE AND MACRON
        -1,  -- LATIN SMALL LETTER O WITH DOT ABOVE .. LATIN SMALL LETTER O WITH DOT ABOVE
        -1,  -- LATIN SMALL LETTER O WITH DOT ABOVE AND MACRON .. LATIN SMALL LETTER O WITH DOT ABOVE AND MACRON
        -1,  -- LATIN SMALL LETTER Y WITH MACRON .. LATIN SMALL LETTER Y WITH MACRON
      -210,  -- LATIN SMALL LETTER B WITH HOOK .. LATIN SMALL LETTER B WITH HOOK
      -206,  -- LATIN SMALL LETTER OPEN O .. LATIN SMALL LETTER OPEN O
      -205,  -- LATIN SMALL LETTER D WITH TAIL .. LATIN SMALL LETTER D WITH HOOK
      -202,  -- LATIN SMALL LETTER SCHWA .. LATIN SMALL LETTER SCHWA
      -203,  -- LATIN SMALL LETTER OPEN E .. LATIN SMALL LETTER OPEN E
      -205,  -- LATIN SMALL LETTER G WITH HOOK .. LATIN SMALL LETTER G WITH HOOK
      -207,  -- LATIN SMALL LETTER GAMMA .. LATIN SMALL LETTER GAMMA
      -209,  -- LATIN SMALL LETTER I WITH STROKE .. LATIN SMALL LETTER I WITH STROKE
      -211,  -- LATIN SMALL LETTER IOTA .. LATIN SMALL LETTER IOTA
      -211,  -- LATIN SMALL LETTER TURNED M .. LATIN SMALL LETTER TURNED M
      -213,  -- LATIN SMALL LETTER N WITH LEFT HOOK .. LATIN SMALL LETTER N WITH LEFT HOOK
      -214,  -- LATIN SMALL LETTER BARRED O .. LATIN SMALL LETTER BARRED O
      -218,  -- LATIN LETTER SMALL CAPITAL R .. LATIN LETTER SMALL CAPITAL R
      -218,  -- LATIN SMALL LETTER ESH .. LATIN SMALL LETTER ESH
      -218,  -- LATIN SMALL LETTER T WITH RETROFLEX HOOK .. LATIN SMALL LETTER T WITH RETROFLEX HOOK
      -217,  -- LATIN SMALL LETTER UPSILON .. LATIN SMALL LETTER V WITH HOOK
      -219,  -- LATIN SMALL LETTER EZH .. LATIN SMALL LETTER EZH
       -38,  -- GREEK SMALL LETTER ALPHA WITH TONOS .. GREEK SMALL LETTER ALPHA WITH TONOS
       -37,  -- GREEK SMALL LETTER EPSILON WITH TONOS .. GREEK SMALL LETTER IOTA WITH TONOS
       -32,  -- GREEK SMALL LETTER ALPHA .. GREEK SMALL LETTER RHO
       -31,  -- GREEK SMALL LETTER FINAL SIGMA .. GREEK SMALL LETTER FINAL SIGMA
       -32,  -- GREEK SMALL LETTER SIGMA .. GREEK SMALL LETTER UPSILON WITH DIALYTIKA
       -64,  -- GREEK SMALL LETTER OMICRON WITH TONOS .. GREEK SMALL LETTER OMICRON WITH TONOS
       -63,  -- GREEK SMALL LETTER UPSILON WITH TONOS .. GREEK SMALL LETTER OMEGA WITH TONOS
       -62,  -- GREEK BETA SYMBOL .. GREEK BETA SYMBOL
       -57,  -- GREEK THETA SYMBOL .. GREEK THETA SYMBOL
       -47,  -- GREEK PHI SYMBOL .. GREEK PHI SYMBOL
       -54,  -- GREEK PI SYMBOL .. GREEK PI SYMBOL
        -1,  -- GREEK SMALL LETTER ARCHAIC KOPPA .. GREEK SMALL LETTER ARCHAIC KOPPA
        -1,  -- GREEK SMALL LETTER STIGMA .. GREEK SMALL LETTER STIGMA
        -1,  -- GREEK SMALL LETTER DIGAMMA .. GREEK SMALL LETTER DIGAMMA
        -1,  -- GREEK SMALL LETTER KOPPA .. GREEK SMALL LETTER KOPPA
        -1,  -- GREEK SMALL LETTER SAMPI .. GREEK SMALL LETTER SAMPI
        -1,  -- COPTIC SMALL LETTER SHEI .. COPTIC SMALL LETTER SHEI
        -1,  -- COPTIC SMALL LETTER FEI .. COPTIC SMALL LETTER FEI
        -1,  -- COPTIC SMALL LETTER KHEI .. COPTIC SMALL LETTER KHEI
        -1,  -- COPTIC SMALL LETTER HORI .. COPTIC SMALL LETTER HORI
        -1,  -- COPTIC SMALL LETTER GANGIA .. COPTIC SMALL LETTER GANGIA
        -1,  -- COPTIC SMALL LETTER SHIMA .. COPTIC SMALL LETTER SHIMA
        -1,  -- COPTIC SMALL LETTER DEI .. COPTIC SMALL LETTER DEI
       -86,  -- GREEK KAPPA SYMBOL .. GREEK KAPPA SYMBOL
       -80,  -- GREEK RHO SYMBOL .. GREEK RHO SYMBOL
       -79,  -- GREEK LUNATE SIGMA SYMBOL .. GREEK LUNATE SIGMA SYMBOL
       -96,  -- GREEK LUNATE EPSILON SYMBOL .. GREEK LUNATE EPSILON SYMBOL
       -32,  -- CYRILLIC SMALL LETTER A .. CYRILLIC SMALL LETTER YA
       -80,  -- CYRILLIC SMALL LETTER IE WITH GRAVE .. CYRILLIC SMALL LETTER DZHE
        -1,  -- CYRILLIC SMALL LETTER OMEGA .. CYRILLIC SMALL LETTER OMEGA
        -1,  -- CYRILLIC SMALL LETTER YAT .. CYRILLIC SMALL LETTER YAT
        -1,  -- CYRILLIC SMALL LETTER IOTIFIED E .. CYRILLIC SMALL LETTER IOTIFIED E
        -1,  -- CYRILLIC SMALL LETTER LITTLE YUS .. CYRILLIC SMALL LETTER LITTLE YUS
        -1,  -- CYRILLIC SMALL LETTER IOTIFIED LITTLE YUS .. CYRILLIC SMALL LETTER IOTIFIED LITTLE YUS
        -1,  -- CYRILLIC SMALL LETTER BIG YUS .. CYRILLIC SMALL LETTER BIG YUS
        -1,  -- CYRILLIC SMALL LETTER IOTIFIED BIG YUS .. CYRILLIC SMALL LETTER IOTIFIED BIG YUS
        -1,  -- CYRILLIC SMALL LETTER KSI .. CYRILLIC SMALL LETTER KSI
        -1,  -- CYRILLIC SMALL LETTER PSI .. CYRILLIC SMALL LETTER PSI
        -1,  -- CYRILLIC SMALL LETTER FITA .. CYRILLIC SMALL LETTER FITA
        -1,  -- CYRILLIC SMALL LETTER IZHITSA .. CYRILLIC SMALL LETTER IZHITSA
        -1,  -- CYRILLIC SMALL LETTER IZHITSA WITH DOUBLE GRAVE ACCENT .. CYRILLIC SMALL LETTER IZHITSA WITH DOUBLE GRAVE ACCENT
        -1,  -- CYRILLIC SMALL LETTER UK .. CYRILLIC SMALL LETTER UK
        -1,  -- CYRILLIC SMALL LETTER ROUND OMEGA .. CYRILLIC SMALL LETTER ROUND OMEGA
        -1,  -- CYRILLIC SMALL LETTER OMEGA WITH TITLO .. CYRILLIC SMALL LETTER OMEGA WITH TITLO
        -1,  -- CYRILLIC SMALL LETTER OT .. CYRILLIC SMALL LETTER OT
        -1,  -- CYRILLIC SMALL LETTER KOPPA .. CYRILLIC SMALL LETTER KOPPA
        -1,  -- CYRILLIC SMALL LETTER SHORT I WITH TAIL .. CYRILLIC SMALL LETTER SHORT I WITH TAIL
        -1,  -- CYRILLIC SMALL LETTER SEMISOFT SIGN .. CYRILLIC SMALL LETTER SEMISOFT SIGN
        -1,  -- CYRILLIC SMALL LETTER ER WITH TICK .. CYRILLIC SMALL LETTER ER WITH TICK
        -1,  -- CYRILLIC SMALL LETTER GHE WITH UPTURN .. CYRILLIC SMALL LETTER GHE WITH UPTURN
        -1,  -- CYRILLIC SMALL LETTER GHE WITH STROKE .. CYRILLIC SMALL LETTER GHE WITH STROKE
        -1,  -- CYRILLIC SMALL LETTER GHE WITH MIDDLE HOOK .. CYRILLIC SMALL LETTER GHE WITH MIDDLE HOOK
        -1,  -- CYRILLIC SMALL LETTER ZHE WITH DESCENDER .. CYRILLIC SMALL LETTER ZHE WITH DESCENDER
        -1,  -- CYRILLIC SMALL LETTER ZE WITH DESCENDER .. CYRILLIC SMALL LETTER ZE WITH DESCENDER
        -1,  -- CYRILLIC SMALL LETTER KA WITH DESCENDER .. CYRILLIC SMALL LETTER KA WITH DESCENDER
        -1,  -- CYRILLIC SMALL LETTER KA WITH VERTICAL STROKE .. CYRILLIC SMALL LETTER KA WITH VERTICAL STROKE
        -1,  -- CYRILLIC SMALL LETTER KA WITH STROKE .. CYRILLIC SMALL LETTER KA WITH STROKE
        -1,  -- CYRILLIC SMALL LETTER BASHKIR KA .. CYRILLIC SMALL LETTER BASHKIR KA
        -1,  -- CYRILLIC SMALL LETTER EN WITH DESCENDER .. CYRILLIC SMALL LETTER EN WITH DESCENDER
        -1,  -- CYRILLIC SMALL LIGATURE EN GHE .. CYRILLIC SMALL LIGATURE EN GHE
        -1,  -- CYRILLIC SMALL LETTER PE WITH MIDDLE HOOK .. CYRILLIC SMALL LETTER PE WITH MIDDLE HOOK
        -1,  -- CYRILLIC SMALL LETTER ABKHASIAN HA .. CYRILLIC SMALL LETTER ABKHASIAN HA
        -1,  -- CYRILLIC SMALL LETTER ES WITH DESCENDER .. CYRILLIC SMALL LETTER ES WITH DESCENDER
        -1,  -- CYRILLIC SMALL LETTER TE WITH DESCENDER .. CYRILLIC SMALL LETTER TE WITH DESCENDER
        -1,  -- CYRILLIC SMALL LETTER STRAIGHT U .. CYRILLIC SMALL LETTER STRAIGHT U
        -1,  -- CYRILLIC SMALL LETTER STRAIGHT U WITH STROKE .. CYRILLIC SMALL LETTER STRAIGHT U WITH STROKE
        -1,  -- CYRILLIC SMALL LETTER HA WITH DESCENDER .. CYRILLIC SMALL LETTER HA WITH DESCENDER
        -1,  -- CYRILLIC SMALL LIGATURE TE TSE .. CYRILLIC SMALL LIGATURE TE TSE
        -1,  -- CYRILLIC SMALL LETTER CHE WITH DESCENDER .. CYRILLIC SMALL LETTER CHE WITH DESCENDER
        -1,  -- CYRILLIC SMALL LETTER CHE WITH VERTICAL STROKE .. CYRILLIC SMALL LETTER CHE WITH VERTICAL STROKE
        -1,  -- CYRILLIC SMALL LETTER SHHA .. CYRILLIC SMALL LETTER SHHA
        -1,  -- CYRILLIC SMALL LETTER ABKHASIAN CHE .. CYRILLIC SMALL LETTER ABKHASIAN CHE
        -1,  -- CYRILLIC SMALL LETTER ABKHASIAN CHE WITH DESCENDER .. CYRILLIC SMALL LETTER ABKHASIAN CHE WITH DESCENDER
        -1,  -- CYRILLIC SMALL LETTER ZHE WITH BREVE .. CYRILLIC SMALL LETTER ZHE WITH BREVE
        -1,  -- CYRILLIC SMALL LETTER KA WITH HOOK .. CYRILLIC SMALL LETTER KA WITH HOOK
        -1,  -- CYRILLIC SMALL LETTER EL WITH TAIL .. CYRILLIC SMALL LETTER EL WITH TAIL
        -1,  -- CYRILLIC SMALL LETTER EN WITH HOOK .. CYRILLIC SMALL LETTER EN WITH HOOK
        -1,  -- CYRILLIC SMALL LETTER EN WITH TAIL .. CYRILLIC SMALL LETTER EN WITH TAIL
        -1,  -- CYRILLIC SMALL LETTER KHAKASSIAN CHE .. CYRILLIC SMALL LETTER KHAKASSIAN CHE
        -1,  -- CYRILLIC SMALL LETTER EM WITH TAIL .. CYRILLIC SMALL LETTER EM WITH TAIL
        -1,  -- CYRILLIC SMALL LETTER A WITH BREVE .. CYRILLIC SMALL LETTER A WITH BREVE
        -1,  -- CYRILLIC SMALL LETTER A WITH DIAERESIS .. CYRILLIC SMALL LETTER A WITH DIAERESIS
        -1,  -- CYRILLIC SMALL LIGATURE A IE .. CYRILLIC SMALL LIGATURE A IE
        -1,  -- CYRILLIC SMALL LETTER IE WITH BREVE .. CYRILLIC SMALL LETTER IE WITH BREVE
        -1,  -- CYRILLIC SMALL LETTER SCHWA .. CYRILLIC SMALL LETTER SCHWA
        -1,  -- CYRILLIC SMALL LETTER SCHWA WITH DIAERESIS .. CYRILLIC SMALL LETTER SCHWA WITH DIAERESIS
        -1,  -- CYRILLIC SMALL LETTER ZHE WITH DIAERESIS .. CYRILLIC SMALL LETTER ZHE WITH DIAERESIS
        -1,  -- CYRILLIC SMALL LETTER ZE WITH DIAERESIS .. CYRILLIC SMALL LETTER ZE WITH DIAERESIS
        -1,  -- CYRILLIC SMALL LETTER ABKHASIAN DZE .. CYRILLIC SMALL LETTER ABKHASIAN DZE
        -1,  -- CYRILLIC SMALL LETTER I WITH MACRON .. CYRILLIC SMALL LETTER I WITH MACRON
        -1,  -- CYRILLIC SMALL LETTER I WITH DIAERESIS .. CYRILLIC SMALL LETTER I WITH DIAERESIS
        -1,  -- CYRILLIC SMALL LETTER O WITH DIAERESIS .. CYRILLIC SMALL LETTER O WITH DIAERESIS
        -1,  -- CYRILLIC SMALL LETTER BARRED O .. CYRILLIC SMALL LETTER BARRED O
        -1,  -- CYRILLIC SMALL LETTER BARRED O WITH DIAERESIS .. CYRILLIC SMALL LETTER BARRED O WITH DIAERESIS
        -1,  -- CYRILLIC SMALL LETTER E WITH DIAERESIS .. CYRILLIC SMALL LETTER E WITH DIAERESIS
        -1,  -- CYRILLIC SMALL LETTER U WITH MACRON .. CYRILLIC SMALL LETTER U WITH MACRON
        -1,  -- CYRILLIC SMALL LETTER U WITH DIAERESIS .. CYRILLIC SMALL LETTER U WITH DIAERESIS
        -1,  -- CYRILLIC SMALL LETTER U WITH DOUBLE ACUTE .. CYRILLIC SMALL LETTER U WITH DOUBLE ACUTE
        -1,  -- CYRILLIC SMALL LETTER CHE WITH DIAERESIS .. CYRILLIC SMALL LETTER CHE WITH DIAERESIS
        -1,  -- CYRILLIC SMALL LETTER YERU WITH DIAERESIS .. CYRILLIC SMALL LETTER YERU WITH DIAERESIS
        -1,  -- CYRILLIC SMALL LETTER KOMI DE .. CYRILLIC SMALL LETTER KOMI DE
        -1,  -- CYRILLIC SMALL LETTER KOMI DJE .. CYRILLIC SMALL LETTER KOMI DJE
        -1,  -- CYRILLIC SMALL LETTER KOMI ZJE .. CYRILLIC SMALL LETTER KOMI ZJE
        -1,  -- CYRILLIC SMALL LETTER KOMI DZJE .. CYRILLIC SMALL LETTER KOMI DZJE
        -1,  -- CYRILLIC SMALL LETTER KOMI LJE .. CYRILLIC SMALL LETTER KOMI LJE
        -1,  -- CYRILLIC SMALL LETTER KOMI NJE .. CYRILLIC SMALL LETTER KOMI NJE
        -1,  -- CYRILLIC SMALL LETTER KOMI SJE .. CYRILLIC SMALL LETTER KOMI SJE
        -1,  -- CYRILLIC SMALL LETTER KOMI TJE .. CYRILLIC SMALL LETTER KOMI TJE
       -48,  -- ARMENIAN SMALL LETTER AYB .. ARMENIAN SMALL LETTER FEH
        -1,  -- LATIN SMALL LETTER A WITH RING BELOW .. LATIN SMALL LETTER A WITH RING BELOW
        -1,  -- LATIN SMALL LETTER B WITH DOT ABOVE .. LATIN SMALL LETTER B WITH DOT ABOVE
        -1,  -- LATIN SMALL LETTER B WITH DOT BELOW .. LATIN SMALL LETTER B WITH DOT BELOW
        -1,  -- LATIN SMALL LETTER B WITH LINE BELOW .. LATIN SMALL LETTER B WITH LINE BELOW
        -1,  -- LATIN SMALL LETTER C WITH CEDILLA AND ACUTE .. LATIN SMALL LETTER C WITH CEDILLA AND ACUTE
        -1,  -- LATIN SMALL LETTER D WITH DOT ABOVE .. LATIN SMALL LETTER D WITH DOT ABOVE
        -1,  -- LATIN SMALL LETTER D WITH DOT BELOW .. LATIN SMALL LETTER D WITH DOT BELOW
        -1,  -- LATIN SMALL LETTER D WITH LINE BELOW .. LATIN SMALL LETTER D WITH LINE BELOW
        -1,  -- LATIN SMALL LETTER D WITH CEDILLA .. LATIN SMALL LETTER D WITH CEDILLA
        -1,  -- LATIN SMALL LETTER D WITH CIRCUMFLEX BELOW .. LATIN SMALL LETTER D WITH CIRCUMFLEX BELOW
        -1,  -- LATIN SMALL LETTER E WITH MACRON AND GRAVE .. LATIN SMALL LETTER E WITH MACRON AND GRAVE
        -1,  -- LATIN SMALL LETTER E WITH MACRON AND ACUTE .. LATIN SMALL LETTER E WITH MACRON AND ACUTE
        -1,  -- LATIN SMALL LETTER E WITH CIRCUMFLEX BELOW .. LATIN SMALL LETTER E WITH CIRCUMFLEX BELOW
        -1,  -- LATIN SMALL LETTER E WITH TILDE BELOW .. LATIN SMALL LETTER E WITH TILDE BELOW
        -1,  -- LATIN SMALL LETTER E WITH CEDILLA AND BREVE .. LATIN SMALL LETTER E WITH CEDILLA AND BREVE
        -1,  -- LATIN SMALL LETTER F WITH DOT ABOVE .. LATIN SMALL LETTER F WITH DOT ABOVE
        -1,  -- LATIN SMALL LETTER G WITH MACRON .. LATIN SMALL LETTER G WITH MACRON
        -1,  -- LATIN SMALL LETTER H WITH DOT ABOVE .. LATIN SMALL LETTER H WITH DOT ABOVE
        -1,  -- LATIN SMALL LETTER H WITH DOT BELOW .. LATIN SMALL LETTER H WITH DOT BELOW
        -1,  -- LATIN SMALL LETTER H WITH DIAERESIS .. LATIN SMALL LETTER H WITH DIAERESIS
        -1,  -- LATIN SMALL LETTER H WITH CEDILLA .. LATIN SMALL LETTER H WITH CEDILLA
        -1,  -- LATIN SMALL LETTER H WITH BREVE BELOW .. LATIN SMALL LETTER H WITH BREVE BELOW
        -1,  -- LATIN SMALL LETTER I WITH TILDE BELOW .. LATIN SMALL LETTER I WITH TILDE BELOW
        -1,  -- LATIN SMALL LETTER I WITH DIAERESIS AND ACUTE .. LATIN SMALL LETTER I WITH DIAERESIS AND ACUTE
        -1,  -- LATIN SMALL LETTER K WITH ACUTE .. LATIN SMALL LETTER K WITH ACUTE
        -1,  -- LATIN SMALL LETTER K WITH DOT BELOW .. LATIN SMALL LETTER K WITH DOT BELOW
        -1,  -- LATIN SMALL LETTER K WITH LINE BELOW .. LATIN SMALL LETTER K WITH LINE BELOW
        -1,  -- LATIN SMALL LETTER L WITH DOT BELOW .. LATIN SMALL LETTER L WITH DOT BELOW
        -1,  -- LATIN SMALL LETTER L WITH DOT BELOW AND MACRON .. LATIN SMALL LETTER L WITH DOT BELOW AND MACRON
        -1,  -- LATIN SMALL LETTER L WITH LINE BELOW .. LATIN SMALL LETTER L WITH LINE BELOW
        -1,  -- LATIN SMALL LETTER L WITH CIRCUMFLEX BELOW .. LATIN SMALL LETTER L WITH CIRCUMFLEX BELOW
        -1,  -- LATIN SMALL LETTER M WITH ACUTE .. LATIN SMALL LETTER M WITH ACUTE
        -1,  -- LATIN SMALL LETTER M WITH DOT ABOVE .. LATIN SMALL LETTER M WITH DOT ABOVE
        -1,  -- LATIN SMALL LETTER M WITH DOT BELOW .. LATIN SMALL LETTER M WITH DOT BELOW
        -1,  -- LATIN SMALL LETTER N WITH DOT ABOVE .. LATIN SMALL LETTER N WITH DOT ABOVE
        -1,  -- LATIN SMALL LETTER N WITH DOT BELOW .. LATIN SMALL LETTER N WITH DOT BELOW
        -1,  -- LATIN SMALL LETTER N WITH LINE BELOW .. LATIN SMALL LETTER N WITH LINE BELOW
        -1,  -- LATIN SMALL LETTER N WITH CIRCUMFLEX BELOW .. LATIN SMALL LETTER N WITH CIRCUMFLEX BELOW
        -1,  -- LATIN SMALL LETTER O WITH TILDE AND ACUTE .. LATIN SMALL LETTER O WITH TILDE AND ACUTE
        -1,  -- LATIN SMALL LETTER O WITH TILDE AND DIAERESIS .. LATIN SMALL LETTER O WITH TILDE AND DIAERESIS
        -1,  -- LATIN SMALL LETTER O WITH MACRON AND GRAVE .. LATIN SMALL LETTER O WITH MACRON AND GRAVE
        -1,  -- LATIN SMALL LETTER O WITH MACRON AND ACUTE .. LATIN SMALL LETTER O WITH MACRON AND ACUTE
        -1,  -- LATIN SMALL LETTER P WITH ACUTE .. LATIN SMALL LETTER P WITH ACUTE
        -1,  -- LATIN SMALL LETTER P WITH DOT ABOVE .. LATIN SMALL LETTER P WITH DOT ABOVE
        -1,  -- LATIN SMALL LETTER R WITH DOT ABOVE .. LATIN SMALL LETTER R WITH DOT ABOVE
        -1,  -- LATIN SMALL LETTER R WITH DOT BELOW .. LATIN SMALL LETTER R WITH DOT BELOW
        -1,  -- LATIN SMALL LETTER R WITH DOT BELOW AND MACRON .. LATIN SMALL LETTER R WITH DOT BELOW AND MACRON
        -1,  -- LATIN SMALL LETTER R WITH LINE BELOW .. LATIN SMALL LETTER R WITH LINE BELOW
        -1,  -- LATIN SMALL LETTER S WITH DOT ABOVE .. LATIN SMALL LETTER S WITH DOT ABOVE
        -1,  -- LATIN SMALL LETTER S WITH DOT BELOW .. LATIN SMALL LETTER S WITH DOT BELOW
        -1,  -- LATIN SMALL LETTER S WITH ACUTE AND DOT ABOVE .. LATIN SMALL LETTER S WITH ACUTE AND DOT ABOVE
        -1,  -- LATIN SMALL LETTER S WITH CARON AND DOT ABOVE .. LATIN SMALL LETTER S WITH CARON AND DOT ABOVE
        -1,  -- LATIN SMALL LETTER S WITH DOT BELOW AND DOT ABOVE .. LATIN SMALL LETTER S WITH DOT BELOW AND DOT ABOVE
        -1,  -- LATIN SMALL LETTER T WITH DOT ABOVE .. LATIN SMALL LETTER T WITH DOT ABOVE
        -1,  -- LATIN SMALL LETTER T WITH DOT BELOW .. LATIN SMALL LETTER T WITH DOT BELOW
        -1,  -- LATIN SMALL LETTER T WITH LINE BELOW .. LATIN SMALL LETTER T WITH LINE BELOW
        -1,  -- LATIN SMALL LETTER T WITH CIRCUMFLEX BELOW .. LATIN SMALL LETTER T WITH CIRCUMFLEX BELOW
        -1,  -- LATIN SMALL LETTER U WITH DIAERESIS BELOW .. LATIN SMALL LETTER U WITH DIAERESIS BELOW
        -1,  -- LATIN SMALL LETTER U WITH TILDE BELOW .. LATIN SMALL LETTER U WITH TILDE BELOW
        -1,  -- LATIN SMALL LETTER U WITH CIRCUMFLEX BELOW .. LATIN SMALL LETTER U WITH CIRCUMFLEX BELOW
        -1,  -- LATIN SMALL LETTER U WITH TILDE AND ACUTE .. LATIN SMALL LETTER U WITH TILDE AND ACUTE
        -1,  -- LATIN SMALL LETTER U WITH MACRON AND DIAERESIS .. LATIN SMALL LETTER U WITH MACRON AND DIAERESIS
        -1,  -- LATIN SMALL LETTER V WITH TILDE .. LATIN SMALL LETTER V WITH TILDE
        -1,  -- LATIN SMALL LETTER V WITH DOT BELOW .. LATIN SMALL LETTER V WITH DOT BELOW
        -1,  -- LATIN SMALL LETTER W WITH GRAVE .. LATIN SMALL LETTER W WITH GRAVE
        -1,  -- LATIN SMALL LETTER W WITH ACUTE .. LATIN SMALL LETTER W WITH ACUTE
        -1,  -- LATIN SMALL LETTER W WITH DIAERESIS .. LATIN SMALL LETTER W WITH DIAERESIS
        -1,  -- LATIN SMALL LETTER W WITH DOT ABOVE .. LATIN SMALL LETTER W WITH DOT ABOVE
        -1,  -- LATIN SMALL LETTER W WITH DOT BELOW .. LATIN SMALL LETTER W WITH DOT BELOW
        -1,  -- LATIN SMALL LETTER X WITH DOT ABOVE .. LATIN SMALL LETTER X WITH DOT ABOVE
        -1,  -- LATIN SMALL LETTER X WITH DIAERESIS .. LATIN SMALL LETTER X WITH DIAERESIS
        -1,  -- LATIN SMALL LETTER Y WITH DOT ABOVE .. LATIN SMALL LETTER Y WITH DOT ABOVE
        -1,  -- LATIN SMALL LETTER Z WITH CIRCUMFLEX .. LATIN SMALL LETTER Z WITH CIRCUMFLEX
        -1,  -- LATIN SMALL LETTER Z WITH DOT BELOW .. LATIN SMALL LETTER Z WITH DOT BELOW
        -1,  -- LATIN SMALL LETTER Z WITH LINE BELOW .. LATIN SMALL LETTER Z WITH LINE BELOW
       -59,  -- LATIN SMALL LETTER LONG S WITH DOT ABOVE .. LATIN SMALL LETTER LONG S WITH DOT ABOVE
        -1,  -- LATIN SMALL LETTER A WITH DOT BELOW .. LATIN SMALL LETTER A WITH DOT BELOW
        -1,  -- LATIN SMALL LETTER A WITH HOOK ABOVE .. LATIN SMALL LETTER A WITH HOOK ABOVE
        -1,  -- LATIN SMALL LETTER A WITH CIRCUMFLEX AND ACUTE .. LATIN SMALL LETTER A WITH CIRCUMFLEX AND ACUTE
        -1,  -- LATIN SMALL LETTER A WITH CIRCUMFLEX AND GRAVE .. LATIN SMALL LETTER A WITH CIRCUMFLEX AND GRAVE
        -1,  -- LATIN SMALL LETTER A WITH CIRCUMFLEX AND HOOK ABOVE .. LATIN SMALL LETTER A WITH CIRCUMFLEX AND HOOK ABOVE
        -1,  -- LATIN SMALL LETTER A WITH CIRCUMFLEX AND TILDE .. LATIN SMALL LETTER A WITH CIRCUMFLEX AND TILDE
        -1,  -- LATIN SMALL LETTER A WITH CIRCUMFLEX AND DOT BELOW .. LATIN SMALL LETTER A WITH CIRCUMFLEX AND DOT BELOW
        -1,  -- LATIN SMALL LETTER A WITH BREVE AND ACUTE .. LATIN SMALL LETTER A WITH BREVE AND ACUTE
        -1,  -- LATIN SMALL LETTER A WITH BREVE AND GRAVE .. LATIN SMALL LETTER A WITH BREVE AND GRAVE
        -1,  -- LATIN SMALL LETTER A WITH BREVE AND HOOK ABOVE .. LATIN SMALL LETTER A WITH BREVE AND HOOK ABOVE
        -1,  -- LATIN SMALL LETTER A WITH BREVE AND TILDE .. LATIN SMALL LETTER A WITH BREVE AND TILDE
        -1,  -- LATIN SMALL LETTER A WITH BREVE AND DOT BELOW .. LATIN SMALL LETTER A WITH BREVE AND DOT BELOW
        -1,  -- LATIN SMALL LETTER E WITH DOT BELOW .. LATIN SMALL LETTER E WITH DOT BELOW
        -1,  -- LATIN SMALL LETTER E WITH HOOK ABOVE .. LATIN SMALL LETTER E WITH HOOK ABOVE
        -1,  -- LATIN SMALL LETTER E WITH TILDE .. LATIN SMALL LETTER E WITH TILDE
        -1,  -- LATIN SMALL LETTER E WITH CIRCUMFLEX AND ACUTE .. LATIN SMALL LETTER E WITH CIRCUMFLEX AND ACUTE
        -1,  -- LATIN SMALL LETTER E WITH CIRCUMFLEX AND GRAVE .. LATIN SMALL LETTER E WITH CIRCUMFLEX AND GRAVE
        -1,  -- LATIN SMALL LETTER E WITH CIRCUMFLEX AND HOOK ABOVE .. LATIN SMALL LETTER E WITH CIRCUMFLEX AND HOOK ABOVE
        -1,  -- LATIN SMALL LETTER E WITH CIRCUMFLEX AND TILDE .. LATIN SMALL LETTER E WITH CIRCUMFLEX AND TILDE
        -1,  -- LATIN SMALL LETTER E WITH CIRCUMFLEX AND DOT BELOW .. LATIN SMALL LETTER E WITH CIRCUMFLEX AND DOT BELOW
        -1,  -- LATIN SMALL LETTER I WITH HOOK ABOVE .. LATIN SMALL LETTER I WITH HOOK ABOVE
        -1,  -- LATIN SMALL LETTER I WITH DOT BELOW .. LATIN SMALL LETTER I WITH DOT BELOW
        -1,  -- LATIN SMALL LETTER O WITH DOT BELOW .. LATIN SMALL LETTER O WITH DOT BELOW
        -1,  -- LATIN SMALL LETTER O WITH HOOK ABOVE .. LATIN SMALL LETTER O WITH HOOK ABOVE
        -1,  -- LATIN SMALL LETTER O WITH CIRCUMFLEX AND ACUTE .. LATIN SMALL LETTER O WITH CIRCUMFLEX AND ACUTE
        -1,  -- LATIN SMALL LETTER O WITH CIRCUMFLEX AND GRAVE .. LATIN SMALL LETTER O WITH CIRCUMFLEX AND GRAVE
        -1,  -- LATIN SMALL LETTER O WITH CIRCUMFLEX AND HOOK ABOVE .. LATIN SMALL LETTER O WITH CIRCUMFLEX AND HOOK ABOVE
        -1,  -- LATIN SMALL LETTER O WITH CIRCUMFLEX AND TILDE .. LATIN SMALL LETTER O WITH CIRCUMFLEX AND TILDE
        -1,  -- LATIN SMALL LETTER O WITH CIRCUMFLEX AND DOT BELOW .. LATIN SMALL LETTER O WITH CIRCUMFLEX AND DOT BELOW
        -1,  -- LATIN SMALL LETTER O WITH HORN AND ACUTE .. LATIN SMALL LETTER O WITH HORN AND ACUTE
        -1,  -- LATIN SMALL LETTER O WITH HORN AND GRAVE .. LATIN SMALL LETTER O WITH HORN AND GRAVE
        -1,  -- LATIN SMALL LETTER O WITH HORN AND HOOK ABOVE .. LATIN SMALL LETTER O WITH HORN AND HOOK ABOVE
        -1,  -- LATIN SMALL LETTER O WITH HORN AND TILDE .. LATIN SMALL LETTER O WITH HORN AND TILDE
        -1,  -- LATIN SMALL LETTER O WITH HORN AND DOT BELOW .. LATIN SMALL LETTER O WITH HORN AND DOT BELOW
        -1,  -- LATIN SMALL LETTER U WITH DOT BELOW .. LATIN SMALL LETTER U WITH DOT BELOW
        -1,  -- LATIN SMALL LETTER U WITH HOOK ABOVE .. LATIN SMALL LETTER U WITH HOOK ABOVE
        -1,  -- LATIN SMALL LETTER U WITH HORN AND ACUTE .. LATIN SMALL LETTER U WITH HORN AND ACUTE
        -1,  -- LATIN SMALL LETTER U WITH HORN AND GRAVE .. LATIN SMALL LETTER U WITH HORN AND GRAVE
        -1,  -- LATIN SMALL LETTER U WITH HORN AND HOOK ABOVE .. LATIN SMALL LETTER U WITH HORN AND HOOK ABOVE
        -1,  -- LATIN SMALL LETTER U WITH HORN AND TILDE .. LATIN SMALL LETTER U WITH HORN AND TILDE
        -1,  -- LATIN SMALL LETTER U WITH HORN AND DOT BELOW .. LATIN SMALL LETTER U WITH HORN AND DOT BELOW
        -1,  -- LATIN SMALL LETTER Y WITH GRAVE .. LATIN SMALL LETTER Y WITH GRAVE
        -1,  -- LATIN SMALL LETTER Y WITH DOT BELOW .. LATIN SMALL LETTER Y WITH DOT BELOW
        -1,  -- LATIN SMALL LETTER Y WITH HOOK ABOVE .. LATIN SMALL LETTER Y WITH HOOK ABOVE
        -1,  -- LATIN SMALL LETTER Y WITH TILDE .. LATIN SMALL LETTER Y WITH TILDE
         8,  -- GREEK SMALL LETTER ALPHA WITH PSILI .. GREEK SMALL LETTER ALPHA WITH DASIA AND PERISPOMENI
         8,  -- GREEK SMALL LETTER EPSILON WITH PSILI .. GREEK SMALL LETTER EPSILON WITH DASIA AND OXIA
         8,  -- GREEK SMALL LETTER ETA WITH PSILI .. GREEK SMALL LETTER ETA WITH DASIA AND PERISPOMENI
         8,  -- GREEK SMALL LETTER IOTA WITH PSILI .. GREEK SMALL LETTER IOTA WITH DASIA AND PERISPOMENI
         8,  -- GREEK SMALL LETTER OMICRON WITH PSILI .. GREEK SMALL LETTER OMICRON WITH DASIA AND OXIA
         8,  -- GREEK SMALL LETTER UPSILON WITH DASIA .. GREEK SMALL LETTER UPSILON WITH DASIA
         8,  -- GREEK SMALL LETTER UPSILON WITH DASIA AND VARIA .. GREEK SMALL LETTER UPSILON WITH DASIA AND VARIA
         8,  -- GREEK SMALL LETTER UPSILON WITH DASIA AND OXIA .. GREEK SMALL LETTER UPSILON WITH DASIA AND OXIA
         8,  -- GREEK SMALL LETTER UPSILON WITH DASIA AND PERISPOMENI .. GREEK SMALL LETTER UPSILON WITH DASIA AND PERISPOMENI
         8,  -- GREEK SMALL LETTER OMEGA WITH PSILI .. GREEK SMALL LETTER OMEGA WITH DASIA AND PERISPOMENI
        74,  -- GREEK SMALL LETTER ALPHA WITH VARIA .. GREEK SMALL LETTER ALPHA WITH OXIA
        86,  -- GREEK SMALL LETTER EPSILON WITH VARIA .. GREEK SMALL LETTER ETA WITH OXIA
       100,  -- GREEK SMALL LETTER IOTA WITH VARIA .. GREEK SMALL LETTER IOTA WITH OXIA
       128,  -- GREEK SMALL LETTER OMICRON WITH VARIA .. GREEK SMALL LETTER OMICRON WITH OXIA
       112,  -- GREEK SMALL LETTER UPSILON WITH VARIA .. GREEK SMALL LETTER UPSILON WITH OXIA
       126,  -- GREEK SMALL LETTER OMEGA WITH VARIA .. GREEK SMALL LETTER OMEGA WITH OXIA
         8,  -- GREEK SMALL LETTER ALPHA WITH PSILI AND YPOGEGRAMMENI .. GREEK SMALL LETTER ALPHA WITH DASIA AND PERISPOMENI AND YPOGEGRAMMENI
         8,  -- GREEK SMALL LETTER ETA WITH PSILI AND YPOGEGRAMMENI .. GREEK SMALL LETTER ETA WITH DASIA AND PERISPOMENI AND YPOGEGRAMMENI
         8,  -- GREEK SMALL LETTER OMEGA WITH PSILI AND YPOGEGRAMMENI .. GREEK SMALL LETTER OMEGA WITH DASIA AND PERISPOMENI AND YPOGEGRAMMENI
         8,  -- GREEK SMALL LETTER ALPHA WITH VRACHY .. GREEK SMALL LETTER ALPHA WITH MACRON
         9,  -- GREEK SMALL LETTER ALPHA WITH YPOGEGRAMMENI .. GREEK SMALL LETTER ALPHA WITH YPOGEGRAMMENI
     -7205,  -- GREEK PROSGEGRAMMENI .. GREEK PROSGEGRAMMENI
         9,  -- GREEK SMALL LETTER ETA WITH YPOGEGRAMMENI .. GREEK SMALL LETTER ETA WITH YPOGEGRAMMENI
         8,  -- GREEK SMALL LETTER IOTA WITH VRACHY .. GREEK SMALL LETTER IOTA WITH MACRON
         8,  -- GREEK SMALL LETTER UPSILON WITH VRACHY .. GREEK SMALL LETTER UPSILON WITH MACRON
         7,  -- GREEK SMALL LETTER RHO WITH DASIA .. GREEK SMALL LETTER RHO WITH DASIA
         9,  -- GREEK SMALL LETTER OMEGA WITH YPOGEGRAMMENI .. GREEK SMALL LETTER OMEGA WITH YPOGEGRAMMENI
       -32,  -- FULLWIDTH LATIN SMALL LETTER A .. FULLWIDTH LATIN SMALL LETTER Z
       -40); -- DESERET SMALL LETTER LONG I .. DESERET SMALL LETTER ENG


   -----------------------
   -- Local Subprograms --
   -----------------------

   function Range_Search (U : UTF_32; R : UTF_32_Ranges) return Natural;
   --  Searches the given ranges (which must be in ascending order by Lo value)
   --  and returns the index of the matching range in R if U matches one of the
   --  ranges. If U matches none of the ranges, returns zero.

   ---------------------
   -- Is_UTF_32_Digit --
   ---------------------

   function Is_UTF_32_Digit (U : UTF_32) return Boolean is
   begin
      return Range_Search (U, UTF_32_Digits) /= 0;
   end Is_UTF_32_Digit;

   ----------------------
   -- Is_UTF_32_Letter --
   ----------------------

   function Is_UTF_32_Letter (U : UTF_32) return Boolean is
   begin
      return Range_Search (U, UTF_32_Letters) /= 0;
   end Is_UTF_32_Letter;

   -------------------------------
   -- Is_UTF_32_Line_Terminator --
   -------------------------------

   function Is_UTF_32_Line_Terminator (U : UTF_32) return Boolean is
   begin
      return U in 10 .. 13     -- Ascii.LF Ascii.VT Ascii.FF Ascii.CR
        or else U = 16#02028#  -- LINE SEPARATOR
        or else U = 16#02029#; -- PARAGRAPH SEPARATOR
   end Is_UTF_32_Line_Terminator;

   --------------------
   -- Is_UTF_32_Mark --
   --------------------

   function Is_UTF_32_Mark (U : UTF_32) return Boolean is
   begin
      return Range_Search (U, UTF_32_Marks) /= 0;
   end Is_UTF_32_Mark;

   ---------------------------
   -- Is_UTF_32_Non_Graphic --
   ---------------------------

   function Is_UTF_32_Non_Graphic (U : UTF_32) return Boolean is
   begin
      return Range_Search (U, UTF_32_Non_Graphic) /= 0;
   end Is_UTF_32_Non_Graphic;

   ---------------------
   -- Is_UTF_32_Other --
   ---------------------

   function Is_UTF_32_Other (U : UTF_32) return Boolean is
   begin
      return Range_Search (U, UTF_32_Other_Format) /= 0;
   end Is_UTF_32_Other;

   ---------------------------
   -- Is_UTF_32_Punctuation --
   ---------------------------

   function Is_UTF_32_Punctuation (U : UTF_32) return Boolean is
   begin
      return Range_Search (U, UTF_32_Punctuation) /= 0;
   end Is_UTF_32_Punctuation;

   ---------------------
   -- Is_UTF_32_Space --
   ---------------------

   function Is_UTF_32_Space (U : UTF_32) return Boolean is
   begin
      return Range_Search (U, UTF_32_Spaces) /= 0;
   end Is_UTF_32_Space;

   ------------------
   -- Range_Search --
   ------------------

   function Range_Search (U : UTF_32; R : UTF_32_Ranges) return Natural is
      Lo  : Integer;
      Hi  : Integer;
      Mid : Integer;

   begin
      Lo := R'First;
      Hi := R'Last;

      loop
         Mid := (Lo + Hi) / 2;

         if U < R (Mid).Lo then
            Hi := Mid - 1;

            if Hi < Lo then
               return 0;
            end if;

         elsif R (Mid).Hi < U then
            Lo := Mid + 1;

            if Hi < Lo then
               return 0;
            end if;

         else
            return Mid;
         end if;
      end loop;
   end Range_Search;

   --------------------------
   -- UTF_32_To_Upper_Case --
   --------------------------

   function UTF_32_To_Upper_Case (U : UTF_32) return UTF_32 is
      Index : constant Integer := Range_Search (U, Lower_Case_Letters);
   begin
      if Index = 0 then
         return U;
      else
         return U + Upper_Case_Adjust (Index);
      end if;
   end UTF_32_To_Upper_Case;

end GNAT.UTF_32;
