#! /bin/sh
#
# I used this script to generate GCC-3.3.5 documentation package for DJGPP.
# This script is tested only under Linux (specify source and build directories
# as parameters
#
srcdir=`(cd ${1-@SRCDIR@}; pwd)`
builddir=`(cd ${2-../build.gcc}; pwd)`
#
MAKEINFO=makeinfo
DVIPS=dvips
DVIPDF=dvipdfm                             
#
if ! [ -f $srcdir/gcc/gcc.c ] ; then
    echo "GCC source directory is not found"
    exit 1
fi

if ! [ -f $builddir/gcc/Makefile ] ; then
    echo "GCC build directory is not found"
    exit 1
fi    
#
TOP=`pwd`
version=`grep version_string $srcdir/gcc/version.c |\
         sed -e 's/.*\"\(.*\)\".*/\1/'`
ver1=`echo $version | sed -e 's/\.//2'`
ver2=`echo $version | sed -e 's/\.//g'`
docdir=gnudocs/gcc-$ver1
MKHTML="$MAKEINFO --no-split --number-sections --html"

mkdir -p $docdir

cd $builddir || exit 1
make dvi
for x in `find . -name '*.dvi'` ; do cp -v $x $TOP/$docdir/`basename $x`; done
if [ -f $TOP/$docdir/gpc.dvi ] ; then
    cp $builddir/gcc/GnuPascal.eps $TOP/$docdir/
fi    

cd $srcdir/libiberty || exit 1
$MKHTML libiberty.texi
cp -v libiberty.html $TOP/$docdir/

cd $srcdir/gcc/doc || exit 1
# Something didn't work with generating gccinstall.html,
# so I skipped it
for x in cpp cppinternals gcc gccint ../f/g77 \
    ../ada/gnat-style ../ada/gnat_rm ../ada/gnat_ug_unx \
    ../ada/gnat_ug_vms ../ada/gnat_ug_vxw \
    ../ada/gnat_ug_wnt ../ada/gnat_ug; do
  ( cd `dirname $x` && $MKHTML -I ../doc/include `basename $x.texi` )
  cp -v $x.html $TOP/$docdir/
done

cd $TOP/$docdir
for x in *.dvi ; do 
  $DVIPS $x
  $DVIPDF $x
done

cd $TOP
if ! [ -d manifest ] ; then mkdir manifest; fi
echo "gcc$ver2.zip GCC-$version documentation" >manifest/gcc${ver2}d.ver
echo "g77$ver2.zip GCC-$version documentation (Fortran)" >manifest/g77${ver2}d.ver
echo "ada$ver2.zip GCC-$version documentation (Ada)" >manifest/ada${ver2}d.ver
rm -vf manifest/gcc${ver2}d.mft 
rm -vf manifest/g77${ver2}d.mft 
rm -vf manifest/ada${ver2}d.mft
touch manifest/gcc${ver2}d.mft 
touch manifest/g77${ver2}d.mft 
touch manifest/ada${ver2}d.mft

if [ -f $docdir/gpc.dvi ] ; then
    echo "gcc$ver2.zip GPC for GCC-$version documentation" >manifest/gpc${ver2}d.ver
    rm -vf manifset/gpc${ver2}d.mft
    touch manifest/gpc${ver2}d.mft
fi

for name in `( find manifest -type f -a -name "*d.*"; \
	       find gnudocs -type f ) | sort` ; do
      case $name in
          manifest/ada*d.*|*/gnat*.*) echo $name >>manifest/ada${ver2}d.mft ;;
          manifest/g77*d.*|*/g77*.*) echo $name >>manifest/g77${ver2}d.mft ;;
	  manifest/gpc*d.*|*/gpc*.*|*/GnuPascal.eps) echo $name >>manifest/gpc${ver2}d.mft ;;
	  */fastjar*|*/gcj*) echo skipping $name ;;
          *) echo $name >>manifest/gcc${ver2}d.mft ;; 	  
      esac
done      
rm -f ada${ver2}d.zip
rm -f g77${ver2}d.zip
rm -f gcc${ver2}d.zip
rm -f gpc${ver2}d.zip
echo "Creating ada${ver2}d.zip"
cat manifest/ada${ver2}d.mft | zip -9@ ada${ver2}d.zip
echo "Creating g77${ver2}d.zip"
cat manifest/g77${ver2}d.mft | zip -9@ g77${ver2}d.zip
echo "Creating gcc${ver2}d.zip"
cat manifest/gcc${ver2}d.mft | zip -9@ gcc${ver2}d.zip
if [ -f $docdir/gpc.dvi ] ; then
    echo "Creating gpc${ver2}d.zip"
    cat manifest/gpc${ver2}d.mft | zip -9@ gpc${ver2}d.zip
fi
    
    