#! /bin/sh

version=`bin/gcc.exe --version 2>&1`
full_version=${version}
case ${version} in 2*|3*) full_version=gcc-${version} ;;
		   *)     full_version=${version} ;; 
		   esac;
test -z ${version} && version=gcc-2.952
version_dir=lib/gcc-lib/djgpp/${version}
target=i386-pc-msdosdjgpp
for x in i[34567]86-pc-msdosdjgpp; do \
	test -f $x/include/_G_config.h && \
	export target=$x; 
done
	
source=`(cd ..; pwd)`
docdir=gnu/${full_version}

#STRIP=strip
STRIP=true

#############################################################################
#  With LFN enabled info files are installed with names that are not valid
#  for MS-DOS. Let's fix that
#############################################################################
for file in info/*.info*; do
	echo Processing $file
	case ${file} in
		*.info) cat $file | \
			awk 'substr($0,1,9)=="Indirect:" { active=1; } \
			     substr($0,1,10)=="Tag Table:" { active=0; } \
			     { if (active) gsub("info-","i"); \
		               print $0 }' > $file;
			;;
		*)	mv ${file} `echo $file | sed -e 's,[.]info-,.i,g'`
			;;
	esac
done
#############################################################################
#############################################################################

( cd bin && rm -f djgpp-gcc.exe c++.exe )

for file in bin/*.exe; do echo "Stripping ${file}"; ${STRIP} ${file}; done

( cd bin && ( mv g++.exe gpp.exe; ln -s gpp.exe g++.exe; ln -s gpp.exe c++.exe; ) )

( cd bin && mv c++filt.exe cxxfilt.exe )

cat bin/genclass | sed -e 's,[-]JDIR[/],-$DJDIR/,g' >bin/genclass

mv -v ${target}/include/_G_config.h lang/cxx/_G_config.h 
mv -v lang/cxx/GetOpt.h lang/cxx/_GetOpt.h

cat >lang/cxx/header.gcc << 'EOF'
String.h _String.h
Complex.h _Complex.h
Regex.h _Regex.h
iostreamP.h _iostreamP.h
stl_algobase.h stlalgobase.h
stl_hash_map.h stlhashmap.h
stl_hash_set.h stlhashset.h
stl_hashtable.h stlhashtable.h
stl_multiset.h stlmultiset.h
GetOpt.h _GetOpt.h
EOF

mv lang/cxx/std/valarray_meta.h lang/cxx/std/_valarray_meta.h 
cat >lang/cxx/std/header.gcc << 'EOF'
valarray_meta.h _valarray_meta.h
EOF

echo ".so man1/cccp.1" >man/man1/cpp.1
mv man/man1/g++.1 man/man1/gpp.1


test -d gnu || mkdir gnu
test -d ${docdir} || mkdir ${docdir}
for x in gcc gcc/cp gcc/objc gcc/f gcc/java gcc/ch \
	 libio libstdcxx libgpp libf2c libchill; do
	mkdir ${docdir}/${x}
done

for file in readme.DJGPP problems.txt gcc/bugs gcc/problems gcc/bugs \
	    gcc/copying gcc/news gcc/readme gcc/README-bugs gcc/cp/news \
	    libio/news libio/readme libstdcxx/news libgpp/news \
	    libgpp/readme gcc/objc/readme gcc/f/install gcc/f/news \
	    libf2c/readme libf2c/permission.netlib libf2c/readme.netlib \
	    gcc/ch/readme; do
		cp -v ${source}/${file} ${docdir}/${file}
done

makeinfo --no-split ${source}/libgpp/gxxFAQ.texi -o info/gxxFAQ.info
makeinfo --no-split ${source}/gcc/cp/gxxint.texi -o info/gxxint.info
cp ${source}/readme.libg++ ${docdir}/libgpp/readme.libgpp
cat ${source}/libgpp/g++FAQ.txt >${docdir}/gcc/cp/gxxFAQ.txt

for name in cc1 cc1chill cc1obj cc1plus f771 jc1; do
	file=lib/gcc-lib/djgpp/${version}/${name}.exe
	echo $file
	${STRIP} $file
	stubedit $file minstack=1536k
done
#---------------------------------------------------------------------
#  The number of parts of info files can change between versions.
#  Therefore let's update manifest files according the actual size
#---------------------------------------------------------------------	
for mft in `(cd manifest; echo *.mft;)`; do
	echo "Updating manifest/$mft"
	fl0=`cat manifest/$mft`
	inf_index=
	fl1=
	for x in $fl0; do
		case $x in *.info | *.inf) inf_index="$inf_index $x" ;; 
			   *.i*) ;;
			   *) fl1="$fl1 $x" ;;
		esac;
	done
	for inf in $inf_index; do
		n1=`echo $inf | sed -e 's,[.]info,.i,g' -e 's,[.]inf,.i,g'`
		for x in ${n1}*; do
			test -f $x && fl1="$fl1 $x"
		done
	done	
	( for x in $fl1; do echo $x; done ) | sort >manifest/$mft
done
#---------------------------------------------------------------------
#  If version is not 2.95.2 then it's necessary to update manifest files
#  according the actual version
#---------------------------------------------------------------------	
case $version in 2.952) ;; *)
	for file in manifest/*.mft; do
		cat $file | \
		sed -e "s,[/]2[.]952[/],/${version}/,g" \
		    -e "s,[/]gcc-2.952[/],/${full_version}/,g" \
		>$file;
	done
	;;
esac;
#---------------------------------------------------------------------	
#  Now create binary ZIP archives. We should have INFO-ZIP compiled
#  with DJGPP v2 on DOS path to succeed 
#---------------------------------------------------------------------	
for mft in `(cd manifest; echo *.mft)`; do
	rm -f err-${mft}
	flist=`cat manifest/${mft}`
	zip=`echo $mft | sed -e 's,[.]mft,.zip,g'`
	echo "Checking manifest/${mft}"
	for x in ${flist}; do
		test -f ${x} || ( echo '     ' ${x} is missing; touch err-${mft}; )
	done
	test -f err-${mft} || ( echo "Creating $zip..."; zip -9m $zip `cat manifest/$mft` )
	rm -f err-${mft}
done 
