/* Macros for taking apart, interpreting and processing file names.

   These are here because some non-Posix (a.k.a. DOSish) systems have
   the drive letter brain-damage at the beginning of an absolute file
   name, use forward- and back-slash in path names interchangeably, and
   some of them have case-insensitive file names.  */

#if defined(__MSDOS__) || defined(_WIN32)
#define IS_SLASH(c)     (((c) == '/') || ((c) == '\\'))
#define IS_ABSOLUTE(f)  ((IS_SLASH((f)[0]) || ((f)[0] && (f)[1] == ':')))
#define DOSISH_FILENAMES 1
#define MONOCASE_FILENAMES 1
#else
#define IS_SLASH(c)	((c) == '/')
#define IS_ABSOLUTE(f)	(IS_SLASH((f)[0]))
#define MONOCASE_FILENAMES 0
#endif

#if MONOCASE_FILENAMES
#define FILENAME_CMP(s1, s2)  strcasecmp(s1, s2)
#else
#define FILENAME_CMP(s1, s2)  strcmp(s1, s2)
#endif
