#! /bin/sh

version=2.19


ver1=$(echo $version | sed -e 's:\.::2g')
ver2=$(echo $version | sed -e 's:\.::g')
src_dir=$(cd .. && pwd)
build_dir=$src_dir/build.djg
doc_dir=gnu/binutl-$ver1
pkg_name=bnu${ver2}d

MAKEINFO=makeinfo

( cd $build_dir && make pdf ) || exit 1

mkdir -p $doc_dir || exit 1

for file in $(find $build_dir -name '*.pdf') ; do
    cp -v $file $doc_dir/
#    acroread -toPostScript $doc_dir/$(basename $file) $doc_dir/
done

( cd $build_dir/etc && make html )

cp -v $build_dir/etc/*.jpg $build_dir/etc/*.html $doc_dir/

$MAKEINFO --html --no-split \
    -I$src_dir/bfd/doc \
    $src_dir/bfd/doc/bfd.texinfo \
    -o $doc_dir/bfd.html

$MAKEINFO --html --no-split \
    -I$src_dir/bfd/doc \
    -I$src_dir/libiberty \
    -I$src_dir/binutils/doc \
    -I$src_dir/build.djg/binutils/doc \
    $src_dir/binutils/doc/binutils.texi \
    -o $doc_dir/binutils.html

$MAKEINFO --html --no-split \
    -I$src_dir/bfd/doc \
    -I$src_dir/libiberty \
    -I$src_dir/gas/doc \
    -I$src_dir/build.djg/gas/doc \
    $src_dir/gas/doc/as.texinfo \
    -o $doc_dir/as.html

$MAKEINFO --html --no-split \
    -I$src_dir/bfd/doc \
    -I$src_dir/libiberty \
    -I$src_dir/gprof \
    $src_dir/gprof/gprof.texi \
    -o $doc_dir/gprof.html

$MAKEINFO --html --no-split \
    -I$src_dir/bfd/doc \
    -I$src_dir/libiberty \
    -I$src_dir/ld \
    -I$src_dir/bfd/doc \
    $TOP/$src_dir/ld/ld.texinfo \
    -o $doc_dir/ld.html

for file in $src_dir/etc/*.jin; do
    cp -v $file $doc_dir/$(basename $file .jin).jpg
done

$MAKEINFO --html --no-split \
    -I$src_dir/libiberty \
    $src_dir/libiberty/libiberty.texi \
    -o $doc_dir/libiberty.html
 
echo "bnu${ver2}d.zip: GNU Binutils $version documentation (PDF, PS, HTML)" >manifest/$pkg_name.ver
touch -f manifest/$pkg_name.mft

( find gnu -type f ; find manifest -name $pkg_name'.*' ) |\
sort >manifest/$pkg_name.mft

cat manifest/$pkg_name.mft | zip -9@ $pkg_name.zip
