#include <ceditint.h>
#define Uses_TApplication
#define Uses_TStreamable
#define Uses_TWindow
#define Uses_TCEditWindow
#define Uses_TProgram
#define Uses_TDeskTop
#define Uses_TListBox
#include <ceditor.h>
#define Uses_SETAppVarious
#define Uses_TSetEditorApp
#include <setapp.h>
#include <dskwin.h>
#include <dskclose.h>
#include <edcollec.h>
#include <stdio.h>
#include <string.h>

extern TEditorCollection *edHelper;

TStreamable *TDskWinClosed::build()
{
 return new TDskWinClosed( streamableInit );
}

void TDskWinClosed::write( opstream& os )
{
 os.writeString(Name);
 SaveResume(resume,os);
}

void *TDskWinClosed::read( ipstream& is )
{
 char fileName[PATH_MAX];
 is.readString(fileName,PATH_MAX);
 Name=strdup(fileName);
 if (editorApp->deskTopVersion>=0x306)
    ReadResume(resume,is);
 else
   {
    TPoint origin,size,cursor;
    is >> origin >> size >> cursor;
    FillResumeWith(resume,origin,size,cursor);
   }
 ZOrder=-1;
 view=0;

 return this;
}

char *TDskWinClosed::GetText(char *dest, short maxLen)
{
 strcpy(dest,_("   Closed: "));
 return TDskWin::GetText(dest,Name,maxLen);
}

TDskWinClosed::TDskWinClosed(TCEditWindow *edw)
{
 Name=strdup(edw->editor->fileName);
 edw->FillResume(resume);
 type=dktClosed;
 CanBeSaved=1;
 view=0;
}

TDskWinClosed::~TDskWinClosed()
{
 delete Name;
}

int TDskWinClosed::GoAction(ccIndex i)
{
 TCEditWindow *ed;

 // Remove from the closed list
 edHelper->atRemove(i);
 edHelper->Closed--;
 // Lock the desktop to avoid lotz redraws
 TProgram::deskTop->lock();
 // Reopen the file
 ed=editorApp->openEditor(Name,True,&resume);
 // Indicate the new Top editor
 setFocusTo=(TView *)ed;
 focusChanged=True;

 return 1;
}

int TDskWinClosed::DeleteAction(ccIndex i)
{
 edHelper->atRemove(i);
 edHelper->Closed--;

 return 1;
}

