/*

  TEST4.C tilemap example --- Copyright 1999, Henrik Stokseth.

  This example shows how to animate a tilemap.

*/

#include <allegro.h>
#include <stdio.h>
#include "tilemap.h"
#include "sample.h"

// declare & perhaps initialize some variables
BITMAP   *screenbuffer;
TILEMAP  *mymap;
DATAFILE *mydata;
int      layer, x = 0, y = 0;
int      wanttoexit = FALSE;

void animate()
{
  int sprite;

  // animates the tile at the coordinates (2,2) and (4,4) on layer 0
  sprite = get_sprite_number(mymap, 0, 2, 2);
  if(sprite == RLE_FOREST) set_sprite_number(mymap, 0, 2, 2, RLE_GRASS);
  else set_sprite_number(mymap, 0, 2, 2, RLE_FOREST);
  sprite = get_sprite_number(mymap, 0, 4, 4);
  if(sprite == RLE_FOREST) set_sprite_number(mymap, 0, 4, 4, RLE_GRASS);
  else set_sprite_number(mymap, 0, 4, 4, RLE_FOREST);
}
END_OF_FUNCTION(animate);

int main()
{
  // initialize allegro
  allegro_init();
  install_keyboard();
  install_timer();
  set_gfx_mode(GFX_AUTODETECT, 320, 200, 0, 0);
  screenbuffer = create_bitmap(SCREEN_W, SCREEN_H);

  // load map, palette and sprites
  mydata = load_datafile("sample.dat");
  mymap  = load_tilemap("sample.map");

  correct_tilemap(mymap, mydata);

  // if there are some errors with the loading, quit with a message
  if(!mymap || !mydata)
  {
    set_gfx_mode(GFX_TEXT, 80, 25, 0, 0);
    printf("error loading files ...");
    exit(1);
  }

  // initialize animation
  LOCK_FUNCTION(animate);
  LOCK_VARIABLE(mymap);
  LOCK_VARIABLE(mymap->data);
  install_int_ex(animate, BPS_TO_TIMER(3));

  // view tilemap
  set_palette(mydata[PAL_GAME].dat);
  while(!wanttoexit)
  {
    // display tilemap
    clear(screenbuffer);
    for(layer=0; layer < mymap->layers; layer++)
    {
      draw_tilemap_layer(screenbuffer, mydata, mymap, layer, x, y);
    }
    blit(screenbuffer, screen, 0, 0, 0, 0, SCREEN_W, SCREEN_H);
    
    // check user input
    if(key[KEY_UP])    y++;
    if(key[KEY_DOWN])  y--;
    if(key[KEY_LEFT])  x++;
    if(key[KEY_RIGHT]) x--;
    if(key[KEY_ESC])   wanttoexit = TRUE;
  }

  // flush keyboard buffer
  clear_keybuf();
  
  // shutdown animation
  remove_int(animate);

  // unload map and sprites
  destroy_tilemap(mymap);
  destroy_bitmap(screenbuffer);
  unload_datafile(mydata);

  return 0;
}

