/* Copyright (C) 1996,1997,1998,1999 by Salvador E. Tropea (SET),
   see copyrigh file for details */
#include <signal.h>
#include <unistd.h>
#include <ced_inte.h>
#ifdef __DJGPP__
#include <io.h>
#else
#include <stdio.h>
#endif

extern void suspend_keyboard();

extern void DumpEditors(void);

static void EditorSignal(int num)
{
 static char msg[] = "Panic! got a signal, quiting\r\n";
 static char msg1[] ="You asked for it, so quiting\r\n";
 static char msg2[] ="That's from SET's editor " TCEDITOR_VERSION_STR "\r\n";

 // No signals now
 signal(SIGABRT, SIG_IGN);
 signal(SIGFPE,  SIG_IGN);
 signal(SIGILL,  SIG_IGN);
 signal(SIGSEGV, SIG_IGN);
 signal(SIGTERM, SIG_IGN);
 signal(SIGKILL, SIG_IGN);
 signal(SIGQUIT, SIG_IGN);
 signal(SIGINT,  SIG_IGN);

#ifdef __DJGPP__
 _write(STDERR_FILENO,num==SIGINT ? msg1 : msg,sizeof(msg)-1);
 _write(STDERR_FILENO,msg2,sizeof(msg2)-1);
#else
 write(STDERR_FILENO,num==SIGINT ? msg1 : msg,sizeof(msg)-1);
 write(STDERR_FILENO,msg2,sizeof(msg2)-1);
#endif
 DumpEditors();

#ifndef __DJGPP__
 suspend_keyboard();
#endif
 // Generate the signal
 signal(num, SIG_DFL);
 raise(num);
}

void InitEditorSignals(void)
{
 signal(SIGABRT, EditorSignal);
 signal(SIGFPE,  EditorSignal);
 signal(SIGILL,  EditorSignal);
 signal(SIGSEGV, EditorSignal);
 signal(SIGTERM, EditorSignal);
 signal(SIGKILL, EditorSignal);
 signal(SIGQUIT, EditorSignal);
 signal(SIGINT,  EditorSignal);
}

