/* Project SWORD
   V2.0

   SubSystem : Screen graphics management
   File      : Src/Graphics/Desktop.CC
   Author    : Eric NICOLAS
   Overview  : TDesktop object
   UpDate    : Oct 22, 1995

** Copyright (C) 1993,1995 The SWORD Group
**
** This file is distributed under the terms listed in the document
** "copying.en". A copy of "copying.en" should accompany this file.
** if not, a copy should be available from where this file was obtained.
** This file may not be distributed without a verbatim copy of "copying.en".
**
** This file is distributed WITHOUT ANY WARRANTY; without even the implied
** warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
*/

#include "Common/Common.H"
#include "Mecanism/Mecanism.H"
#include "Graphics/Graphics.H"

short RegTDesktop;
char *IdentTDesktop = "TDesktop";

TDesktop *Desktop;

// Constructors

TDesktop::TDesktop() : TZone(NoClip)
{ Init();
}

TDesktop::~TDesktop(void)
{ if (!Destroyed)
  { Done();
    Destroyed=TRUE;
  }
}

void TDesktop::Init(void)
{ Register=RegTDesktop;
  Ident=IdentTDesktop;
  SetStatus(sfSelected);
  Desktop=this;
  ToDrawZones=new TScreenZone();
  // Demande au dbut le trac de tout l'cran
  Invalidate();
}

// Events

boolean TDesktop::AutoEvt(void)
{ ShowDrawingNow();
  return FALSE;
}

boolean TDesktop::HandleCommand(long Command, char , short , long , void *)
{ switch(Command)
  { case cmReDrawScreen :
      Invalidate();
      ShowDrawingNow();
      return TRUE;
  }
  return FALSE;
}

// Graphics

void TDesktop::ShowDrawingNow(void)
{ TScreenZone *SZ;
  // Limite au maximum le nombre de zones  retracer en fusionnant
  // Evntuellement des zones
  ToDrawZones->RegroupZones();
  // Trace toutes les zones
  SZ=ToDrawZones->Son();
  while(SZ!=NULL)
  { DoDraw(SZ->Where);
    SZ=SZ->Next();
  }
  // Efface l'ensemble des zones a retracer
  delete ToDrawZones;
  ToDrawZones=new TScreenZone();
}

void TDesktop::Insert(TAtom *A)
{ // Insre l'objet
  TZone::Insert(A);
  // Met  jour le systme de recouvrement
  UpdateClipZone();
  // Demande l'affichage de l'objet
  ((TZone*)A)->Invalidate();
  // Met a jour le systeme de positionnement de souris sur les objets
  SetCommand(cmUpdateMouse);
}

void TDesktop::UpdateClipZone(void)
{ TWindow *W=(TWindow*)Son();
  while(W!=NULL)
  { W->CalculateClip();
    W=W->Next();
  }
}

void TDesktop::Invalidate(TRect& What)
{ ToDrawZones->Insert(new TScreenZone(What));
}

void TDesktop::Invalidate(void)
{ delete ToDrawZones;
  ToDrawZones=new TScreenZone();
  ToDrawZones->Insert(new TScreenZone(NoClip));
}

TZone* TDesktop::GetActiveZone(void)
{ TZone *Z=Son();
  while(!Z->GetStatus(sfSelected))
    Z=Z->Next();
  return Z;
}
