/* Project SWORD
   V2.0

   SubSystem : Mathematical toolbox
   File      : Include/ToolBox/Math/Matrix.H
   Author    : Eric NICOLAS
   Overview  : Variable size matrix arithmetics
   UpDate    : May 18, 1995

** Copyright (C) 1993,1995 The SWORD Group
**
** This file is distributed under the terms listed in the document
** "copying.en". A copy of "copying.en" should accompany this file.
** if not, a copy should be available from where this file was obtained.
** This file may not be distributed without a verbatim copy of "copying.en".
**
** This file is distributed WITHOUT ANY WARRANTY; without even the implied
** warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
*/

#ifndef _TOOLBOX_MATH_MATRIX_H_
#define _TOOLBOX_MATH_MATRIX_H_

extern int MatrixDefaultSizeI;
extern int MatrixDefaultSizeJ;

// Rem : Rows    are defined by the first index (I)
//       Columns are defined by the second index (J)

struct TMatrix
{ // Datas
  int       SizeI,SizeJ;
  complex  *Tabl;
  // Constructors / Destructor
  TMatrix(int eSizeI=MatrixDefaultSizeI, int eSizeJ=MatrixDefaultSizeJ);
  TMatrix(TMatrix& M);
  virtual ~TMatrix();
           void Reset(void);
  // Using vectors
  TMatrix  operator=(TMatrix& M);
  complex& operator()(int I, int J);
  // Operations on matrixes
  TMatrix  operator+(TMatrix& M);
  TMatrix  operator+=(TMatrix& M);
  TMatrix  operator-(TMatrix& M);
  TMatrix  operator-=(TMatrix& M);
  TMatrix  operator*(TMatrix& M);
  TMatrix  operator*=(TMatrix& M);
  friend   TMatrix  T(TMatrix& M);
  friend   complex  Det(TMatrix& M);
  friend   TMatrix  Inv(TMatrix& M);
/*  TMatrix  operator/(TMatrix& V);
  TMatrix  operator/=(TMatrix& V);*/
  // Operations between matrixes and complexes
  friend   TMatrix  operator*(TMatrix& M, complex  C);
  friend   TMatrix  operator*(complex  C, TMatrix& M);
	       TMatrix  operator*=(complex C);
  friend   TMatrix  operator/(TMatrix& M, complex  C);
  friend   TMatrix  operator/(complex  C, TMatrix& M);
	        TMatrix  operator/=(complex C);
  // Operation between matrix and vector
           TVector  operator*(TVector& V);
           TVector  SolveSystem(TVector& Constant);
  // Acces to Matrix values with vectors
  void SetColumn(int J, TVector& V);
  void SetRow(int I, TVector& V);
  TVector Column(int J);
  TVector Row(int I);
  // Operations on Rows and Columns
  void ExchangeRows(int I1, int I2);              // Row(I1) <-> Row(I2)
  void ExchangeColumns(int J1, int J2);           // Column(I1) <-> Column(I2)
  void MultAddRow(int I1, int I2, complex C);     // Row(I2)=Row(I2)+C*Row(I1)
  void MultAddColumn(int J1, int J2, complex C);  // Column(J2=Column(J2)+C*Column(J1)
  void DivideRow(int I, complex C);               // Row(I)=Row(I)/C
  void DivideColumn(int J, complex C);            // Column(I)=Column(I)/C
};

// Inline functions

inline complex &TMatrix::operator()(int I, int J)
{ if (I<0)      { LastError=MError_Matrix_OutOfSize; I=0;       }
  if (I>=SizeI) { LastError=MError_Matrix_OutOfSize; I=SizeI-1; }
  if (J<0)      { LastError=MError_Matrix_OutOfSize; J=0;       }
  if (J>=SizeJ) { LastError=MError_Matrix_OutOfSize; J=SizeJ-1; }
  return Tabl[J+I*SizeJ];
}

#endif // _TOOLBOX_MATH_MATRIX_H_
