/* Project SWORD
   V2.0

   SubSystem : ToolBox for 3D graphics
   File      : Include/ToolBox/Graph3D/Facet.H
   Author    : Eric NICOLAS
   Overview  : Object TFacet
   UpDate    : Mar 18, 1995

** Copyright (C) 1993,1995 The SWORD Group
**
** This file is distributed under the terms listed in the document
** "copying.en". A copy of "copying.en" should accompany this file.
** if not, a copy should be available from where this file was obtained.
** This file may not be distributed without a verbatim copy of "copying.en".
**
** This file is distributed WITHOUT ANY WARRANTY; without even the implied
** warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
*/

#ifndef _TOOLBOX_GRAPH3D_FACET_H_
#define _TOOLBOX_GRAPH3D_FACET_H_

struct TFacet
{ protected:
    TPoint3D *_P1,*_P2,*_P3;
  public:
    // Constructors
    TFacet();
    TFacet(TPoint3D* P1, TPoint3D* P2, TPoint3D* P3);
    TFacet(TFacet& F);
    // Acces to datas
            TPoint3D& P1();
            TPoint3D& P2();
            TPoint3D& P3();
    // Informations about facet
            TPoint3D N();
            TPoint3D Barycenter();
};

// Inline functions

inline TPoint3D &TFacet::P1()
{ return *_P1;
}

inline TPoint3D &TFacet::P2()
{ return *_P2;
}

inline TPoint3D &TFacet::P3()
{ return *_P3;
}

#endif // _TOOLBOX_GRAPH3D_FACET_H_
