/* Project SWORD
   V2.0

   SubSystem : Screen graphics management
   File      : Include/Graphics/ScrZone.H
   Author    : Eric NICOLAS
   Overview  : TScreenZone object
   UpDate    : Oct 22, 1995

** Copyright (C) 1993,1995 The SWORD Group
**
** This file is distributed under the terms listed in the document
** "copying.en". A copy of "copying.en" should accompany this file.
** if not, a copy should be available from where this file was obtained.
** This file may not be distributed without a verbatim copy of "copying.en".
**
** This file is distributed WITHOUT ANY WARRANTY; without even the implied
** warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
*/

#ifndef _GRAPHICS_SCRZONE_H_
#define _GRAPHICS_SCRZONE_H_

struct TScreenZone : TAtom
{ TRect Where;
  // Constructor / Destructor
          TScreenZone(int X1, int Y1, int X2, int Y2);
          TScreenZone(TRect& W);
          TScreenZone();
  virtual ~TScreenZone(void);
  // Linked lists
          TScreenZone *Next();
          TScreenZone *Son();
  //
          void         RegroupZones();
          int          Clip(TScreenZone *SZ, TRect& RZ);
};

// Inline functions

inline TScreenZone *TScreenZone::Next(void)
{ return (TScreenZone*)(TAtom::_Next);
}

inline TScreenZone *TScreenZone::Son(void)
{ return (TScreenZone*)(TAtom::_Son);
}

#endif // _GRAPHICS_SCRZONE_H_
