/**
 ** TEST.H
 **
 **  Copyright (C) 1992, Csaba Biegl
 **    820 Stirrup Dr, Nashville, TN, 37221
 **    csaba@vuse.vanderbilt.edu
 **
 **  This file is distributed under the terms listed in the document
 **  "copying.cb", available from the author at the address above.
 **  A copy of "copying.cb" should accompany this file; if not, a copy
 **  should be available from where this file was obtained.  This file
 **  may not be distributed without a verbatim copy of "copying.cb".
 **  You should also have received a copy of the GNU General Public
 **  License along with this program (it is in the file "copying");
 **  if not, write to the Free Software Foundation, Inc., 675 Mass Ave,
 **  Cambridge, MA 02139, USA.
 **
 **  This program is distributed in the hope that it will be useful,
 **  but WITHOUT ANY WARRANTY; without even the implied warranty of
 **  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 **  GNU General Public License for more details.
 **/


#ifndef _TEST_H_
#define _TEST_H_

#include <grx.h>
#include <mousex.h>
#include <stdio.h>
#include <stdlib.h>

#ifdef __TURBOC__
# undef  random
# define random() rand()
# include <conio.h>
#endif

#define TESTFUNC(name) \
    void name(void); \
    void (*testfunc)(void) = name; \
    void name(void)

extern void (*testfunc)(void);

char exit_message[2000] = { "" };

int Argc;
char **Argv;

void main(int argc,char **argv)
{
	int x = 0;
	int y = 0;
	int c = 0;

	Argc = argc - 1;
	Argv = argv + 1;
	if((Argc >= 2) &&
	   (sscanf(Argv[0],"%d",&x) == 1) && (x >= 320) &&
	   (sscanf(Argv[1],"%d",&y) == 1) && (y >= 200)) {
	    Argc -= 2;
	    Argv += 2;
	    if((Argc > 0) && (sscanf(Argv[0],"%d",&c) == 1) && (c >= 2)) {
		Argc--;
		Argv++;
	    }
	}
	if(c >= 2)
	    GrSetMode(GR_width_height_color_graphics,x,y,c);
	else if((x >= 320) && (y >= 200))
	    GrSetMode(GR_width_height_graphics,x,y);
	else GrSetMode(GR_default_graphics);
	(*testfunc)();
	GrSetMode(GR_default_text);
	puts(exit_message);
	exit(0);
}

#define XP(x)	(int)((((long)(x) * (long)xsize) / 100L) + xpos)
#define YP(y)	(int)((((long)(y) * (long)ysize) / 100L) + ypos)

void drawing(int xpos,int ypos,int xsize,int ysize,int fg,int bg)
{
	int ii;

	if(bg != GrNOCOLOR) {
	    GrFilledBox(xpos,ypos,xpos+xsize-1,ypos+ysize-1,bg);
	}
	GrLine(XP(10),YP(10),XP(40),YP(40),fg);
	GrLine(XP(40),YP(10),XP(10),YP(40),fg);
	GrLine(XP(35),YP(10),XP(65),YP(40),fg);
	GrLine(XP(35),YP(40),XP(65),YP(10),fg);
	GrLine(XP(70),YP(10),XP(90),YP(40),fg);
	GrLine(XP(70),YP(40),XP(90),YP(10),fg);
	for(ii = 0; ii < 5; ii++) {
	    GrBox(XP(70+2*ii),YP(10+3*ii),XP(90-2*ii),YP(40-3*ii),fg);
	}
	GrFilledBox(XP(10),YP(50),XP(60),YP(90),fg);
	GrBox(XP(70),YP(50),XP(90),YP(90),fg);
	for(ii = 0; ii < 100; ii++) {
	    GrPlot(XP((random() % 20) + 70),YP((random() % 40) + 50),fg);
	}
}


#endif /* _TEST_H_ */

