/**
 ** DUMPTEXT.C
 **
 **  Copyright (C) 1992, Csaba Biegl
 **    820 Stirrup Dr, Nashville, TN, 37221
 **    csaba@vuse.vanderbilt.edu
 **
 **  This file is distributed under the terms listed in the document
 **  "copying.cb", available from the author at the address above.
 **  A copy of "copying.cb" should accompany this file; if not, a copy
 **  should be available from where this file was obtained.  This file
 **  may not be distributed without a verbatim copy of "copying.cb".
 **  You should also have received a copy of the GNU General Public
 **  License along with this program (it is in the file "copying");
 **  if not, write to the Free Software Foundation, Inc., 675 Mass Ave,
 **  Cambridge, MA 02139, USA.
 **
 **  This program is distributed in the hope that it will be useful,
 **  but WITHOUT ANY WARRANTY; without even the implied warranty of
 **  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 **  GNU General Public License for more details.
 **/

#include "grx.h"
#include "libgrx.h"
#include "grxfont.h"
#include "clipping.h"

#define  FAST	0x04

void GrDumpText(int col,int row,int wdt,int hgt,GrTextRegion *r)
{
	GrFont *f = CHECK_FONT(r->txr_font);
	GrColorTableP fgcp,bgcp;
	char *ptr,*bpt;
	int xtmp,ytmp;
	int xpos,ypos;
	int chrw,chrh;
	int fgc,bgc;
	int offs,size;
	int minc,maxc;
	int type,attr;
	int xchr,chr;
	int chrsize;
	int underline = 0;
	int fast;
	MOUSE_FLAG;

	if((f == NULL) || !f->fnt_isfixed) return;
	if((col >= r->txr_width) || (row >= r->txr_height)) return;
	if(col < 0) { wdt += col; col = 0; }
	if(row < 0) { hgt += row; row = 0; }
	if(wdt > (r->txr_width  - col)) wdt = r->txr_width  - col;
	if(hgt > (r->txr_height - row)) hgt = r->txr_height - col;
	if((wdt <= 0) || (hgt <= 0)) return;
	chrw = f->fnt_width;
	chrh = f->fnt_height;
	xpos = r->txr_xpos + (chrw * col);
	ypos = r->txr_ypos + (chrh * row);
	xtmp = xpos + (chrw * wdt) - 1;
	ytmp = ypos + (chrh * hgt) - 1;
	if((xpos > _GrHiX) || (xtmp <= _GrLoX)) return;
	if((ypos > _GrHiY) || (ytmp <= _GrLoY)) return;
	while(xpos < _GrLoX) { if(--wdt == 0) return; xpos += chrw; col++; }
	while(ypos < _GrLoY) { if(--hgt == 0) return; ypos += chrh; row++; }
	while(xtmp > _GrHiX) { if(--wdt == 0) return; xtmp -= chrw; }
	while(ytmp > _GrHiY) { if(--hgt == 0) return; ytmp -= chrh; }
	type = r->txr_chrtype;
	fast = (r->txr_backup != NULL) ? FAST : 0;
	switch(type) {
	  case GR_WORD_TEXT:
	    size = sizeof(short);
	    fgc  = r->txr_fgcolor.v;
	    bgc  = r->txr_bgcolor.v;
	    if(fgc & GR_UNDERLINE_TEXT) {
		underline = f->fnt_undwidth;
		fgc &= ~GR_UNDERLINE_TEXT;
	    }
	    break;
	  case GR_ATTR_TEXT:
	    attr = (-1);
	    size = sizeof(short);
	    fgcp = r->txr_fgcolor.p;
	    bgcp = r->txr_bgcolor.p;
	    break;
	  default:
	    size = sizeof(char);
	    fgc  = r->txr_fgcolor.v;
	    bgc  = r->txr_bgcolor.v;
	    if(fgc & GR_UNDERLINE_TEXT) {
		underline = f->fnt_undwidth;
		fgc &= ~GR_UNDERLINE_TEXT;
	    }
	    break;
	}
	offs = (row * r->txr_lineoffset) + (col * size);
	ptr  = r->txr_buffer + offs;
	bpt  = r->txr_backup + offs;
	offs = r->txr_lineoffset - (wdt * size);
	minc = f->fnt_minchar;
	maxc = f->fnt_maxchar;
	chrsize = FFP(f)->ff_chrsize;
	MOUSE_BLOCK(CURC,
	    xpos,ypos,
	    (xpos + (chrw * wdt) - 1),
	    (ypos + (chrh * hgt) - 1)
	);
	for( ; --hgt >= 0; ypos += chrh,ptr += offs,bpt += offs) {
	    xtmp = xpos;
	    ytmp = wdt;
	    for( ; --ytmp >= 0; xtmp += chrw,ptr += size,bpt += size) {
		switch(type) {
		  case GR_WORD_TEXT:
		    chr = *((unsigned short *)ptr);
		    if(!fast) break;
		    if(chr == *((unsigned short *)bpt)) continue;
		    *((unsigned short *)bpt) = chr;
		    if(chr == ' ') chr = (-1);
		    break;
		  case GR_ATTR_TEXT:
		    xchr = *((unsigned short *)ptr);
		    if(fast && (xchr == *((unsigned short *)bpt))) continue;
		    chr = xchr & 0xff;
		    if(attr != (xchr &= 0xff00)) {
			fgc  = (xchr >> 8)  & 0x0f;
			bgc  = (xchr >> 12) & 0x07;
			fgc  = GR_CTABLE_COLOR(fgcp,fgc);
			bgc  = GR_CTABLE_COLOR(bgcp,bgc);
			underline = (xchr & 0x8000) ? f->fnt_undwidth : 0;
			attr = xchr;
		    }
		    if(fast && (chr == ' ')) chr = (-1);
		    break;
		  default:
		    chr = *((unsigned char *)ptr);
		    if(!fast) break;
		    if(chr == *((unsigned char *)bpt)) continue;
		    *((unsigned char *)bpt) = chr;
		    if(chr == ' ') chr = (-1);
		    break;
		}
		if((chr > maxc) || ((chr -= minc) < 0)) {
		    _GrSetPixBlock(PIXEL_ADDR(xtmp,ypos),
			bgc,
			chrw,(chrh - underline)
		    );
		}
		else {
		    _GrDrawChar(PIXEL_ADDR(xtmp,ypos),
			chrw,(chrh - underline),
			FFP(f)->ff_bits + (chr * chrsize),
			fgc,bgc
		    );
		}
		if(underline > 0) {
		    _GrSetPixBlock(PIXEL_ADDR(xtmp,(ypos + chrh - underline)),
			fgc,
			chrw,underline
		    );
		}
	    }
	}
	MOUSE_UNBLOCK();
}

void GrDumpTextRegion(GrTextRegion *r)
{
	GrDumpText(0,0,r->txr_width,r->txr_height,r);
}

void GrDumpChar(int chr,int col,int row,GrTextRegion *r)
{
	register int offs;

	if((col < 0) || (col >= r->txr_width))  return;
	if((row < 0) || (row >= r->txr_height)) return;
	switch(r->txr_chrtype) {
	  case GR_WORD_TEXT:
	  case GR_ATTR_TEXT:
	    offs = (row * r->txr_lineoffset) + (col * sizeof(short));
	    *((short *)(r->txr_buffer + offs)) = chr;
	    break;
	  default:
	    offs = (row * r->txr_lineoffset) + (col * sizeof(char));
	    *((char *)(r->txr_buffer + offs)) = chr;
	    break;
	}
	GrDumpText(col,row,1,1,r);
}

