/**********************************************************************
 *  
 *  NAME:           mailbox.cpp
 *  
 *  DESCRIPTION:    class MBox (mailbox) implementation
 *  
 *  copyright (c) 1991 J. Alan Eldridge
 * 
 *  M O D I F I C A T I O N   H I S T O R Y
 *
 *  when        who                 what
 *  -------------------------------------------------------------------
 *  05/09/91    J. Alan Eldridge    broke out of task.cpp
 *  
 *  11/14/91    jae                 now class MBoxBase member functions
 *                                  are here, and the constructors for
 *                                  MBox & MBoxPri are inline in task.h
 *
 *********************************************************************/

#include    "aedef.h"
#include    "task.h"

//------------------------------------------------------------
//  ********** CLASS MBOX MEMBER FUNCTIONS **********
//------------------------------------------------------------

//------------------------------------------------------------
//  MBoxBase::send()    --  wait for box to be free, then put msg
//  NOTE: sender doesn't return until message is picked up
//------------------------------------------------------------

int
MBoxBase::send(void *msg, int n, clock_t msec)
{
    if (!s_send->wait(msec))
        return 0;
    m_len = n;
    m_msg = msg;
    s_recv->signal(0);
    return s_pickup.wait();
}

//------------------------------------------------------------
//  MBoxBase::recv()    --  wait for a message, then retrieve it
//  and wake up the sender... return -1 if timed out, otherwise
//  return length of data
//------------------------------------------------------------

int
MBoxBase::recv(void *msg, clock_t msec)
{
    int len;
    
    if (!s_recv->wait(msec))
        return 0;
    memcpy(msg, m_msg, len = m_len);
    s_send->signal(0);
    s_pickup.signal();
    return len;
}
