/**********************************************************************
 * 
 * pckeybd.h
 * 
 * Copyright (c) 1988,89,90 J. Alan Eldridge
 * 
 * PC key defs for new kbd mapping scheme
 * 
 * WARNING: CHARACTERS ARE INTS, NOT CHARS!
 * 
 *********************************************************************/

#ifndef __PCKEYBD__
#define __PCKEYBD__

/* null character */

#define K_NULL      0

/* common keys */

#define K_ESC       27
#define K_TAB       '\t'
#define K_NL        '\n'
#define K_CR        '\r'
#define K_BACK      '\b'
#define K_SPACE     ' '

/* control keys */

#define _K_CTL(c)   ((c) - '@')

#define K_CTL_A     _K_CTL('A')
#define K_CTL_B     _K_CTL('B')
#define K_CTL_C     _K_CTL('C')
#define K_CTL_D     _K_CTL('D')
#define K_CTL_E     _K_CTL('E')
#define K_CTL_F     _K_CTL('F')
#define K_CTL_G     _K_CTL('G')
#define K_CTL_H     _K_CTL('H')
#define K_CTL_I     _K_CTL('I')
#define K_CTL_J     _K_CTL('J')
#define K_CTL_K     _K_CTL('K')
#define K_CTL_L     _K_CTL('L')
#define K_CTL_M     _K_CTL('M')
#define K_CTL_N     _K_CTL('N')
#define K_CTL_O     _K_CTL('O')
#define K_CTL_P     _K_CTL('P')
#define K_CTL_Q     _K_CTL('Q')
#define K_CTL_R     _K_CTL('R')
#define K_CTL_S     _K_CTL('S')
#define K_CTL_T     _K_CTL('T')
#define K_CTL_U     _K_CTL('U')
#define K_CTL_V     _K_CTL('V')
#define K_CTL_W     _K_CTL('W')
#define K_CTL_X     _K_CTL('X')
#define K_CTL_Y     _K_CTL('Y')
#define K_CTL_Z     _K_CTL('Z')

#define K_CTL_BKSLASH   _K_CTL('\\')

/* modifier bits (in high byte) */

#define K_EXT       0x0100
#define K_ALT       0x0200 
#define K_CTL       0x0400
#define K_SHIFT     0x0800
#define K_USER      0x1000

/* shift tab key (backtab) */

#define K_BACKTAB   (K_TAB | K_EXT | K_SHIFT)

/* function keys */

#define K_F1        (130 | K_EXT)
#define K_F2        ((K_F1) + 1)
#define K_F3        ((K_F1) + 2)
#define K_F4        ((K_F1) + 3)
#define K_F5        ((K_F1) + 4)
#define K_F6        ((K_F1) + 5)
#define K_F7        ((K_F1) + 6)
#define K_F8        ((K_F1) + 7)
#define K_F9        ((K_F1) + 8)
#define K_F10       ((K_F1) + 9)
#define K_F11       ((K_F1) + 10)
#define K_F12       ((K_F1) + 11)

/* cursor movement keys */

#define K_HOME      (150 | K_EXT)
#define K_UP        (151 | K_EXT)
#define K_PGUP      (152 | K_EXT)
#define K_LEFT      (153 | K_EXT)
#define K_RIGHT     (154 | K_EXT)
#define K_END       (155 | K_EXT)
#define K_DOWN      (156 | K_EXT)
#define K_PGDN      (157 | K_EXT)

/* insert and delete */

#define K_INS       (158 | K_EXT)
#define K_DEL       (159 | K_EXT)

/* print screen key */

#define K_PRTSC     (160 | K_EXT)

/* unknown key */

#define K_UNKNOWN   (255 | K_EXT)

/* impossible value */

#define K_ILLEGAL   -1

#endif  /* __PCKEYBD__ */

