/*
    djasync.h -- prototypes for async interface routines

    created by j. alan eldridge 09/04/92
*/    

#ifndef DJASYNC_H
#define DJASYNC_H

#define COM1    0
#define COM2    1    

#ifdef __cplusplus
extern "C" {
#endif
    
int     async_init(int port);
int     async_tx(int port, char c);
int     async_ready(int port);
int     async_rx(int port);
int     async_cnt(int port);
int     async_overflow(int port);
void    async_flush(int port);

int     kb_ready(void);
int     kb_rx(void);

#ifdef __cplusplus
}

class DJAsync {
    private:
        int ok;    
        int port;
    public:
            DJAsync(int p = COM1)
                { ok = async_init(port = p); }
        int     Ok()
                    { return ok; }
        int     Tx(char c)
                    { return ok ? async_tx(port,c) : -1; }
        int     Rx()
                    { return ok ? async_rx(port) : -1; }
        int     Rdy()
                    { return ok ? async_ready(port) : 0; }
        int     Cnt()
                    { return ok ? async_cnt(port) : -1; }
        int     Ovr()
                    { return ok ? async_overflow(port) : 0; }
        void    Flush()
                    { if (ok) async_flush(port); }
};

#endif
    
#endif
