/* This is file BIN2BYTE.C */
/*
** Copyright (C) 1993 DJ Delorie, 24 Kirsten Ave, Rochester NH 03867-2954
**
** This file is distributed under the terms listed in the document
** "copying.dj", available from DJ Delorie at the address above.
** A copy of "copying.dj" should accompany this file; if not, a copy
** should be available from where this file was obtained.  This file
** may not be distributed without a verbatim copy of "copying.dj".
**
** This file is distributed WITHOUT ANY WARRANTY; without even the implied
** warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
*/

#include <stdio.h>
#include <fcntl.h>
#include <sys/stat.h>

main(int argc, char **argv)
{
  int f = open(argv[1], O_RDONLY|O_BINARY);
  FILE *of = fopen(argv[3], "w");
  unsigned char buf[4096];
  int rbytes;
  int col=0, i;
  if (argc < 4)
  {
    printf("usage: bin2byte infile symname outfile\n");
    exit(1);
  }
  fprintf(of, "unsigned char %s[] = {\n", argv[2]);
  while ((rbytes = read(f, buf, 4096)) > 0)
  {
    for (i=0; i<rbytes; i++)
    {
      fprintf(of, "%d,", buf[i]);
      if (col++ == 32)
      {
        fprintf(of, "\n");
        col = 0;
      }
    }
  }
  fprintf(of, "};\n");
  fclose(of);
}
