#include "emu.h"
#include "rmov.h"
#include "compare.h"

void emu_55()
{
  if (empty())
    return;
  if (modrm > 0277)
  {
    // fucomp st(i)
    if (empty(modrm&7))
    {
      setcc(SW_C3|SW_C2|SW_C0);
      return;
    }
    int c = compare(st(), st(modrm&7));
    st().tag = TW_E;
    top++;
    int f;
    if (c & COMP_SNAN)
    {
      exception(EX_I);
      f = SW_C3 | SW_C2 | SW_C0;
    }
    else
      switch (c)
      {
        case COMP_A_LT_B:
          f = SW_C0;
          break;
        case COMP_A_EQ_B:
          f = SW_C3;
          break;
        case COMP_A_GT_B:
          f = 0;
          break;
        case COMP_NOCOMP:
          f = SW_C3 | SW_C2 | SW_C0;
          break;
      }
    setcc(f);
    
  }
  else
  {
    emu_bad();
  }
}
