#include "emu.h"
#include "const.h"

static void fld_const(reg &c)
{
  if (full())
    return;
  top--;
  r_mov(c, st());
  status_word &= ~SW_C1;
}

void fld1()
{
  fld_const(CONST_1);
}

void fldl2t()
{
  fld_const(CONST_L2T);
}

void fldl2e()
{
  fld_const(CONST_L2E);
}

void fldpi()
{
  fld_const(CONST_PI);
}

void fldlg2()
{
  fld_const(CONST_LG2);
}

void fldln2()
{
  fld_const(CONST_LN2);
}

void fldz()
{
  fld_const(CONST_Z);
}

FUNC emu_15_table[] = {
  fld1, fldl2t, fldl2e, fldpi, fldlg2, fldln2, fldz, emu_bad
};

void emu_15()
{
  if (modrm > 0277)
  {
    (emu_15_table[modrm&7])();
  }
  else
  {
    // fldcw
    control_word = *(short *)get_modrm();
  }
}
