#ifndef _task_h_
#define _task_h_

#include <setjmp.h>

typedef int (TaskProc)(int, void*);


class Task {
  public:
  Task *prev; // links into run-state queues
  Task *next;
  Task *parent;

  jmp_buf state;

  unsigned *stack;
  unsigned stack_len;

  enum RunState {
    Running,
    Blocked,
    Waiting,
    Dead
  };
  RunState run_state;

  int ret_val;

  friend int fall_off_end();

public:
  
  Task(TaskProc proc=0, int val=0, void* ptr=0, int stacksize=9999,
  			int priviliged=0);
  				// use default proc in main() to setup initial task
  				/* Val and ptr are passed into TaskProc when it begins */
				/* to execute.   If proviliged is nonzero, the task will */
				/* be executed once for every call to Yield(). */
  ~Task();
  
  int ReturnValue();
  
  friend int Wait(Task* child=0);
  friend void Return(int rv=0);
  	/* All child tasks are killed when a task returns. */
  friend void Yield();
  friend void Block(Task **my_task_ptr);
  			/* This task won't execute until unblock() is called. */
			/* My_task_ptr points to a place to put an identifier for */
			/* this task; you'll need it to unblock.  Usually used as */
			/* Task *p; Block(&p); ....... Unblock(p); */
			/* Execution doesn't make it out of Block() until Unblock() */
			/* is called (from another task). */
  friend void Unblock(Task *blocked_task);
  friend void Kill(Task *victim_task, int rv=0);
			/* Equivalent to having the victim task call Return(rv) */
};

#endif
