#include <stdio.h>
#include <stdlib.h>

#define TESTFILE "testdata.tmp"

static unsigned char data[5000];
static unsigned char buf[5000];

static int start, length, type, addl;
static int curpos, seek_amt;

void
setup_file(void)
{
  int i;
  FILE *f;
  srand(time(0));
  for (i=0; i<5000; i++)
    data[i] = rand();
  f = fopen(TESTFILE, "wb");
  fwrite(data, 5000, 1, f);
  fclose(f);
}

char *tn[] = { "SET", "CUR", "END" };

int
main()
{
  FILE *f;
  int loops = 0, i, j;

  setup_file();
  f = fopen(TESTFILE, "rb");
  curpos = 0;
  for (i=0; i<1000; i++)
  {
    start = rand() % 5000;
    length = rand() % (5000 - start);
    addl = rand() % 5000;
    switch (rand() % 3)
    {
    case 0:
      type = SEEK_SET;
      seek_amt = start;
      break;
    case 1:
      type = SEEK_CUR;
      seek_amt = start - curpos;
      break;
    case 2:
      type = SEEK_END;
      seek_amt = start - 5000;
      break;
    }

    printf("%4d: %4d len %4d, %s\r", loops, start, length, tn[type]);
    fflush(stdout);
    fseek(f, seek_amt, type);
    fread(buf, length, 1, f);
    if (memcmp(data+start, buf, length))
    {
      printf("Error: data read error, start=%d, length=%d, type=%s, addl=%d, curpos=%d, loops=%d\n",
	     start, length, tn[type], addl, curpos, loops);
      for (j=0; j<10; j++)
	printf("  %02x:%02x", data[start+j], buf[j]);
      printf("\n");
      break;
    }
    fread(buf, addl, 1, f);
    curpos = start + length + addl;
    if (curpos > 5000)
      curpos = 5000;
    loops++;
  }
  fclose(f);
  remove(TESTFILE);
  return 0;
}
