#include <stdio.h>

void
fixdep(char *fn)
{
  FILE *dfile, *ddfile;
  char ddfn[90];
  char line[2000];
  sprintf(ddfn, "deps/%sd", fn);
  dfile = fopen(fn, "r");
  if (!dfile)
    return;
  ddfile = fopen(ddfn, "w");
  if (!ddfile)
  {
    perror(ddfn);
    fclose(dfile);
    return;
  }
  while (fgets(line, 2000, dfile))
  {
    if (strchr(line, ':'))
      fprintf(ddfile, "$(ODIR)/%s", line);
    else
      fputs(line, ddfile);
  }
  fclose(dfile);
  fclose(ddfile);
  remove(fn);
}

int
main(int argc, char **argv)
{
  int i;
  mkdir("deps");
  for (i=1; i<argc; i++)
    fixdep(argv[i]);
  return 0;
}
