/* This is file SCANF.C */
/* This file may have been modified by DJ Delorie (Jan 1991).  If so,
** these modifications are Coyright (C) 1993 DJ Delorie, 24 Kirsten Ave,
** Rochester NH, 03867-2954, USA.
*/

#include <stdio.h>
#include <stdarg.h>

int
scanf(const char *fmt, ...)
{
  int r;
  va_list a;
  va_start(a, fmt);
  r = _doscan(stdin, fmt, a);
  va_end(a);
  return r;
}

int
fscanf(FILE *iop, const char *fmt, ...)
{
  int r;
  va_list a;
  va_start(a, fmt);
  r = _doscan(iop, fmt, a);
  va_end(a);
  return r;
}

int
sscanf(const char *str, const char *fmt, ...)
{
  int r;
  va_list a;
  FILE _strbuf;

  va_start(a, fmt);

  _strbuf._flag = _IOREAD|_IOSTRG;
  _strbuf._ptr = _strbuf._base = (char *)str;
  _strbuf._cnt = 0;
  while (*str++)
    _strbuf._cnt++;
  _strbuf._bufsiz = _strbuf._cnt;
  r = _doscan(&_strbuf, fmt, a);
  va_end(a);
  return r;
}
