#! /usr/bin/perl

use strict "vars";
use Archive::Tar;
use Cwd;

######  Configuration  ############################
my $version = "4.7.2";
my $snapshot = "";
#
my $gmp_version = "5.0.5";
my $mpfr_version = "3.1.1";
my $mpc_version = "1.0.1";
my $autoconf_version = "2.64";
my $automake_version = "1.11.1";
#
my $target = "i586-pc-msdosdjgpp";
###################################################

my $top = cwd;
my @package_files;

my $version_group = GetVersionGroup($version);
my $source_name = GetSourceName($version, $snapshot);
my $rpm_ver = GetRPMVer();

push(@package_files, "README");
push(@package_files, "mk-djcross-gcc.pl");
GenerateSpecFile();
GenerateUnpackGCCScript();
AddPackageFiles("diffs");
AddPackageFiles("diffs2");
sort(@package_files);

print "Writing djcross-gcc-${rpm_ver}.tar.bz2\n";
# Parameter should not be needed, but it does not work otherwise
my $tar = Archive::Tar::new("Archive::Tar");
$tar->Archive::Tar::add_files(@package_files);
foreach my $x (@package_files)
{
    $tar->Archive::Tar::rename($x, "djcross-gcc-$rpm_ver/$x");
}
$tar->Archive::Tar::write(
    "djcross-gcc-${rpm_ver}.tar.bz2",
    COMPRESS_BZIP);

###################################################
sub GenerateSpecFile
{
    my $snapshot_spec = "";
    if ($snapshot)
    {
        $snapshot_spec = "%define snapshot $snapshot";
    }

    my $input_fn = "djcross-gcc.spec.in";
    my $output_fn = "djcross-gcc-${version_group}.spec";
    my ($fdi, $fdo);

    print "Creating $output_fn\n";

    open $fdi, $input_fn
        or die "Failed to open input file $input_fn: $!";

    open $fdo, ">$output_fn"
        or die "Failed to open output file $output_fn: $!";

    while (<$fdi>)
    {
        s/\@__GCCVER__\@/$version/e;
        s/\@__SNAPSHOT_SPEC__\@/$snapshot_spec/e;
        s/\@__GCC_SOURCE_NAME__@/$source_name/e;
        s/\@__RPMVER__\@/$rpm_ver/e;
        s/\@__GMP_VERSION__\@/$gmp_version/e;
        s/\@__MPFR_VERSION__\@/$mpfr_version/e;
        s/\@__MPC_VERSION__\@/$mpc_version/e;
        s/\@__AUTOCONF_VERSION__\@/$autoconf_version/e;
        s/\@__AUTOMAKE_VERSION__\@/$automake_version/e;
        s/\@__TARGET__\@/$target/e;
        print $fdo "$_";
    }

    close $fdi;
    close $fdo;

    push(@package_files, $output_fn);
}

sub GenerateUnpackGCCScript
{
    my $input_fn = "unpack-gcc.sh.in";
    my $output_fn = "unpack-gcc.sh";
    my ($fdi, $fdo);

    my $version_subst = $version;
    if ($snapshot)
    {
        $version_subst = $version_subst . "-$snapshot";
    }

    print "Creating $output_fn\n";

    open $fdi, $input_fn
        or die "Failed to open input file $input_fn: $!";

    open $fdo, ">$output_fn"
        or die "Failed to open output file $output_fn: $!";

    while (<$fdi>)
    {
        s/\@__GCCVER__\@/$version_subst/e;
        print $fdo "$_";
    }

    close $fdi;
    close $fdo;

    push(@package_files, $output_fn);
}

sub AddPackageFiles
{
    my $fdi;
    my $dir = $_[0];

    open $fdi, "find $dir -type f |"
        or die "Failed to list files inside directory $dir: $!";

    while (<$fdi>)
    {
        chomp;
        push(@package_files, $_);
    }

    close $fdi;
}

sub GetVersionGroup
{
    my $ver = $_[0];
    $ver =~ s:\.:_:;
    $ver =~ s:\..*$::;
    $ver =~ s:_:.:;
    return $ver;
}

sub GetSourceName
{
    my $ver = $_[0];
    my $snapshot = $_[1];
    if ($snapshot)
    {
        my $v1 = GetVersionGroup($ver);
        return "${v1}-${snapshot}";
    }
    else
    {
        return $ver;
    }
}

sub GetRPMVer
{
    my $x = $version;
    if ($snapshot)
    {
        $x = $x . "_$snapshot";
    }
    return $x;
}
