#include <copyright.h>
#include <stdio.h>
#include <wattcp.h>
#include <string.h>
#include <elib.h>

extern char *defaultdomain;

getpeername( tcp_Socket *s, void *dest, int *len )
{
    struct sockaddr_wat temp;
    int ltemp;

    memset( &temp, 0, sizeof( struct sockaddr_wat ));
    temp.s_ip = s->hisaddr;
    temp.s_port = s->hisport;

    if (!s->hisaddr || !s->hisport || ! _chk_socket( s )) {
        if (len) *len = 0;
        return( -1 );
    }

    /* how much do we move */
    ltemp = (len) ? *len : sizeof( struct sockaddr_wat);
    if (ltemp > sizeof( struct sockaddr_wat)) ltemp = sizeof( struct sockaddr_wat );
    movmem( &temp, dest, ltemp );

    if (len) *len = ltemp;
    return( 0 );
}

getsockname(  tcp_Socket *s, void *dest, int *len )
{
    struct sockaddr_wat temp;
    int ltemp;

    memset( &temp, 0, sizeof( struct sockaddr_wat ));
    temp.s_ip = s->myaddr;
    temp.s_port = s->myport;

    if (!s->hisaddr || !s->hisport || ! _chk_socket( s )) {
        if (len) *len = 0;
        return( -1 );
    }

    /* how much do we move */
    ltemp = (len) ? *len : sizeof( struct sockaddr_wat );
    if (ltemp > sizeof( struct sockaddr_wat)) ltemp = sizeof( struct sockaddr_wat );
    movmem( &temp, dest, ltemp );

    if (len) *len = ltemp;
    return( 0 );
}

int getdomainname( char *name, int length )
{
    if ( def_domain )
        if ( length < strlen( def_domain ))
           { *name = 0;  return(-1); }
        else
           { strcpy( name, def_domain );  return( 0 ); }

    *name=0;
    return( 0 );
}

int setdomainname( char *string, int len )
{

    if ( len < 0 )
      return (-1);

    if ( len>strlen(string) )
      len=strlen(string);

    if ( strlen(string) < MAX_DOMAIN_LENGTH )
     {
       strncpy( defaultdomain, string, len );
       def_domain = defaultdomain;
       return( 0 );
     }
    else
     return (-1);
}

int gethostname( char *name, int len )
{
    if ( _hostname )
        if (len < strlen( _hostname ))
           { *name = 0; return -1; }
        else
           { strcpy( name, _hostname ); return 0; }

    *name =0;
    return 0;
}

int sethostname( char *name, int len )
{
    if ( len <= 0 )
      return (-1);

    if ( len>strlen(name) )
      len=strlen(name);

    if ( len < MAX_STRING )
     {
       strncpy( _hostname, name , len);
       return( 0 );
     }
    else
     return (-1);
}

void psocket( tcp_Socket *s )
{
    char buffer[255];

    outch( '[' );
    outs( inet_ntoa( buffer, s->hisaddr) );
    outch( ':' );
    itoa( s->hisport, buffer, 10 );
    outs( buffer );
    outch( ']' );

}
