// Associated include file : ColPal.H

#include "sword.h"
#include "colpal.h"

// --- TPhysicalPaletteView

short RegTPhysicalPaletteView;
char *IdentTPhysicalPaletteView = "TPhysicalPaletteView";

DEFINE(TPhysicalPaletteView);

TPhysicalPaletteView::TPhysicalPaletteView()
{ Defaults();
}

TPhysicalPaletteView::TPhysicalPaletteView(int X, int Y)
{ Defaults();
  Init(X,Y);
}

void TPhysicalPaletteView::Defaults(void)
{ // Object identification
  Register=RegTPhysicalPaletteView;
  Ident=IdentTPhysicalPaletteView;
  // Other default values
  // ...
}

void TPhysicalPaletteView::Init(int X, int Y)
{ // Base construction
  TZone::Init(X,Y,256,50);
  // Other constructions
  // ...
}

void TPhysicalPaletteView::Draw(TRect )
{ int  i;
  byte h,s,v,r,g,b;
  switch(ColorMode)
  { case colMODE_16 :
      for(i=0;i<16;i++)
      { SetColor(i);
        Bar(i*16,0,i*16+15,Where.Height()-1);
      }
      break;
    case colMODE_256 :
      for(i=0;i<256;i++)
      { SetColor(i);
        LineY(i,0,Where.Height()-1);
      }
      break;
    case colMODE_TrueColor :
      for(i=0;i<256;i++)
      { h=i; s=200; v=200;
        HSV2RGB(h,s,v,r,g,b);
        SetColor(Dither->GetRGBColor(0,0,r,g,b));
        LineY(i,0,Where.Height()-1);
      }
      break;
  }
}

// --- TTrueColorPaletteView

short RegTTrueColorPaletteView;
char *IdentTTrueColorPaletteView = "TTrueColorPaletteView";

DEFINE(TTrueColorPaletteView);

TTrueColorPaletteView::TTrueColorPaletteView()
{ Defaults();
}

TTrueColorPaletteView::TTrueColorPaletteView(int X, int Y)
{ Defaults();
  Init(X,Y);
}

void TTrueColorPaletteView::Defaults(void)
{ // Object identification
  Register=RegTTrueColorPaletteView;
  Ident=IdentTTrueColorPaletteView;
  // Other default values
  // ...
}

void TTrueColorPaletteView::Init(int X, int Y)
{ // Base construction
  TZone::Init(X,Y,384,64);
  // Other constructions
  // ...
}

void TTrueColorPaletteView::Draw(TRect )
{ int  i,j,k,x,y;
  byte r,g,b;
  for(k=0;k<6;k++)
    for(j=0;j<64;j++)
      for(i=0;i<64;i++)
      { x=i+k*64;
        y=j;
        r=i*4; g=j*4; b=k*51;
        SetColor(Dither->GetRGBColor(x,y,r,g,b));
        PutPixel(x,y);
      }
}

