/* --------------------------------------------------------------------------
   Project S.W.O.R.D
   V2.10

   SubSystem : Mathematical toolbox
   ErrorNos  : 4000..4099
   File      : Include/ToolBox/Math/Vector.H
   Author    : Eric NICOLAS
   Overview  : Variable size vectors arithmetics
   UpDate    : Mar 03, 1996

** Copyright (C) 1993-1996 The SWORD Group
**
** This file is distributed under the terms listed in the document
** "copying.en". A copy of "copying.en" should accompany this file.
** if not, a copy should be available from where this file was obtained.
** This file may not be distributed without a verbatim copy of "copying.en".
**
** This file is distributed WITHOUT ANY WARRANTY; without even the implied
** warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
** ------------------------------------------------------------------------*/

#ifndef _TOOLBOX_MATH_VECTOR_H_
#define _TOOLBOX_MATH_VECTOR_H_

#define erVector_OutOfSize     4000
#define erVector_MixingSizes   4001

class TVector;

extern int VectorDefaultSize;

// --- Object TVector

class TVector
{ // --- Datas
  protected:
    int      Size;
    complex *Tabl;
  // --- Functions
  public:
  // Constructors / Destructor
    TVector(int eSize=VectorDefaultSize);
    TVector(TVector& V);
    virtual ~TVector();
            void Reset(void);
  // Using vectors
    TVector  operator=(TVector& V);
    complex& operator()(int N);
    int     &size() { return Size; }
  // Operations on vectors
  // -,+,*,/ : Element to Element
    TVector  operator+(TVector& V);
    TVector  operator+=(TVector& V);
    TVector  operator-(TVector& V);
    TVector  operator-=(TVector& V);
    TVector  operator*(TVector& V);
    TVector  operator*=(TVector& V);
    TVector  operator/(TVector& V);
    TVector  operator/=(TVector& V);
  // Operations between vectors and complexes
    friend   TVector  operator*(TVector& V, complex  C);
    friend   TVector  operator*(complex  C, TVector& V);
             TVector  operator*=(complex C);
    friend   TVector  operator/(TVector& V, complex  C);
    friend   TVector  operator/(complex  C, TVector& V);
             TVector  operator/=(complex C);
  // %,^ : Scalar and Vectorial product
    complex  operator%(TVector& V);
    TVector  operator^(TVector& V);
  // Functions on vectors
    friend float norm(TVector& V);    // = V%V
    friend float abs(TVector& V);     // = sqrt(V%V)
};

// Inline functions

inline complex &TVector::operator()(int N)
{ if (N<0)     { Error=erVector_OutOfSize; N=0;      }
  if (N>=Size) { Error=erVector_OutOfSize; N=Size-1; }
  return Tabl[N];
}

#endif // _TOOLBOX_MATH_VECTOR_H_

/* --------------------------------------------------------------------------
** HISTORY
** --------------------------------------------------------------------------
** 2.10:
**   03/03/96 :EN: First History remark. Copying code V2.00->V2.10
** ------------------------------------------------------------------------*/
