/* --------------------------------------------------------------------------
	Project S.W.O.R.D
	V2.10

	SubSystem : Drivers for hardware and OS access
	File      : Include/Drivers/Dir.H
	ErrNos    : 500..599
	Author    : Eric NICOLAS
	Overview  : Functions for Directory Lists access
	UpDate    : Mar 13, 1996

** Copyright (C) 1993-1996 The SWORD Group
**
** This file is distributed under the terms listed in the document
** "copying.en". A copy of "copying.en" should accompany this file.
** if not, a copy should be available from where this file was obtained.
** This file may not be distributed without a verbatim copy of "copying.en".
**
** This file is distributed WITHOUT ANY WARRANTY; without even the implied
** warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
** ------------------------------------------------------------------------*/

#ifndef _DRIVERS_DIR_H_
#define _DRIVERS_DIR_H_

#define erCantOpenPathForDirList 500

// boolean return values :
//     TRUE  when an error occured
//     FALSE when everything is OK

// Directory list access

struct TDirEntry
{ char      FName[260];
  char      Path[260];
  TTimeDate Time;
  boolean   Directory;
};

void   *OpenDirList(char *Path);
boolean ReadDirEntry(TDirEntry& Entry, void *Handle);
void    CloseDirList(void *Handle);

// Directory manipulation

void    MakeDir(char *Path);

// File informations

boolean GetFileInformations(char *Path, char *FName, TDirEntry& Entry);
boolean FileExist(char *Path, char *FName);

#endif // _DRIVERS_DIR_H_

/* --------------------------------------------------------------------------
** HISTORY
** --------------------------------------------------------------------------
** 2.10:
**   13/03/96 :EN: Creation
** ------------------------------------------------------------------------*/
