/* --------------------------------------------------------------------------
	Project S.W.O.R.D
	V2.10

	SubSystem : Basic functions usefull for all the system
	File      : Include/Common/Defines.H
	Author    : Eric NICOLAS
	Overview  : Automatic detection of compiler/os/grxlib
	UpDate    : Apr 13, 1996

** Copyright (C) 1993-1996 The SWORD Group
**
** This file is distributed under the terms listed in the document
** "copying.en". A copy of "copying.en" should accompany this file.
** if not, a copy should be available from where this file was obtained.
** This file may not be distributed without a verbatim copy of "copying.en".
**
** This file is distributed WITHOUT ANY WARRANTY; without even the implied
** warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
** ------------------------------------------------------------------------*/

#ifndef _COMMON_DEFINES_H_
#define _COMMON_DEFINES_H_

#undef SYSTEM

// ----- TURBOC Section ----------------------------------------------------

#ifdef __TURBOC__
  #define _TURBOC_
  #define _MSDOS_
  #define _GRX1_
  #define SYSTEM "MSDOS 16-bit (TurboC)"
#endif

// ----- DJGPP Section ------------------------------------------------------

#ifdef __GO32__

#if (__DJGPP__ > 1)
  // DJGPP V2
  #define _DJGPP_ 2
  #define _V2_
  #define _MSDOS_
  #define _GRX20_
  #define SYSTEM "MSDOS 32-bit (DJGPP V2)"
#else
  // DJGPP V1
  #define _DJGPP_ 1
  #define _V1_
  #define _MSDOS_
  #define _GRX1_
  #define SYSTEM "MSDOS 32-bit (DJGPP V1)"
#endif

#endif

// ------ SYSTEM not supported

#ifndef SYSTEM
  #error System/Compiler/Graphic library not supported !
#endif

// ----- UNIX Section -------------------------------------------------------

/*
#ifdef _UNIX_
  #ifdef _SOLARIS_
    #define SYSTEM "UNIX 32-bit (Solaris)"
  #endif
  #ifdef _SUNOS_
    #define SYSTEM "UNIX 32-bit (SunOS)"
  #endif
  #ifdef _LINUX_
    #define SYSTEM "UNIX 32-bit (Linux)"
  #endif
#endif
*/

#endif // _COMMON_DEFINES_H_

/* --------------------------------------------------------------------------
** HISTORY
** --------------------------------------------------------------------------
** 2.10:
**   13/04/96 :EN: Initial version
** ------------------------------------------------------------------------*/
