// Associated include file : Graphics/Graphics.H

#include "common/common.h"
#include "drivers/drivers.h"
#include "mecanism/mecanism.h"
#include "graphics/graphics.h"

// ----- Local variables

static char *Messages[1] =
      { "Mouse driver not found" };

#include "Graphics/M_Arrow.INC"
#include "Graphics/M_Hand.INC"
#include "Graphics/M_Size1.INC"
#include "Graphics/M_Size2.INC"
#include "Graphics/M_Button.INC"
#include "Graphics/M_Inact.INC"
#include "Graphics/M_Text.INC"

// ===== Gestion locale des erreurs =========================================

static boolean ErrorMessages(char *Message)
{ int MessageNo;
  switch(Error)
  { case erNoMouseDetected: MessageNo=0;   break;
    default:
      return FALSE;
  }
  strcpy(Message,Messages[MessageNo]);
  return TRUE;
}

// ----- Functions

void InitGraphics(void)
{ int i;
  // Gestionnaire local d'erreur
  AddErrorHandler(ErrorMessages);
  // Enregistrement des objets du module Graphics
  RegisterObject(new TScreenZone()   ,&RegTScreenZone);
  RegisterObject(new TZone()         ,&RegTZone);
  RegisterObject(new TDesktop()      ,&RegTDesktop);
  RegisterObject(new TWindow()       ,&RegTWindow);
  RegisterObject(new TScreenBitmap() ,&RegTScreenBitmap);
  RegisterObject(new TMapping()      ,&RegTMapping);
  RegisterObject(new TSysIcone()     ,&RegTSysIcone);
  RegisterObject(new TMappingObject(),&RegTMappingObject);
  RegisterObject(new TShell()        ,&RegTShell);
  // Bascule en mode graphique
  GrSetMode(GR_width_height_color_graphics,
            SetUp.ScreenX,SetUp.ScreenY,SetUp.ScreenColors);
  NoClip=TRect(0,0,GrMaxX(),GrMaxY());
  Debug("  GRMODE...    Resolution X   = %d\n"
        "               Resolution Y   = %d\n",GrMaxX()+1,GrMaxY()+1);
  InitColors();
  // Cration des divers curseurs de souris
  TColor ColorTable[6];
  ColorTable[0]=5;
  for(i=0;i<5;i++)
    ColorTable[i+1]=NoSysColor[i];
#ifdef _GRX20_
  CurMouse[0]=GrBuildCursor(MouseArrow     ,12,12,16, 1, 1,ColorTable);
  CurMouse[1]=GrBuildCursor(MouseHand      ,16,16,17, 8, 8,ColorTable);
  CurMouse[2]=GrBuildCursor(MouseSize1     ,12,12,20, 6,10,ColorTable);
  CurMouse[3]=GrBuildCursor(MouseSize2     ,12,12,20, 6,10,ColorTable);
  CurMouse[4]=GrBuildCursor(MouseButton    ,15,15,15, 7, 7,ColorTable);
  CurMouse[5]=GrBuildCursor(MouseInactivity,26,26,26,13,13,ColorTable);
  CurMouse[6]=GrBuildCursor(MouseText      ,7, 7 ,16, 3, 8,ColorTable);
#else
  CurMouse[0]=GrBuildCursor(MouseArrow     ,12,16, 1, 1,ColorTable);
  CurMouse[1]=GrBuildCursor(MouseHand      ,16,17, 8, 8,ColorTable);
  CurMouse[2]=GrBuildCursor(MouseSize1     ,12,20, 6,10,ColorTable);
  CurMouse[3]=GrBuildCursor(MouseSize2     ,12,20, 6,10,ColorTable);
  CurMouse[4]=GrBuildCursor(MouseButton    ,15,15, 7, 7,ColorTable);
  CurMouse[5]=GrBuildCursor(MouseInactivity,26,26,13,13,ColorTable);
  CurMouse[6]=GrBuildCursor(MouseText      , 7,16, 3, 8,ColorTable);
#endif
  // Initialise la bibliothque de gestion souris
  if (!GrMouseDetect())
  { Error=erNoMouseDetected;
    ErrorViewer();
  }
  GrMouseEventMode(1);
  GrMouseEventEnable(TRUE,TRUE);
  GrMouseInit();
  GrMouseSetCursor(CurMouse[0]);
  GrMouseDisplayCursor();
  // Init of Font and Mapping managing
  InitMapping();
  InitFont();
  // Sortie de vrification Debug
  Debug("  GRAPHICS...  Initialized.\n");
}

void DoneGraphics(void)
{ DoneFont();
  DoneMapping();
  DoneColors();
  GrMouseUnInit();
  // Destruction des divers curseurs de souris
  GrDestroyCursor(CurMouse[0]);
  GrDestroyCursor(CurMouse[1]);
  GrDestroyCursor(CurMouse[2]);
  GrDestroyCursor(CurMouse[3]);
  GrDestroyCursor(CurMouse[4]);
  // Retour au mode texte
#ifdef _GRX20_
  GrSetModeRestore(0);
#endif
  GrSetMode(GR_80_25_text);
  Debug("  GRAPHICS...  Closed.\n");
}
