/*************************************************************
 ***************    ===The Window System===    ***************
 *************************************************************
				Copyright (c)1995,1996 Malcolm Taylor

 -> SYSTEM.H
 -> WinSystem class and various system wide functions.
*/

#ifndef _system_h
#define _system_h

#include <types.h>
#include <graphics.h>
#include <tws/clipbord.h>
#include <tws/queue.h>
#include <tws/timer.h>
#include <tws/cursors.h>
#include <tws/eventque.h>
#include <tws/config.h>

class Window;


class WinSystem {
	public:
		WinSystem();
		~WinSystem();

		void Init(const char *config_name);
		
		inline void CatchMouseFocus(Window *wnd)     
			{ MouseFocus=wnd; }        // Causes all the mouse events to be dispatched to wnd.
		inline void ReleaseMouseFocus()
			{ MouseFocus=NULL; }
		inline void CatchKeyFocus(Window *wnd)
			{ KeyFocus=wnd; }          // Causes all the keyboard events to be dispatched to wnd.
		inline void ReleaseKeyFocus()
			{ KeyFocus=NULL; }
		inline Window *GetKeyFocus()
			{ return KeyFocus; }
		inline void QueueEvent(Window *win,const event &ev)
			{ queue.AddItem(win,ev); } // Puts an event in the queue ready to be processed.
		inline void CleanUpEvents(Window *win)
			{ queue.DestroyMatchingItems(win); }
		void CheckMouseOrKey();
		void CheckTimers();
		int CheckForEvents();         // Checks for pending events and processes them.
		int RunEvents();              // Runs events until blocked by stop.
		inline void StopRunningEvents()
			{ StopEventLoop=TRUE; }    // Stops RunEvents().
		inline void ResetEvents()
			{ StopEventLoop=FALSE; }   // Starts RunEvents().
		inline Window *GetTopWindow()
			{ return Top; }            // Returns the top window (whole screen).
		void StartTimer(Window *wnd,int length);
		void StopTimer(Window *wnd);

		inline void SetupMouseCursor(Cursor *c)
		{
			MouseCursor=c;
			if(UnderMouse)
				DeleteBuffer(UnderMouse);
			UnderMouse=NewBuffer(c->cursor->width,c->cursor->height);
		}
		inline void DisplayMouse() 
		{
			if(isMouseDisplayed)
				return;
			BltFromScreen(UnderMouse,mousex-MouseCursor->hotx,mousey-MouseCursor->hoty);
			BitBltCursor(MouseCursor,mousex,mousey);
			isMouseDisplayed=TRUE;
		}
		inline void HideMouse()
		{
			if(!isMouseDisplayed)
				return;
			BltToScreen(UnderMouse,mousex-MouseCursor->hotx,mousey-MouseCursor->hoty);
			isMouseDisplayed=FALSE;
		}
		void HideMouseInRectangle(int x1,int y1,int x2,int y2);
		inline int GetDeskWidth()
			{ return VideoData.width; }
		inline int GetDeskHeight()
			{ return VideoData.height; }
		inline void SetClipBoard(const char *txt,int len=-1,int pos=0)
			{ clip.SetClipBoard(txt,len,pos); }
		inline char *GetClipBoard()
			{ return clip.GetClipBoard(); }
		inline char *GetConfigItem(const char *name)
			{ return config->GetItem(name); }
		void ShellToDos();
		void RefreshDesktop();
		inline void SetTopDocument(Window *wnd)
			{ TopDocument=wnd; }
		inline void QueueDocumentEvent(const event &ev)
			{ if(TopDocument) QueueEvent(TopDocument,ev); }
		void StartSound();
		void StopSound();
		
	private:
		Window *MouseFocus,*KeyFocus,*Top,*TopDocument;
		BOOL StopEventLoop;
		EventQueue queue;
		TimerEvent *timers;
		Cursor *MouseCursor;
		ViewBuffer *UnderMouse;
		int mousex,mousey;
		int isMouseDisplayed;
		int video_mode;
		ClipBoard clip;
		ConfigFile *config;
		int system_red,system_green,system_blue;
		int isSound,isPlaying;
};

extern FONT *SysFont,*SysFontBold,*SysFontBoldItallic,*SysFontItallic;
												// The system fonts.

extern "C" {
void Error(const char *s);    // Causes the program to exit with an error.
};

extern WinSystem ws;
		
void HDip(ViewBuffer*,int x1,int x2,int y,int c1=9,int c2=17);
void VDip(ViewBuffer*,int x,int y1,int y2,int c1=9,int c2=18);
void HBump(ViewBuffer*,int x1,int x2,int y,int c1=9,int c2=17);
void VBump(ViewBuffer*,int x,int y1,int y2,int c1=9,int c2=18);

void Frame(ViewBuffer*,int x1,int y1,int x2,int y2);
void InvFrame(ViewBuffer*,int x1,int y1,int x2,int y2);
void FrameBox(ViewBuffer*,int x1,int y1,int x2,int y2,int w,int c=14);
void InvFrameBox(ViewBuffer*,int x1,int y1,int x2,int y2,int w,int c=14);
int StringWidth1(const char *text);
void WriteText1(ViewBuffer *buf,int x,int y,int c,const char *text);


#endif


