/*
 * Copyright (C) 1996, jack
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

/* $Id: wctype.c,v 1.1 1996/07/09 10:01:49 jack Exp $ */

#include <stddef.h>
#include <string.h>
#include <wctype.h>
#include <wcprvt.h>

wctype_t
wctype (const char *property)
{
  int l, m, r;
  int s;
  int c1, c2;

  if (property == NULL)
    return (wctype_t) 0;

  l = 0; /* left(start) point */
  m = 0; /* middle point */
  r = __wcprops_num - 1; /* right(end) point */
  c2 = *(unsigned char *) property;

  /* binary search */
  while (l <= r)
    {
      m = (l + r) / 2;
      c1 = *(unsigned char *) __wcprops[m]->name;
      s = c1 - c2;
      if (s == 0)
	s = strcmp (__wcprops[m]->name, property);
      if (s < 0)
	l = m + 1;
      else if (s > 0)
	r = m - 1;
      else
	return (wctype_t) (m + 1);
    }

  /* not found */
  return (wctype_t) 0;
}
