-- lua program to test dynamic library support with DJGPP.

so_library = "./djgpp/libtest1.so"
sin_function = "_lib_compute_sin"
cos_function = "_lib_compute_cos"
print(string.format('Test of package.loadlib() for \"%s\" and functions\n\"%s\" and \"%s\".', so_library, sin_function, cos_function))
print("Computes the sin and cos values 0, 30, 60 and 90 degrees." )
sin_function = package.loadlib(so_library, sin_function)
cos_function = package.loadlib(so_library, cos_function)
pi_half = 1.5707963267948966192313216916398
step = pi_half / 3
for x = 0, pi_half, step do
  local sin_value = sin_function(x)
  local cos_value = cos_function(x)
  local arg = x * 90 / pi_half
  print(string.format('sin(%f) = %f  cos(%f) = %f', arg, sin_value, arg, cos_value))
end
