#! /bin/sh

#
# Adjust the paths to files used in html pages
# and rename them to DOS licit names.
#
# List must be updated.
#

cd ../doc/libogg

# Map of file names that are illicit on DOS file system.
ILLICIT_NAMES_MAP=(
"ogg_iovec_t.html               : iovec_t.html"
"ogg_packet.html                : packet.html"
"ogg_packet_clear.html          : packet_clear.html"
"ogg_page.html                  : page.html"
"ogg_page_bos.html              : page_bos.html"
"ogg_page_checksum_set.html     : page_checksum_set.html"
"ogg_page_continued.html        : page_continued.html"
"ogg_page_eos.html              : page_eos.html"
"ogg_page_granulepos.html       : page_granulepos.html"
"ogg_page_packets.html          : page_packets.html"
"ogg_page_pageno.html           : page_pageno.html"
"ogg_page_serialno.html         : page_serialno.html"
"ogg_page_version.html          : page_version.html"
"ogg_stream_check.html          : stmcheck.html"
"ogg_stream_clear.html          : stmclear.html"
"ogg_stream_destroy.html        : stmdestroy.html"
"ogg_stream_eos.html            : stmeos.html"
"ogg_stream_flush.html          : stmflush.html"
"ogg_stream_flush_fill.html     : stmflush_fill.html"
"ogg_stream_init.html           : stminit.html"
"ogg_stream_iovecin.html        : stmiovecin.html"
"ogg_stream_packetin.html       : stmpktin.html"
"ogg_stream_packetout.html      : stmpktout.html"
"ogg_stream_packetpeek.html     : stmpktpeek.html"
"ogg_stream_pagein.html         : stmpgin.html"
"ogg_stream_pageout.html        : stmpgout.html"
"ogg_stream_pageout_fill.html   : stmpgout_fill.html"
"ogg_stream_reset.html          : stmrst.html"
"ogg_stream_reset_serialno.html : stmrst_serialno.html"
"ogg_stream_state.html          : stmstate.html"
"ogg_sync_buffer.html           : sync_buffer.html"
"ogg_sync_check.html            : sync_check.html"
"ogg_sync_clear.html            : sync_clear.html"
"ogg_sync_destroy.html          : sync_destroy.html"
"ogg_sync_init.html             : sync_init.html "
"ogg_sync_pageout.html          : sync_pgout.html"
"ogg_sync_pageseek.html         : sync_pgseek.html"
"ogg_sync_reset.html            : sync_reset.html"
"ogg_sync_state.html            : sync_state.html"
"ogg_sync_wrote.html            : sync_wrote.html"

"oggpack_adv.html               : pkadv.html"
"oggpack_adv1.html              : pkadv1.html"
"oggpack_bits.html              : pkbits.html"
"oggpack_buffer.html            : pkbuffer.html"
"oggpack_bytes.html             : pkbytes.html"
"oggpack_get_buffer.html        : pkget_buffer.html"
"oggpack_look.html              : pklook.html"
"oggpack_look1.html             : pklook1.html"
"oggpack_read.html              : pkread.html"
"oggpack_read1.html             : pkread1.html"
"oggpack_readinit.html          : pkreadinit.html"
"oggpack_reset.html             : pkreset.html"
"oggpack_write.html             : pkwrt.html"
"oggpack_writealign.html        : pkwrtalign.html"
"oggpack_writecheck.html        : pkwrtcheck.html"
"oggpack_writeclear.html        : pkwrtclear.html"
"oggpack_writecopy.html         : pkwrtcopy.html"
"oggpack_writeinit.html         : pkwrtinit.html"
"oggpack_writetrunc.html        : pkwrttrunc.html"
)

# Create sed script to modify the file content.
rm script.sed
for NAME_PAIR in "${ILLICIT_NAMES_MAP[@]}"; do
  OLD_NAME=$(echo ${NAME_PAIR} | sed "s|[ ]\+: .*$||")
  NEW_NAME=$(echo ${NAME_PAIR} | sed "s|^.* : ||")
  echo "/<a href=\"${OLD_NAME}\">/s|${OLD_NAME}|${NEW_NAME}|g" >> script.sed
done

# Rename files and change their paths.
for NAME_PAIR in "${ILLICIT_NAMES_MAP[@]}"; do
  OLD_NAME=$(echo ${NAME_PAIR} | sed "s|[ ]\+: .*$||")
  NEW_NAME=$(echo ${NAME_PAIR} | sed "s|^.* : ||")
  sed -f script.sed ${OLD_NAME} > ${NEW_NAME}
#  dtou ${NEW_NAME}
#  diff -aU1 ${OLD_NAME} ${NEW_NAME} > ${NEW_NAME}.txt
  rm -vf ${OLD_NAME}
done


# Change illicit file names in the rest of the files.
FILES=$(echo *.html)
for FILE in ${FILES}; do
  sed -f script.sed ${FILE} > ${FILE}.txt
  dtou ${FILE}.txt
  mv -vf ${FILE}.txt ${FILE}
done

# Adjust libogg/Makefile.in accordingly.
cat > fix.sed << EOF
  s,^.*/s|,s|,;s/g$//
1i\\
/^dist_apidoc_DATA[ 	]*=[ 	]*/,/^$/ {
\$a\\
}
EOF
sed -f fix.sed script.sed > script.txt
sed -f script.txt Makefile.in > makefile.txt
dtou Makefile.txt
mv -vf Makefile.txt Makefile.in

rm -f script.sed script.txt fix.sed
