#include <Lib3d/ColourRamp.H>
#include <Lib3d/Vector.H>
#include <Lib3d/Viewport.H>

ColourRamp::ColourRamp()
    : data( 0 )
{
}

ColourRamp::~ColourRamp()
{ 
    delete data; 
}

void   
ColourRamp::build(Viewport &viewport, 
		  const Vector3 &ambient, 
		  const Vector3 &diffuse )
{
    int i;

    if (!data) data = new Colour[256+100];

    Vector3 tmp;
    Vector3 inc;
    tmp.assign( ambient );
    inc.scale( diffuse, 1.0/256.0 );
    for (i = 0 ; i < 50 ; i++) {
	//data[i] = viewport.getColour(0,0,0);
	data[i] = viewport.getColour(255,70,70);
    }
    for (i = 257+50 ; i < 256+100 ; i++) {
	data[i] = viewport.getColour(0,0,255*(i%2));
    }
    for (i = 50 ; i < 257+50 ; i++) {
#if 0
	data[i] = viewport.getColour(64+((i-5)>>2),
				     64+((i-5)>>2),
				     64+((i-5)>>2));
#else
	data[i] = viewport.getColour(uint(tmp.v[R]), 
				     uint(tmp.v[G]), 
				     uint(tmp.v[B]));
#endif
	tmp.add( inc );
	tmp.clamp( 255.0 );
    }
}

void   
ColourRamp::fallback(Viewport &viewport, 
		     const Vector3 &colour)
{
    if (!data) data = new Colour[266];

    data[0] = viewport.getColour(uint(colour.v[R]), 
				 uint(colour.v[G]), 
				 uint(colour.v[B]));

    for (int i = 1 ; i < 266 ; i++) {
	data[i] = data[0];
    }
}

