#! /bin/sh

#
# Adjust the paths to files used in html pages
# and rename them to DOS licit names.
#
# List must be updated.
#

cd ../doc/html

# Map of file names that are illicit on DOS file system.
ILLICIT_NAMES_MAP=(
"documentation_bugs.html            : bugs.html"
"documentation_example_code.html    : example_code.html"
"documentation_format_overview.html : format_overview.html"
"documentation_tools.html           : tools.html"
"documentation_tools_flac.html      : tools_flac.html"
"documentation_tools_metaflac.html  : tools_metaflac.html"
)

# Create sed script to modify the file content.
rm script.sed
for NAME_PAIR in "${ILLICIT_NAMES_MAP[@]}"; do
  OLD_NAME=$(echo ${NAME_PAIR} | sed "s|[ ]\+: .*$||")
  NEW_NAME=$(echo ${NAME_PAIR} | sed "s|^.* : ||")
  echo "/<a href=\"${OLD_NAME}\">/s|${OLD_NAME}|${NEW_NAME}|g" >> script.sed
done

# Rename files and change their paths.
for NAME_PAIR in "${ILLICIT_NAMES_MAP[@]}"; do
  OLD_NAME=$(echo ${NAME_PAIR} | sed "s|[ ]\+: .*$||")
  NEW_NAME=$(echo ${NAME_PAIR} | sed "s|^.* : ||")
  sed -f script.sed ${OLD_NAME} > ${NEW_NAME}
#  dtou ${NEW_NAME}
#  diff -aU1 ${OLD_NAME} ${NEW_NAME} > ${NEW_NAME}.txt
  rm -vf ${OLD_NAME}
done


# Change illicit file names in the rest of the files.
FILES=$(echo *.html)
for FILE in ${FILES}; do
  sed -f script.sed ${FILE} > ${FILE}.txt
  dtou ${FILE}.txt
  mv -vf ${FILE}.txt ${FILE}
done

# Adjust doc/Makefile.in accordingly.
cat > fix.sed << EOF
  s,^.*/s|,s|,;s/g$//
1i\\
/^html_DATA[ 	]*=[ 	]*/,/^$/ {
\$a\\
}
EOF
sed -f fix.sed script.sed > script.txt
sed -f script.txt Makefile.in > makefile.txt
dtou Makefile.txt
mv -vf Makefile.txt Makefile.in

rm -f script.sed script.txt fix.sed
